#!/bin/sh
# This file is part of ke-recv
#
# Copyright (C) 2004-2006 Nokia Corporation. All rights reserved.
#
# Contact: Kimmo Hmlinen <kimmo.hamalainen@nokia.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License 
# version 2 as published by the Free Software Foundation. 
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301 USA

DEV=$1
LABELFILE=$2
if [ "x$LABELFILE" = "x" ]; then
  LABELFILE="/tmp/.mmc-volume-label"
fi

# read the MMC volume label
TMP=`/usr/sbin/mmc-rename $DEV 2> /dev/null`
if [ $? = 0 ]; then
  if [ "${TMP}x" = "(no label)x" ]; then
    exec echo -n "" > "$LABELFILE"
  else
    exec echo -n "$TMP" > "$LABELFILE"
  fi
else
  echo -n "" > "$LABELFILE"
  exit 1
fi
