#!/bin/sh
# This file is part of ke-recv
#
# Copyright (C) 2005-2006 Nokia Corporation. All rights reserved.
#
# Contact: Kimmo Hmlinen <kimmo.hamalainen@nokia.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License 
# version 2 as published by the Free Software Foundation. 
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301 USA

PDEV=$1  ;# preferred device (partition)
DEV=$2   ;# device possibly containing PDEV as partition

MP=$3    ;# mount point (optional)
if [ "x$MP" = "x" ]; then
  MP=$MMC_MOUNTPOINT
fi

grep "$PDEV " /proc/mounts > /dev/null
if [ $? != 0 ]; then
  PART_EXISTS=1
  # wait until (or verify) the partition info is available
  I=3
  while [ 1 ]; do
    if [ -e $PDEV ]; then
      break
    fi
    I=`expr $I - 1`
    if [ $I -lt 1 ]; then
      PART_EXISTS=0
      break
    fi
    sleep 1
  done

  if [ $PART_EXISTS = 1 ]; then
    echo "$0: partition $PDEV found"
    DEVICE=$PDEV
  else
    echo "$0: partition $PDEV not found"
    grep "$DEV " /proc/mounts > /dev/null
    if [ $? = 0 ]; then
      echo "$0: $DEV is already mounted"
      exit 0
    fi
    DEVICE=$DEV
  fi

  mmc-mount $DEVICE $MP
  RC=$?
  if [ $RC != 0 ]; then
    mount -t ext2 $DEVICE $MP > /dev/null
    RC=$?
    if [ $RC = 0 ]; then
      chown user:users $MP
    fi
  fi
  exit $RC
else
  echo "$0: $PDEV is already mounted"
  exit 0
fi
