require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SCHED_H)) {
    eval 'sub _LINUX_SCHED_H () {1;}' unless defined(&_LINUX_SCHED_H);
    require 'asm/param.ph';
    require 'linux/config.ph';
    require 'linux/capability.ph';
    require 'linux/threads.ph';
    require 'linux/kernel.ph';
    require 'linux/types.ph';
    require 'linux/timex.ph';
    require 'linux/jiffies.ph';
    require 'linux/rbtree.ph';
    require 'linux/thread_info.ph';
    require 'linux/cpumask.ph';
    require 'asm/system.ph';
    require 'asm/semaphore.ph';
    require 'asm/page.ph';
    require 'asm/ptrace.ph';
    require 'asm/mmu.ph';
    require 'linux/smp.ph';
    require 'linux/sem.ph';
    require 'linux/signal.ph';
    require 'linux/securebits.ph';
    require 'linux/fs_struct.ph';
    require 'linux/compiler.ph';
    require 'linux/completion.ph';
    require 'linux/pid.ph';
    require 'linux/percpu.ph';
    eval 'sub CSIGNAL () {0xff;}' unless defined(&CSIGNAL);
    eval 'sub CLONE_VM () {0x100;}' unless defined(&CLONE_VM);
    eval 'sub CLONE_FS () {0x200;}' unless defined(&CLONE_FS);
    eval 'sub CLONE_FILES () {0x400;}' unless defined(&CLONE_FILES);
    eval 'sub CLONE_SIGHAND () {0x800;}' unless defined(&CLONE_SIGHAND);
    eval 'sub CLONE_IDLETASK () {0x1000;}' unless defined(&CLONE_IDLETASK);
    eval 'sub CLONE_PTRACE () {0x2000;}' unless defined(&CLONE_PTRACE);
    eval 'sub CLONE_VFORK () {0x4000;}' unless defined(&CLONE_VFORK);
    eval 'sub CLONE_PARENT () {0x8000;}' unless defined(&CLONE_PARENT);
    eval 'sub CLONE_THREAD () {0x10000;}' unless defined(&CLONE_THREAD);
    eval 'sub CLONE_NEWNS () {0x20000;}' unless defined(&CLONE_NEWNS);
    eval 'sub CLONE_SYSVSEM () {0x40000;}' unless defined(&CLONE_SYSVSEM);
    eval 'sub CLONE_SETTLS () {0x80000;}' unless defined(&CLONE_SETTLS);
    eval 'sub CLONE_PARENT_SETTID () {0x100000;}' unless defined(&CLONE_PARENT_SETTID);
    eval 'sub CLONE_CHILD_CLEARTID () {0x200000;}' unless defined(&CLONE_CHILD_CLEARTID);
    eval 'sub CLONE_DETACHED () {0x400000;}' unless defined(&CLONE_DETACHED);
    eval 'sub CLONE_UNTRACED () {0x800000;}' unless defined(&CLONE_UNTRACED);
    eval 'sub CLONE_CHILD_SETTID () {0x1000000;}' unless defined(&CLONE_CHILD_SETTID);
    eval 'sub CLONE_STOPPED () {0x2000000;}' unless defined(&CLONE_STOPPED);
    eval 'sub CLONE_KERNEL () {( &CLONE_FS |  &CLONE_FILES |  &CLONE_SIGHAND);}' unless defined(&CLONE_KERNEL);
    eval 'sub FSHIFT () {11;}' unless defined(&FSHIFT);
    eval 'sub FIXED_1 () {(1<< &FSHIFT);}' unless defined(&FIXED_1);
    eval 'sub LOAD_FREQ () {(5* &HZ);}' unless defined(&LOAD_FREQ);
    eval 'sub EXP_1 () {1884;}' unless defined(&EXP_1);
    eval 'sub EXP_5 () {2014;}' unless defined(&EXP_5);
    eval 'sub EXP_15 () {2037;}' unless defined(&EXP_15);
    eval 'sub CALC_LOAD {
        local($load,$exp,$n) = @_;
	    eval q($load *= $exp; $load += $n*( &FIXED_1-$exp); $load >>=  &FSHIFT;);
    }' unless defined(&CALC_LOAD);
    eval 'sub CT_TO_SECS {
        local($x) = @_;
	    eval q((($x) /  &HZ));
    }' unless defined(&CT_TO_SECS);
    eval 'sub CT_TO_USECS {
        local($x) = @_;
	    eval q(((($x) %  &HZ) * 1000000/ &HZ));
    }' unless defined(&CT_TO_USECS);
    require 'linux/time.ph';
    require 'linux/param.ph';
    require 'linux/resource.ph';
    require 'linux/timer.ph';
    require 'asm/processor.ph';
    eval 'sub TASK_RUNNING () {0;}' unless defined(&TASK_RUNNING);
    eval 'sub TASK_INTERRUPTIBLE () {1;}' unless defined(&TASK_INTERRUPTIBLE);
    eval 'sub TASK_UNINTERRUPTIBLE () {2;}' unless defined(&TASK_UNINTERRUPTIBLE);
    eval 'sub TASK_STOPPED () {4;}' unless defined(&TASK_STOPPED);
    eval 'sub TASK_ZOMBIE () {8;}' unless defined(&TASK_ZOMBIE);
    eval 'sub TASK_DEAD () {16;}' unless defined(&TASK_DEAD);
    eval 'sub __set_task_state {
        local($tsk, $state_value) = @_;
	    eval q( &do { ($tsk)-> &state = ($state_value); }  &while (0));
    }' unless defined(&__set_task_state);
    eval 'sub set_task_state {
        local($tsk, $state_value) = @_;
	    eval q( &set_mb(($tsk)-> &state, ($state_value)));
    }' unless defined(&set_task_state);
    eval 'sub __set_current_state {
        local($state_value) = @_;
	    eval q( &do {  ($current->{state}) = ($state_value); }  &while (0));
    }' unless defined(&__set_current_state);
    eval 'sub set_current_state {
        local($state_value) = @_;
	    eval q( &set_mb( ($current->{state}), ($state_value)));
    }' unless defined(&set_current_state);
    eval 'sub SCHED_NORMAL () {0;}' unless defined(&SCHED_NORMAL);
    eval 'sub SCHED_FIFO () {1;}' unless defined(&SCHED_FIFO);
    eval 'sub SCHED_RR () {2;}' unless defined(&SCHED_RR);
    if(defined(&__KERNEL__)) {
	require 'linux/spinlock.ph';
	eval 'sub MAX_SCHEDULE_TIMEOUT () { &LONG_MAX;}' unless defined(&MAX_SCHEDULE_TIMEOUT);
	eval 'sub MAX_MAP_COUNT () {(65536);}' unless defined(&MAX_MAP_COUNT);
	require 'linux/aio.ph';
	if(defined(&CONFIG_HUGETLB_PAGE)) {
	}
	eval 'sub MAX_USER_RT_PRIO () {100;}' unless defined(&MAX_USER_RT_PRIO);
	eval 'sub MAX_RT_PRIO () { &MAX_USER_RT_PRIO;}' unless defined(&MAX_RT_PRIO);
	eval 'sub MAX_PRIO () {( &MAX_RT_PRIO + 40);}' unless defined(&MAX_PRIO);
	eval 'sub rt_task {
	    local($p) = @_;
    	    eval q((($p)-> &prio <  &MAX_RT_PRIO));
	}' unless defined(&rt_task);
	eval 'sub INIT_USER () {( &root_user);}' unless defined(&INIT_USER);
	eval 'sub get_task_struct {
	    local($tsk) = @_;
    	    eval q( &do {  &atomic_inc(($tsk)-> &usage); }  &while(0));
	}' unless defined(&get_task_struct);
	eval 'sub put_task_struct {
	    local($tsk) = @_;
    	    eval q( &do {  &if ( &atomic_dec_and_test(($tsk)-> &usage))  &__put_task_struct($tsk); }  &while(0));
	}' unless defined(&put_task_struct);
	eval 'sub PF_ALIGNWARN () {0x1;}' unless defined(&PF_ALIGNWARN);
	eval 'sub PF_STARTING () {0x2;}' unless defined(&PF_STARTING);
	eval 'sub PF_EXITING () {0x4;}' unless defined(&PF_EXITING);
	eval 'sub PF_FORKNOEXEC () {0x40;}' unless defined(&PF_FORKNOEXEC);
	eval 'sub PF_SUPERPRIV () {0x100;}' unless defined(&PF_SUPERPRIV);
	eval 'sub PF_DUMPCORE () {0x200;}' unless defined(&PF_DUMPCORE);
	eval 'sub PF_SIGNALED () {0x400;}' unless defined(&PF_SIGNALED);
	eval 'sub PF_MEMALLOC () {0x800;}' unless defined(&PF_MEMALLOC);
	eval 'sub PF_MEMDIE () {0x1000;}' unless defined(&PF_MEMDIE);
	eval 'sub PF_FLUSHER () {0x2000;}' unless defined(&PF_FLUSHER);
	eval 'sub PF_FREEZE () {0x4000;}' unless defined(&PF_FREEZE);
	eval 'sub PF_IOTHREAD () {0x8000;}' unless defined(&PF_IOTHREAD);
	eval 'sub PF_FROZEN () {0x10000;}' unless defined(&PF_FROZEN);
	eval 'sub PF_FSTRANS () {0x20000;}' unless defined(&PF_FSTRANS);
	eval 'sub PF_KSWAPD () {0x40000;}' unless defined(&PF_KSWAPD);
	eval 'sub PF_SWAPOFF () {0x80000;}' unless defined(&PF_SWAPOFF);
	eval 'sub PF_LESS_THROTTLE () {0x100000;}' unless defined(&PF_LESS_THROTTLE);
	eval 'sub PF_SYNCWRITE () {0x200000;}' unless defined(&PF_SYNCWRITE);
	if(defined(&CONFIG_SMP)) {
	} else {
	}
	if(defined(&CONFIG_NUMA)) {
	} else {
	    eval 'sub sched_balance_exec () {
	        eval q({});
	    }' unless defined(&sched_balance_exec);
	    eval 'sub node_nr_running_init () {
	        eval q({});
	    }' unless defined(&node_nr_running_init);
	}
	unless(defined(&INIT_THREAD_SIZE)) {
	    eval 'sub INIT_THREAD_SIZE () {2048*$sizeof{\'long\'};}' unless defined(&INIT_THREAD_SIZE);
	}
	unless(defined(&__HAVE_ARCH_KSTACK_END)) {
	}
	require 'asm/current.ph';
	eval 'sub SEND_SIG_NOINFO () {( 0);}' unless defined(&SEND_SIG_NOINFO);
	eval 'sub SEND_SIG_PRIV () {( 1);}' unless defined(&SEND_SIG_PRIV);
	eval 'sub SEND_SIG_FORCED () {( 2);}' unless defined(&SEND_SIG_FORCED);
	if(defined(&CONFIG_SECURITY)) {
	} else {
	}
	if(defined(&CONFIG_SMP)) {
	} else {
	    eval 'sub wait_task_inactive {
	        local($p) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&wait_task_inactive);
	}
	eval 'sub remove_parent {
	    local($p) = @_;
    	    eval q( &list_del_init(($p)-> &sibling));
	}' unless defined(&remove_parent);
	eval 'sub add_parent {
	    local($p, $parent) = @_;
    	    eval q( &list_add_tail(($p)-> &sibling,($parent)-> &children));
	}' unless defined(&add_parent);
	eval 'sub REMOVE_LINKS {
	    local($p) = @_;
    	    eval q( &do {  &if ( &thread_group_leader($p))  &list_del_init(($p)-> &tasks);  &remove_parent($p); }  &while (0));
	}' unless defined(&REMOVE_LINKS);
	eval 'sub SET_LINKS {
	    local($p) = @_;
    	    eval q( &do {  &if ( &thread_group_leader($p))  &list_add_tail(($p)-> &tasks, ($init_task->{tasks}));  &add_parent($p, ($p)-> &parent); }  &while (0));
	}' unless defined(&SET_LINKS);
	eval 'sub next_task {
	    local($p) = @_;
    	    eval q( &list_entry(($p)-> ($tasks->{next}), 1;
	}' unless defined(&next_task);
	eval 'sub prev_task {
	    local($p) = @_;
    	    eval q( &list_entry(($p)-> ($tasks->{prev}), 1;
	}' unless defined(&prev_task);
	eval 'sub for_each_process {
	    local($p) = @_;
    	    eval q( &for ($p =  &init_task ; ($p =  &next_task($p)) !=  &init_task ; ));
	}' unless defined(&for_each_process);
	eval 'sub do_each_thread {
	    local($g, $t) = @_;
    	    eval q( &for ($g = $t =  &init_task ; ($g = $t =  &next_task($g)) !=  &init_task ; )  &do);
	}' unless defined(&do_each_thread);
	eval 'sub while_each_thread {
	    local($g, $t) = @_;
    	    eval q( &while (($t =  &next_thread($t)) != $g));
	}' unless defined(&while_each_thread);
	eval 'sub thread_group_leader {
	    local($p) = @_;
    	    eval q(( ($p->{pid}) ==  ($p->{tgid})));
	}' unless defined(&thread_group_leader);
	eval 'sub delay_group_leader {
	    local($p) = @_;
    	    eval q(( &thread_group_leader($p)  && ! &thread_group_empty($p)));
	}' unless defined(&delay_group_leader);
	if(defined(&CONFIG_SMP)) {
	} else {
	}
    }
}
1;
