require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_GENERIC_CPUMASK_ARRAY_H)) {
    eval 'sub __ASM_GENERIC_CPUMASK_ARRAY_H () {1;}' unless defined(&__ASM_GENERIC_CPUMASK_ARRAY_H);
    eval 'sub CPU_ARRAY_SIZE () { &BITS_TO_LONGS( &NR_CPUS);}' unless defined(&CPU_ARRAY_SIZE);
    eval 'sub cpu_set {
        local($cpu, $map) = @_;
	    eval q( &set_bit($cpu, ($map). &mask));
    }' unless defined(&cpu_set);
    eval 'sub cpu_clear {
        local($cpu, $map) = @_;
	    eval q( &clear_bit($cpu, ($map). &mask));
    }' unless defined(&cpu_clear);
    eval 'sub cpu_isset {
        local($cpu, $map) = @_;
	    eval q( &test_bit($cpu, ($map). &mask));
    }' unless defined(&cpu_isset);
    eval 'sub cpu_test_and_set {
        local($cpu, $map) = @_;
	    eval q( &test_and_set_bit($cpu, ($map). &mask));
    }' unless defined(&cpu_test_and_set);
    eval 'sub cpus_and {
        local($dst,$src1,$src2) = @_;
	    eval q( &bitmap_and(($dst). &mask,($src1). &mask, ($src2). &mask,  &NR_CPUS));
    }' unless defined(&cpus_and);
    eval 'sub cpus_or {
        local($dst,$src1,$src2) = @_;
	    eval q( &bitmap_or(($dst). &mask, ($src1). &mask, ($src2). &mask,  &NR_CPUS));
    }' unless defined(&cpus_or);
    eval 'sub cpus_clear {
        local($map) = @_;
	    eval q( &bitmap_clear(($map). &mask,  &NR_CPUS));
    }' unless defined(&cpus_clear);
    eval 'sub cpus_complement {
        local($map) = @_;
	    eval q( &bitmap_complement(($map). &mask,  &NR_CPUS));
    }' unless defined(&cpus_complement);
    eval 'sub cpus_equal {
        local($map1, $map2) = @_;
	    eval q( &bitmap_equal(($map1). &mask, ($map2). &mask,  &NR_CPUS));
    }' unless defined(&cpus_equal);
    eval 'sub cpus_empty {
        local($map) = @_;
	    eval q( &bitmap_empty( ($map->{mask}),  &NR_CPUS));
    }' unless defined(&cpus_empty);
    eval 'sub cpus_weight {
        local($map) = @_;
	    eval q( &bitmap_weight(($map). &mask,  &NR_CPUS));
    }' unless defined(&cpus_weight);
    eval 'sub cpus_shift_right {
        local($d, $s, $n) = @_;
	    eval q( &bitmap_shift_right(($d). &mask, ($s). &mask, $n,  &NR_CPUS));
    }' unless defined(&cpus_shift_right);
    eval 'sub cpus_shift_left {
        local($d, $s, $n) = @_;
	    eval q( &bitmap_shift_left(($d). &mask, ($s). &mask, $n,  &NR_CPUS));
    }' unless defined(&cpus_shift_left);
    eval 'sub first_cpu {
        local($map) = @_;
	    eval q( &find_first_bit(($map). &mask,  &NR_CPUS));
    }' unless defined(&first_cpu);
    eval 'sub next_cpu {
        local($cpu, $map) = @_;
	    eval q( &find_next_bit(($map). &mask,  &NR_CPUS, $cpu + 1));
    }' unless defined(&next_cpu);
    eval 'sub cpus_coerce {
        local($map) = @_;
	    eval q((($map). $mask[0]));
    }' unless defined(&cpus_coerce);
    eval 'sub cpus_promote {
        local($map) = @_;
	    eval q(({  &cpumask_t  &__cpu_mask =  &CPU_MASK_NONE;  ($__cpu_mask->{mask[0]}) = $map;  &__cpu_mask; }));
    }' unless defined(&cpus_promote);
    eval 'sub cpumask_of_cpu {
        local($cpu) = @_;
	    eval q(({  &cpumask_t  &__cpu_mask =  &CPU_MASK_NONE;  &cpu_set($cpu,  &__cpu_mask);  &__cpu_mask; }));
    }' unless defined(&cpumask_of_cpu);
    eval 'sub any_online_cpu {
        local($map) = @_;
	    eval q(({  &cpumask_t  &__tmp__;  &cpus_and( &__tmp__, $map,  &cpu_online_map);  &find_first_bit( ($__tmp__->{mask}),  &NR_CPUS); }));
    }' unless defined(&any_online_cpu);
    eval 'sub CPU_MASK_ALL () {{ {[0...  &CPU_ARRAY_SIZE-1] = ~0} };}' unless defined(&CPU_MASK_ALL);
    eval 'sub CPU_MASK_NONE () {{ {[0...  &CPU_ARRAY_SIZE-1] = 0} };}' unless defined(&CPU_MASK_NONE);
}
1;
