require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_GENERIC_CPUMASK_ARITH_H)) {
    eval 'sub __ASM_GENERIC_CPUMASK_ARITH_H () {1;}' unless defined(&__ASM_GENERIC_CPUMASK_ARITH_H);
    eval 'sub cpu_set {
        local($cpu, $map) = @_;
	    eval q( &set_bit($cpu, ($map)));
    }' unless defined(&cpu_set);
    eval 'sub cpu_clear {
        local($cpu, $map) = @_;
	    eval q( &clear_bit($cpu, ($map)));
    }' unless defined(&cpu_clear);
    eval 'sub cpu_isset {
        local($cpu, $map) = @_;
	    eval q( &test_bit($cpu, ($map)));
    }' unless defined(&cpu_isset);
    eval 'sub cpu_test_and_set {
        local($cpu, $map) = @_;
	    eval q( &test_and_set_bit($cpu, ($map)));
    }' unless defined(&cpu_test_and_set);
    eval 'sub cpus_and {
        local($dst,$src1,$src2) = @_;
	    eval q( &do { $dst = ($src1) & ($src2); }  &while (0));
    }' unless defined(&cpus_and);
    eval 'sub cpus_or {
        local($dst,$src1,$src2) = @_;
	    eval q( &do { $dst = ($src1) | ($src2); }  &while (0));
    }' unless defined(&cpus_or);
    eval 'sub cpus_clear {
        local($map) = @_;
	    eval q( &do { $map = 0; }  &while (0));
    }' unless defined(&cpus_clear);
    eval 'sub cpus_complement {
        local($map) = @_;
	    eval q( &do { $map = ~($map); }  &while (0));
    }' unless defined(&cpus_complement);
    eval 'sub cpus_equal {
        local($map1, $map2) = @_;
	    eval q((($map1) == ($map2)));
    }' unless defined(&cpus_equal);
    eval 'sub cpus_empty {
        local($map) = @_;
	    eval q((($map) == 0));
    }' unless defined(&cpus_empty);
    if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 32) {
	eval 'sub cpus_weight {
	    local($map) = @_;
    	    eval q( &hweight32($map));
	}' unless defined(&cpus_weight);
    }
 elsif((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 64) {
	eval 'sub cpus_weight {
	    local($map) = @_;
    	    eval q( &hweight64($map));
	}' unless defined(&cpus_weight);
    }
    eval 'sub cpus_shift_right {
        local($dst, $src, $n) = @_;
	    eval q( &do { $dst = ($src) >> ($n); }  &while (0));
    }' unless defined(&cpus_shift_right);
    eval 'sub cpus_shift_left {
        local($dst, $src, $n) = @_;
	    eval q( &do { $dst = ($src) << ($n); }  &while (0));
    }' unless defined(&cpus_shift_left);
    eval 'sub any_online_cpu {
        local($map) = @_;
	    eval q(({  &cpumask_t  &__tmp__;  &cpus_and( &__tmp__, $map,  &cpu_online_map);  &__tmp__ ?  &first_cpu( &__tmp__) :  &NR_CPUS; }));
    }' unless defined(&any_online_cpu);
    eval 'sub CPU_MASK_ALL () {(~(0) >> (8*$sizeof{ &cpumask_t} -  &NR_CPUS));}' unless defined(&CPU_MASK_ALL);
    eval 'sub CPU_MASK_NONE () {(0);}' unless defined(&CPU_MASK_NONE);
    eval 'sub cpus_coerce {
        local($map) = @_;
	    eval q((($map)));
    }' unless defined(&cpus_coerce);
    eval 'sub cpus_promote {
        local($map) = @_;
	    eval q(({ $map; }));
    }' unless defined(&cpus_promote);
    eval 'sub cpumask_of_cpu {
        local($cpu) = @_;
	    eval q(({ (1) << ($cpu); }));
    }' unless defined(&cpumask_of_cpu);
    eval 'sub first_cpu {
        local($map) = @_;
	    eval q( &__ffs($map));
    }' unless defined(&first_cpu);
    eval 'sub next_cpu {
        local($cpu, $map) = @_;
	    eval q( &find_next_bit(($map),  &NR_CPUS, $cpu + 1));
    }' unless defined(&next_cpu);
}
1;
