/**
 * @file libgalago/galago-assert.h Assertion API
 * @ingroup Utility
 *
 * @Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_ASSERT_H_
#define _GALAGO_ASSERT_H_

#include <glib.h>

G_BEGIN_DECLS

#ifdef __GNUC__
# define galago_goto_if_fail(cond, label) \
	if (G_UNLIKELY(!(cond))) \
	{ \
		g_log(G_LOG_DOMAIN, G_LOG_LEVEL_CRITICAL, \
			  "file %s: line %d (%s): assertion `%s' failed\n", \
			  __FILE__, __LINE__, __PRETTY_FUNCTION__, #cond); \
		goto label; \
	}
#else /* !__GNUC__ */
# define galago_goto_if_fail(cond, label) \
	if (G_UNLIKELY(!(cond))) \
	{ \
		g_log(G_LOG_DOMAIN, G_LOG_LEVEL_CRITICAL, \
			  "file %s: line %d: assertion `%s' failed\n", \
			  __FILE__, __LINE__, #cond); \
		goto label; \
	}
#endif /* !__GNUC__ */

G_END_DECLS

#endif /* _GALAGO_ASSERT_H_ */
