/*
 * This file is part of osso-dsp-headers-su-18
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Markku Vorne <markku.vorne@nokia.com>
 *
 * This software, including documentation, is protected by copyright controlled by Nokia Corporation. All rights are reserved.
 * Copying, including reproducing, storing, adapting or translating, any or all of this material requires the prior written  
 * consent of Nokia Corporation. This material also contains confidential information which may not be disclosed to others 
 * without the prior written consent of Nokia.
 */

#ifndef __AUDIOPP_DSPTASK_H__
#define __AUDIOPP_DSPTASK_H__

#include "audio_dsptask.h"

#define NUM_BANDS          5
#define LINE_SEGMENT_COUNT 5

typedef struct EQ_RUNTIME_PARAMS {
    unsigned short int dsp_cmd;      // Void; not used here
    unsigned short int use_eq;       // Enable/disable equaliser.
    short int          size;         // Void; added for future compatibility.
    unsigned short int order;        // Filter order.
    short int          bands;        // Number of bands.
    unsigned short int band[10];     // Band limits.
    short int          level_db[10]; // Band levels.
    unsigned short int alignment;    //void not used here
} EQ_RUNTIME_PARAMS;

typedef struct MUSICDRC_RUNTIME_PARAMS {
    unsigned short int dsp_cmd;      // DSP_CMD_SET_POSTPROC_EQ_PARAMS
    unsigned short int alignment;    // Used for alignment purposes.

    /* For crossband control. */
    short int          linkCoeffSelf;
    short int          linkCoeffOthers;
    
    /* For limiter. */
    short int          lim_attCoeff;
    short int          lim_relCoeff;
    long int           limiterThreshold;  
    long int           limGain;  
    
    /* For attack and release time filtering. */
    long int           attCoeff[NUM_BANDS];
    long int           relCoeff[NUM_BANDS];
    
    /* For the average amplitude to gain calculation. */
    long int           levelLimits[NUM_BANDS][LINE_SEGMENT_COUNT];
    long int           K[NUM_BANDS][LINE_SEGMENT_COUNT+1];
    long int           A[NUM_BANDS][LINE_SEGMENT_COUNT+1];
    
    /* For enable/disable MuMDRC algorithm */
    unsigned short int use_mumdrc;  
    
    /* For tracing. */
    long int           Gain[NUM_BANDS];
    long int           amplitudes[NUM_BANDS]; 
} MUSICDRC_RUNTIME_PARAMS;

typedef struct MUSICDRC_HPFILTER_COEFFS {
    unsigned short int dsp_cmd;      // DSP_CMD_CHANGE_MUSICDRC_HPFILT_COEFFS
    unsigned short int use_hpfilt;
    short int          coeffs[32];
} MUSICDRC_HPFILTER_COEFFS;

typedef struct POSTPROCCESSING_BYPASS_DATA {
    unsigned short int dsp_cmd;           
    unsigned short int audio_pp_bypassed; // If set to 1, audio post proc. will
                                          // be bypassed.
} POSTPROCCESSING_BYPASS_DATA;

typedef struct IGEQ_Params {
    short int          size;       // Must be the first variable in params struct
    unsigned short int max_order;  // Maximum filter order.
    short int          max_bands;  // Maximum number of bands.
    short int          nb_samples; // Number of samples passed to FIR filter.
} IGEQ_Params;

typedef struct IMUMDRC_Params {
    /* For QMF framework. */
    short int          maxDelayCompanderMs;
    unsigned short int SampleRate;
    
    /* For hp-filter. */
    unsigned short int max_nbr_iir_blocks;
    
    /* For limiter. */
    short int          maxDelayLimiterMs;
} IMUMDRC_Params;

typedef struct POSTPROC_INIT_PARAMS {
    unsigned short int       dsp_cmd;             // DSP_CMD_SET_POSTPROC_INIT_PARAMS
    unsigned short int 	     alignment;  	  /*used for alignment purposes */
    AUDIO_PARAMS_DATA        audio_params;
    IGEQ_Params              EQ_init_params;      // Equaliser init parameters.
    EQ_RUNTIME_PARAMS        EQ_runtime_params;   // Equaliser runtime parameters
    IMUMDRC_Params           MUSICDRC_init_params;// Music DRC init parameters.
    MUSICDRC_RUNTIME_PARAMS  MUSICDRC_runtime_params;
    MUSICDRC_HPFILTER_COEFFS hp_filter_coeffs;
} POSTPROC_INIT_PARAMS;

typedef struct POSTPROC_ALGORITHM_PARAMS {
    unsigned short int       dsp_cmd;             // DSP_CMD_GET_POSTPROC_PARAMS
    unsigned short int       status;
    EQ_RUNTIME_PARAMS        EQ_runtime_params;
    MUSICDRC_RUNTIME_PARAMS  MUSICDRC_runtime_params;
    MUSICDRC_HPFILTER_COEFFS MUSICDRC_hpfilter_coeffs;
} POSTPROC_ALGORITHM_PARAMS;

/* ======== IMUMDRC_Status ========
 * The status structure defines the parameters that can be changed during 
 * real-time operation of the algorithm. */

typedef struct IMUMDRC_Status {
    /* For crossband control. */
    short int          linkCoeffSelf;
    short int          linkCoeffOthers;
    
    /* For limiter. */
    short int          lim_attCoeff;
    short int          lim_relCoeff;
    long int           limiterThreshold;  
    long int           limGain;  
    
    /* For attack and release time filtering. */
    long int           attCoeff[NUM_BANDS];
    long int           relCoeff[NUM_BANDS];
    
    /* For the average amplitude to gain calculation. */
    long int           levelLimits[NUM_BANDS][LINE_SEGMENT_COUNT];
    long int           K[NUM_BANDS][LINE_SEGMENT_COUNT+1];
    long int           A[NUM_BANDS][LINE_SEGMENT_COUNT+1];
    
    /* For enable/disable MuMDRC algorithm. */
    unsigned short int use_mumdrc;
    
    /* For tracing. */
    long int           Gain[NUM_BANDS];
    long int           amplitudes[NUM_BANDS]; 
} IMUMDRC_Status;

#endif // #ifndef __AUDIOPP_DSPTASK_H__
