require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_CPUMASK_H)) {
    eval 'sub __LINUX_CPUMASK_H () {1;}' unless defined(&__LINUX_CPUMASK_H);
    require 'linux/config.ph';
    require 'linux/kernel.ph';
    require 'linux/threads.ph';
    require 'linux/types.ph';
    require 'linux/bitmap.ph';
    if((defined(&NR_CPUS) ? &NR_CPUS : 0) > (defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)  && (defined(&NR_CPUS) ? &NR_CPUS : 0) != 1) {
	eval 'sub CPU_ARRAY_SIZE () { &BITS_TO_LONGS( &NR_CPUS);}' unless defined(&CPU_ARRAY_SIZE);
    } else {
    }
    if(defined(&CONFIG_SMP)) {
	if((defined(&NR_CPUS) ? &NR_CPUS : 0) > (defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)) {
	    require 'asm-generic/cpumask_array.ph';
	} else {
	    require 'asm-generic/cpumask_arith.ph';
	}
    } else {
	require 'asm-generic/cpumask_up.ph';
    }
    if((defined(&NR_CPUS) ? &NR_CPUS : 0) <= 4*(defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)) {
	require 'asm-generic/cpumask_const_value.ph';
    } else {
	require 'asm-generic/cpumask_const_reference.ph';
    }
    if(defined(&CONFIG_SMP)) {
	eval 'sub num_online_cpus () {
	    eval q( &cpus_weight( &cpu_online_map));
	}' unless defined(&num_online_cpus);
	eval 'sub cpu_online {
	    local($cpu) = @_;
    	    eval q( &cpu_isset($cpu,  &cpu_online_map));
	}' unless defined(&cpu_online);
    } else {
	eval 'sub cpu_online_map () { &cpumask_of_cpu(0);}' unless defined(&cpu_online_map);
	eval 'sub num_online_cpus () {
	    eval q(1);
	}' unless defined(&num_online_cpus);
	eval 'sub cpu_online {
	    local($cpu) = @_;
    	    eval q(({  &BUG_ON(($cpu) != 0); 1; }));
	}' unless defined(&cpu_online);
    }
    eval 'sub for_each_cpu {
        local($cpu, $map) = @_;
	    eval q( &for ($cpu =  &first_cpu_const($map); $cpu <  &NR_CPUS; $cpu =  &next_cpu_const($cpu,$map)));
    }' unless defined(&for_each_cpu);
    eval 'sub for_each_online_cpu {
        local($cpu, $map) = @_;
	    eval q( &for ($cpu =  &first_cpu_const($map); $cpu <  &NR_CPUS; $cpu =  &next_online_cpu($cpu,$map)));
    }' unless defined(&for_each_online_cpu);
}
1;
