/*
 * This file is part of lessertunjo
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Kuisma Salonen <kuisma.salonen@nokia.com>
 * Author: Kuisma Salonen <kuisma.salonen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


/**
 * @file shadowapp.h
 * 
 * shadow application library, game side header
 * <p>
 *
 * @author Kuisma Salonen <kuisma.salonen@nokia.com>
 */

#ifndef _SHADOW_APPLICATION_HEADER_
#define _SHADOW_APPLICATION_HEADER_

#ifdef __cplusplus
extern "C" {
#endif

#define SAPP_REALBUF_LEN        256

/**
 * \defgroup libshadowappd libshadowapp daemon side user functions
 *
 * @{
 */

typedef int     sapp_boolean;

/**
 * @brief Main shadowapp context. This should be considered as private
 * and be used only through libshadowapp functions.
 */
typedef struct sapp_data_ {
  int realbuflen, sockfd;
  struct sockaddr_un *saddr;
  char inbuf[16], realbuf[SAPP_REALBUF_LEN];

  char *configuration_socket;

  int command;

  /* "object oriented" design :D */
  int (*deinit)(struct sapp_data_ *);
  int (*smain)(struct sapp_data_ *, int);

  /* function pointers */
  int (*msg_cb_flush)(int);
  int (*msg_cb_restart)(int);
  int (*msg_cb_continue)(int);
  int (*msg_cb_exit)(int);
  int (*msg_cb_quit)(int);
  int (*msg_cb_top)(int);
} sapp_data;


sapp_data *sapp_initialize(int argc, char *argv[]);
int sapp_deinitialize(sapp_data *context);
int sapp_quit(sapp_data *context);
sapp_boolean sapp_check(sapp_data *context);
int sapp_set_msg_cb_top(sapp_data *context, int (*cb_func)(int));
int sapp_set_msg_cb_exit(sapp_data *context, int (*cb_func)(int));
int sapp_set_msg_cb_quit(sapp_data *context, int (*cb_func)(int));
int sapp_set_msg_cb_continue(sapp_data *context, int (*cb_func)(int));
int sapp_set_msg_cb_restart(sapp_data *context, int (*cb_func)(int));
int sapp_set_msg_cb_flush(sapp_data *context, int (*cb_func)(int));
int sapp_mainloop(sapp_data *, int);
int sapp_handle_received(sapp_data *);
int sapp_pause(sapp_data *context);

/* additional gconf requesting functions */
int sapp_gconf_request_int(sapp_data *context, char *value_path, int *dest);
int sapp_gconf_request_string(sapp_data *context, char *value_path, char *dest);
int sapp_gconf_request_bool(sapp_data *context, char *value_path, char *dest);

extern int sapp_error;

#define SAPP_TRUE       1
#define SAPP_FALSE      0

#define SAPP_ERROR_NONE            0
#define SAPP_ERROR_NOMEMORY       -1
#define SAPP_ERROR_INVALIDPARAMS  -2
#define SAPP_ERROR_SOCKET         -3
#define SAPP_ERROR_CONNECTION     -4
#define SAPP_ERROR_CONNANOTHER    -5
#define SAPP_ERROR_WRONGID        -6
#define SAPP_ERROR_BYE            -7
#define SAPP_ERROR_BYESEND        -8
#define SAPP_ERROR_CONNECTIONLOST -9
#define SAPP_ERROR_FILEOPEN       -10
#define SAPP_ERROR_FILEFORMAT     -11
#define SAPP_ERROR_OSSOINIT       -12
#define SAPP_ERROR_EXECUTION      -13
#define SAPP_ERROR_INVALIDARGS    -14
#define SAPP_ERROR_QUIT           -15
#define SAPP_ERROR_NOVALUE        -16

#define SAPP_FLAGS_BLOCK           1

/***
  if we would like to test if our function pointer
  is valid
                                                 ***/
/*
#define SAPP_EXECUTE  0
#define SAPP_TEST     1
#define SAPP_TEST_OK  2
*/

#ifdef __cplusplus
}
#endif
#endif /* _SHADOW_APPLICATION_HEADER_ */
