/*
 * This file is part of osso-dsp-headers-su-18
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Markku Vorne <markku.vorne@nokia.com>
 *
 * This software, including documentation, is protected by copyright controlled by Nokia Corporation. All rights are reserved.
 * Copying, including reproducing, storing, adapting or translating, any or all of this material requires the prior written  
 * consent of Nokia Corporation. This material also contains confidential information which may not be disclosed to others 
 * without the prior written consent of Nokia.
 */

#ifndef __AUDIO_DSPTASK_H__
#define __AUDIO_DSPTASK_H__

#define CHANNELS_1            0x01 // One channel.
#define CHANNELS_2            0x02 // Two channels.
#define STRM_RECORD           0x01 // Recording stream.
#define STRM_PLAYBACK         0x02 // Playback stream.
#define DSP_AFMT_U8	          0x01 // PCM unsigned 8 bits/sample.
#define DSP_AFMT_S16_LE	      0x02 // PCM signed 16 bits/sample little endian.
#define DSP_AFMT_S16_BE	      0x03 // PCM signed 16 bits/sample big endian.
#define DSP_AFMT_S8	          0x04 // PCM signed 8 bits/sample.
#define DSP_AFMT_U16_LE	      0x05 // PCM unsigned 16 bits/sample little endian.
#define DSP_AFMT_U16_BE	      0x06 // PCM unsigned 16 bits/sample big endian.
#define DSP_AFMT_ALAW         0x07 // PCM A-law companded.
#define DSP_AFMT_ULAW         0x08 // PCM u-law companded.
#define DSP_AFMT_MP3          0x09 // MP3 stream.
#define DSP_AFMT_AAC          0x0A // AAC stream.
#define DSP_AFMT_AMR          0x0B // AMR stream.
#define DSP_AFMT_MP2          0x0C // MP2 stream.
#define DSP_AFMT_ILBC         0x0D // iLBC stream.
#define DSP_AFMT_G729         0x0E // G.729 stream.
#define DSP_AFMT_AMRNB        0x0F // AMRNB stream.
#define DSP_AFMT_ALAW_DTX     0x10 // ALAW DTX stream.
#define DSP_AFMT_ULAW_DTX     0x11 // ULAW DTX stream.
#define DSP_AFMT_ILBC_DTX     0x12 // ILBC DTX stream.
#define DSP_AFMT_G729_DTX     0x13 // G.729 DTX stream.

/* Sample rates. */
#define SAMPLE_RATE_96KHZ     0x00
#define SAMPLE_RATE_88_2KHZ   0x01
#define SAMPLE_RATE_64KHZ     0x02
#define SAMPLE_RATE_48KHZ     0x03
#define SAMPLE_RATE_44_1KHZ   0x04
#define SAMPLE_RATE_32KHZ     0x05
#define SAMPLE_RATE_24KHZ     0x06
#define SAMPLE_RATE_22_05KHZ  0x07
#define SAMPLE_RATE_16KHZ     0x08
#define SAMPLE_RATE_12KHZ     0x09
#define SAMPLE_RATE_11_025KHZ 0x0A
#define SAMPLE_RATE_8KHZ      0x0B

typedef struct volume_data {
    unsigned short int dsp_cmd;
    unsigned short int scale;
    short int power2;
} VOLUME_DATA;

typedef struct panning_data {
    unsigned short int dsp_cmd;
    unsigned short int left_gain;
    unsigned short int right_gain;
    unsigned short int steps;
} PANNING_DATA;

typedef struct audio_status_info {
    unsigned short int dsp_cmd;
    unsigned short int stream_ID;
    unsigned short int ds_stream_ID;
    unsigned short int bridge_buffer_size;
    unsigned short int mmap_buffer_size;
    unsigned short int status;
    unsigned long int  num_frames;
    unsigned short int sample_rate;
    unsigned short int number_channels;
    unsigned short int vol_scale;
    short int          vol_power2;
    short int          left_gain;
    short int          right_gain;
    short int          dsp_audio_fmt;
} AUDIO_STATUS_INFO;

typedef struct audio_init_status {
    unsigned short int dsp_cmd;
    unsigned short int init_status;
    unsigned short int stream_ID;
    unsigned short int bridge_buffer_size;
    unsigned short int mmap_buffer_size;
} AUDIO_INIT_STATUS;

/* DSP audio task initialisation data. */
typedef struct audio_params_data {
    unsigned short int dsp_cmd;
    unsigned short int audio_fmt;
    unsigned short int sample_rate;
    unsigned short int number_channels;
    unsigned short int ds_stream_ID;
    unsigned short int stream_priority;
} AUDIO_PARAMS_DATA;

typedef struct {
    unsigned short int dsp_cmd;
    unsigned short int audio_fmt;
    unsigned short int sample_rate;
    unsigned short int ds_stream_ID;
    unsigned short int stream_priority;
    unsigned short int frame_size;
} SPEECH_PARAMS_DATA;

typedef struct DMA_CONTROL_DATA {
    unsigned short int dsp_cmd; 
    unsigned short int DMA_enable;
} DMA_CONTROL_DATA;

#endif // #ifndef __AUDIO_DSPTASK_H__
