require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_TIME_H)) {
    eval 'sub _LINUX_TIME_H () {1;}' unless defined(&_LINUX_TIME_H);
    unless(defined(&__KERNEL__)) {
	require 'time.ph';
    } else {
	require 'asm/param.ph';
	require 'linux/types.ph';
	unless(defined(&_STRUCT_TIMESPEC)) {
	    eval 'sub _STRUCT_TIMESPEC () {1;}' unless defined(&_STRUCT_TIMESPEC);
	}
	if(defined(&__KERNEL__)) {
	    require 'linux/spinlock.ph';
	    require 'linux/seqlock.ph';
	    require 'linux/timex.ph';
	    require 'asm/div64.ph';
	    unless(defined(&div_long_long_rem)) {
		eval 'sub div_long_long_rem {
		    local($dividend,$divisor,$remainder) = @_;
    		    eval q(({  &u64  &result = $dividend; *$remainder =  &do_div( &result,$divisor);  &result; }));
		}' unless defined(&div_long_long_rem);
	    }
	    eval 'sub INITIAL_JIFFIES () {( (-300* &HZ));}' unless defined(&INITIAL_JIFFIES);
	    eval 'sub MAX_JIFFY_OFFSET () {((~0 >> 1)-1);}' unless defined(&MAX_JIFFY_OFFSET);
	    unless(defined(&USEC_PER_SEC)) {
		eval 'sub USEC_PER_SEC () {(1000000);}' unless defined(&USEC_PER_SEC);
	    }
	    unless(defined(&NSEC_PER_SEC)) {
		eval 'sub NSEC_PER_SEC () {(1000000000);}' unless defined(&NSEC_PER_SEC);
	    }
	    unless(defined(&NSEC_PER_USEC)) {
		eval 'sub NSEC_PER_USEC () {(1000);}' unless defined(&NSEC_PER_USEC);
	    }
	    eval 'sub SEC_JIFFIE_SC () {(31-  &SHIFT_HZ);}' unless defined(&SEC_JIFFIE_SC);
	    if(!(((((defined(&NSEC_PER_SEC) ? &NSEC_PER_SEC : 0) << 2) / (defined(&TICK_NSEC) ? &TICK_NSEC : 0)) << ((defined(&SEC_JIFFIE_SC) ? &SEC_JIFFIE_SC : 0) - 2)) & 0x80000000)) {
		undef(&SEC_JIFFIE_SC) if defined(&SEC_JIFFIE_SC);
		eval 'sub SEC_JIFFIE_SC () {(32-  &SHIFT_HZ);}' unless defined(&SEC_JIFFIE_SC);
	    }
	    eval 'sub NSEC_JIFFIE_SC () {( &SEC_JIFFIE_SC + 29);}' unless defined(&NSEC_JIFFIE_SC);
	    eval 'sub USEC_JIFFIE_SC () {( &SEC_JIFFIE_SC + 19);}' unless defined(&USEC_JIFFIE_SC);
	    eval 'sub SEC_CONVERSION () {(((( &NSEC_PER_SEC <<  &SEC_JIFFIE_SC)) /  &TICK_NSEC));}' unless defined(&SEC_CONVERSION);
	    eval 'sub NSEC_CONVERSION () {((((1<<  &NSEC_JIFFIE_SC)) /  &TICK_NSEC));}' unless defined(&NSEC_CONVERSION);
	    eval 'sub USEC_CONVERSION () {(((( &NSEC_PER_USEC <<  &USEC_JIFFIE_SC)) /  &TICK_NSEC));}' unless defined(&USEC_CONVERSION);
	    eval 'sub USEC_ROUND () {((1<<  &USEC_JIFFIE_SC) - 1);}' unless defined(&USEC_ROUND);
	    if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) < 64) {
		eval 'sub MAX_SEC_IN_JIFFIES () {(( &MAX_JIFFY_OFFSET *  &TICK_NSEC) /  &NSEC_PER_SEC);}' unless defined(&MAX_SEC_IN_JIFFIES);
	    } else {
		eval 'sub MAX_SEC_IN_JIFFIES () {( &SH_DIV(( &MAX_JIFFY_OFFSET >>  &SEC_JIFFIE_SC) *  &TICK_NSEC,  &NSEC_PER_SEC, 1) - 1);}' unless defined(&MAX_SEC_IN_JIFFIES);
	    }
	    eval 'sub CURRENT_TIME () {( &current_kernel_time());}' unless defined(&CURRENT_TIME);
	}
	eval 'sub NFDBITS () { &__NFDBITS;}' unless defined(&NFDBITS);
	if(defined(&__KERNEL__)) {
	}
	eval 'sub FD_SETSIZE () { &__FD_SETSIZE;}' unless defined(&FD_SETSIZE);
	eval 'sub FD_SET {
	    local($fd,$fdsetp) = @_;
    	    eval q( &__FD_SET($fd,$fdsetp));
	}' unless defined(&FD_SET);
	eval 'sub FD_CLR {
	    local($fd,$fdsetp) = @_;
    	    eval q( &__FD_CLR($fd,$fdsetp));
	}' unless defined(&FD_CLR);
	eval 'sub FD_ISSET {
	    local($fd,$fdsetp) = @_;
    	    eval q( &__FD_ISSET($fd,$fdsetp));
	}' unless defined(&FD_ISSET);
	eval 'sub FD_ZERO {
	    local($fdsetp) = @_;
    	    eval q( &__FD_ZERO($fdsetp));
	}' unless defined(&FD_ZERO);
	eval 'sub ITIMER_REAL () {0;}' unless defined(&ITIMER_REAL);
	eval 'sub ITIMER_VIRTUAL () {1;}' unless defined(&ITIMER_VIRTUAL);
	eval 'sub ITIMER_PROF () {2;}' unless defined(&ITIMER_PROF);
	eval 'sub CLOCK_REALTIME () {0;}' unless defined(&CLOCK_REALTIME);
	eval 'sub CLOCK_MONOTONIC () {1;}' unless defined(&CLOCK_MONOTONIC);
	eval 'sub CLOCK_PROCESS_CPUTIME_ID () {2;}' unless defined(&CLOCK_PROCESS_CPUTIME_ID);
	eval 'sub CLOCK_THREAD_CPUTIME_ID () {3;}' unless defined(&CLOCK_THREAD_CPUTIME_ID);
	eval 'sub CLOCK_REALTIME_HR () {4;}' unless defined(&CLOCK_REALTIME_HR);
	eval 'sub CLOCK_MONOTONIC_HR () {5;}' unless defined(&CLOCK_MONOTONIC_HR);
	eval 'sub MAX_CLOCKS () {6;}' unless defined(&MAX_CLOCKS);
	eval 'sub CLOCKS_MASK () {( &CLOCK_REALTIME |  &CLOCK_MONOTONIC |  &CLOCK_REALTIME_HR |  &CLOCK_MONOTONIC_HR);}' unless defined(&CLOCKS_MASK);
	eval 'sub CLOCKS_MONO () {( &CLOCK_MONOTONIC &  &CLOCK_MONOTONIC_HR);}' unless defined(&CLOCKS_MONO);
	eval 'sub TIMER_ABSTIME () {0x1;}' unless defined(&TIMER_ABSTIME);
    }
}
1;
