require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_MMZONE_H)) {
    eval 'sub _LINUX_MMZONE_H () {1;}' unless defined(&_LINUX_MMZONE_H);
    if(defined(&__KERNEL__)) {
	unless(defined(&__ASSEMBLY__)) {
	    require 'linux/config.ph';
	    require 'linux/spinlock.ph';
	    require 'linux/list.ph';
	    require 'linux/wait.ph';
	    require 'linux/cache.ph';
	    require 'linux/threads.ph';
	    require 'linux/numa.ph';
	    require 'asm/atomic.ph';
	    unless(defined(&CONFIG_FORCE_MAX_ZONEORDER)) {
		eval 'sub MAX_ORDER () {11;}' unless defined(&MAX_ORDER);
	    } else {
		eval 'sub MAX_ORDER () { &CONFIG_FORCE_MAX_ZONEORDER;}' unless defined(&MAX_ORDER);
	    }
	    if(defined( &CONFIG_SMP)) {
		eval 'sub ZONE_PADDING {
		    local($name) = @_;
    		    eval q(1;);
		}' unless defined(&ZONE_PADDING);
	    } else {
		eval 'sub ZONE_PADDING {
		    local($name) = @_;
    		    eval q();
		}' unless defined(&ZONE_PADDING);
	    }
	    eval 'sub ZONE_DMA () {0;}' unless defined(&ZONE_DMA);
	    eval 'sub ZONE_NORMAL () {1;}' unless defined(&ZONE_NORMAL);
	    eval 'sub ZONE_HIGHMEM () {2;}' unless defined(&ZONE_HIGHMEM);
	    eval 'sub MAX_NR_ZONES () {3;}' unless defined(&MAX_NR_ZONES);
	    eval 'sub GFP_ZONEMASK () {0x3;}' unless defined(&GFP_ZONEMASK);
	    eval 'sub node_present_pages {
	        local($nid) = @_;
    		eval q(( &NODE_DATA($nid)-> &node_present_pages));
	    }' unless defined(&node_present_pages);
	    eval 'sub node_spanned_pages {
	        local($nid) = @_;
    		eval q(( &NODE_DATA($nid)-> &node_spanned_pages));
	    }' unless defined(&node_spanned_pages);
	    eval 'sub for_each_pgdat {
	        local($pgdat) = @_;
    		eval q( &for ($pgdat =  &pgdat_list; $pgdat; $pgdat =  ($pgdat->{pgdat_next})));
	    }' unless defined(&for_each_pgdat);
	    eval 'sub for_each_zone {
	        local($zone) = @_;
    		eval q( &for ($zone =  ($pgdat_list->{node_zones}); $zone; $zone =  &next_zone($zone)));
	    }' unless defined(&for_each_zone);
	    if(defined(&CONFIG_NUMA)) {
		eval 'sub MAX_NR_MEMBLKS () { &BITS_PER_LONG;}' unless defined(&MAX_NR_MEMBLKS);
	    } else {
		eval 'sub MAX_NR_MEMBLKS () {1;}' unless defined(&MAX_NR_MEMBLKS);
	    }
	    require 'linux/topology.ph';
	    eval 'sub numa_node_id () {
	        eval q(( &cpu_to_node( &smp_processor_id())));
	    }' unless defined(&numa_node_id);
	    unless(defined(&CONFIG_DISCONTIGMEM)) {
		eval 'sub NODE_DATA {
		    local($nid) = @_;
    		    eval q(( &contig_page_data));
		}' unless defined(&NODE_DATA);
		eval 'sub NODE_MEM_MAP {
		    local($nid) = @_;
    		    eval q( &mem_map);
		}' unless defined(&NODE_MEM_MAP);
		eval 'sub MAX_NODES_SHIFT () {0;}' unless defined(&MAX_NODES_SHIFT);
	    } else {
		require 'asm/mmzone.ph';
		if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 32) {
		    eval 'sub MAX_NODES_SHIFT () {6;}' unless defined(&MAX_NODES_SHIFT);
		}
 elsif((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 64) {
		    eval 'sub MAX_NODES_SHIFT () {10;}' unless defined(&MAX_NODES_SHIFT);
		}
	    }
	    if((defined(&NODES_SHIFT) ? &NODES_SHIFT : 0) > (defined(&MAX_NODES_SHIFT) ? &MAX_NODES_SHIFT : 0)) {
		die("NODES_SHIFT\ \>\ MAX_NODES_SHIFT");
	    }
	    if(defined( &CONFIG_DISCONTIGMEM) || defined( &CONFIG_NUMA)) {
		eval 'sub node_online {
		    local($node) = @_;
    		    eval q( &test_bit($node,  &node_online_map));
		}' unless defined(&node_online);
		eval 'sub node_set_online {
		    local($node) = @_;
    		    eval q( &set_bit($node,  &node_online_map));
		}' unless defined(&node_set_online);
		eval 'sub node_set_offline {
		    local($node) = @_;
    		    eval q( &clear_bit($node,  &node_online_map));
		}' unless defined(&node_set_offline);
		eval 'sub memblk_online {
		    local($memblk) = @_;
    		    eval q( &test_bit($memblk,  &memblk_online_map));
		}' unless defined(&memblk_online);
		eval 'sub memblk_set_online {
		    local($memblk) = @_;
    		    eval q( &set_bit($memblk,  &memblk_online_map));
		}' unless defined(&memblk_set_online);
		eval 'sub memblk_set_offline {
		    local($memblk) = @_;
    		    eval q( &clear_bit($memblk,  &memblk_online_map));
		}' unless defined(&memblk_set_offline);
	    } else {
		eval 'sub node_online {
		    local($node) = @_;
    		    eval q(({  &BUG_ON(($node) != 0);  &test_bit($node,  &node_online_map); }));
		}' unless defined(&node_online);
		eval 'sub node_set_online {
		    local($node) = @_;
    		    eval q(({  &BUG_ON(($node) != 0);  &set_bit($node,  &node_online_map); }));
		}' unless defined(&node_set_online);
		eval 'sub node_set_offline {
		    local($node) = @_;
    		    eval q(({  &BUG_ON(($node) != 0);  &clear_bit($node,  &node_online_map); }));
		}' unless defined(&node_set_offline);
		eval 'sub num_online_nodes () {
		    eval q(1);
		}' unless defined(&num_online_nodes);
		eval 'sub memblk_online {
		    local($memblk) = @_;
    		    eval q(({  &BUG_ON(($memblk) != 0);  &test_bit($memblk,  &memblk_online_map); }));
		}' unless defined(&memblk_online);
		eval 'sub memblk_set_online {
		    local($memblk) = @_;
    		    eval q(({  &BUG_ON(($memblk) != 0);  &set_bit($memblk,  &memblk_online_map); }));
		}' unless defined(&memblk_set_online);
		eval 'sub memblk_set_offline {
		    local($memblk) = @_;
    		    eval q(({  &BUG_ON(($memblk) != 0);  &clear_bit($memblk,  &memblk_online_map); }));
		}' unless defined(&memblk_set_offline);
		eval 'sub num_online_memblks () {
		    eval q(1);
		}' unless defined(&num_online_memblks);
	    }
	}
    }
}
1;
