require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_BITOPS_H)) {
    eval 'sub __ASM_ARM_BITOPS_H () {1;}' unless defined(&__ASM_ARM_BITOPS_H);
    if(defined(&__KERNEL__)) {
	require 'linux/compiler.ph';
	require 'asm/system.ph';
	eval 'sub smp_mb__before_clear_bit () {
	    eval q( &mb());
	}' unless defined(&smp_mb__before_clear_bit);
	eval 'sub smp_mb__after_clear_bit () {
	    eval q( &mb());
	}' unless defined(&smp_mb__after_clear_bit);
	unless(defined(&CONFIG_SMP)) {
	    eval 'sub ATOMIC_BITOP_LE {
	        local($name,$nr,$p) = @_;
    		eval q(( &__builtin_constant_p($nr) ?  &____atomic_$name($nr, $p) :  &_$name &_le($nr,$p)));
	    }' unless defined(&ATOMIC_BITOP_LE);
	    eval 'sub ATOMIC_BITOP_BE {
	        local($name,$nr,$p) = @_;
    		eval q(( &__builtin_constant_p($nr) ?  &____atomic_$name($nr, $p) :  &_$name &_be($nr,$p)));
	    }' unless defined(&ATOMIC_BITOP_BE);
	} else {
	    eval 'sub ATOMIC_BITOP_LE {
	        local($name,$nr,$p) = @_;
    		eval q( &_$name &_le($nr,$p));
	    }' unless defined(&ATOMIC_BITOP_LE);
	    eval 'sub ATOMIC_BITOP_BE {
	        local($name,$nr,$p) = @_;
    		eval q( &_$name &_be($nr,$p));
	    }' unless defined(&ATOMIC_BITOP_BE);
	}
	eval 'sub NONATOMIC_BITOP {
	    local($name,$nr,$p) = @_;
    	    eval q(( &____nonatomic_$name($nr, $p)));
	}' unless defined(&NONATOMIC_BITOP);
	unless(defined(&__ARMEB__)) {
	    eval 'sub set_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_LE( &set_bit,$nr,$p));
	    }' unless defined(&set_bit);
	    eval 'sub clear_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_LE( &clear_bit,$nr,$p));
	    }' unless defined(&clear_bit);
	    eval 'sub change_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_LE( &change_bit,$nr,$p));
	    }' unless defined(&change_bit);
	    eval 'sub test_and_set_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_LE( &test_and_set_bit,$nr,$p));
	    }' unless defined(&test_and_set_bit);
	    eval 'sub test_and_clear_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_LE( &test_and_clear_bit,$nr,$p));
	    }' unless defined(&test_and_clear_bit);
	    eval 'sub test_and_change_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_LE( &test_and_change_bit,$nr,$p));
	    }' unless defined(&test_and_change_bit);
	    eval 'sub test_bit {
	        local($nr,$p) = @_;
    		eval q( &__test_bit($nr,$p));
	    }' unless defined(&test_bit);
	    eval 'sub find_first_zero_bit {
	        local($p,$sz) = @_;
    		eval q( &_find_first_zero_bit_le($p,$sz));
	    }' unless defined(&find_first_zero_bit);
	    eval 'sub find_next_zero_bit {
	        local($p,$sz,$off) = @_;
    		eval q( &_find_next_zero_bit_le($p,$sz,$off));
	    }' unless defined(&find_next_zero_bit);
	    eval 'sub find_first_bit {
	        local($p,$sz) = @_;
    		eval q( &_find_first_bit_le($p,$sz));
	    }' unless defined(&find_first_bit);
	    eval 'sub find_next_bit {
	        local($p,$sz,$off) = @_;
    		eval q( &_find_next_bit_le($p,$sz,$off));
	    }' unless defined(&find_next_bit);
	    eval 'sub WORD_BITOFF_TO_LE {
	        local($x) = @_;
    		eval q((($x)));
	    }' unless defined(&WORD_BITOFF_TO_LE);
	} else {
	    eval 'sub set_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_BE( &set_bit,$nr,$p));
	    }' unless defined(&set_bit);
	    eval 'sub clear_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_BE( &clear_bit,$nr,$p));
	    }' unless defined(&clear_bit);
	    eval 'sub change_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_BE( &change_bit,$nr,$p));
	    }' unless defined(&change_bit);
	    eval 'sub test_and_set_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_BE( &test_and_set_bit,$nr,$p));
	    }' unless defined(&test_and_set_bit);
	    eval 'sub test_and_clear_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_BE( &test_and_clear_bit,$nr,$p));
	    }' unless defined(&test_and_clear_bit);
	    eval 'sub test_and_change_bit {
	        local($nr,$p) = @_;
    		eval q( &ATOMIC_BITOP_BE( &test_and_change_bit,$nr,$p));
	    }' unless defined(&test_and_change_bit);
	    eval 'sub test_bit {
	        local($nr,$p) = @_;
    		eval q( &__test_bit($nr,$p));
	    }' unless defined(&test_bit);
	    eval 'sub find_first_zero_bit {
	        local($p,$sz) = @_;
    		eval q( &_find_first_zero_bit_be($p,$sz));
	    }' unless defined(&find_first_zero_bit);
	    eval 'sub find_next_zero_bit {
	        local($p,$sz,$off) = @_;
    		eval q( &_find_next_zero_bit_be($p,$sz,$off));
	    }' unless defined(&find_next_zero_bit);
	    eval 'sub find_first_bit {
	        local($p,$sz) = @_;
    		eval q( &_find_first_bit_be($p,$sz));
	    }' unless defined(&find_first_bit);
	    eval 'sub find_next_bit {
	        local($p,$sz,$off) = @_;
    		eval q( &_find_next_bit_be($p,$sz,$off));
	    }' unless defined(&find_next_bit);
	    eval 'sub WORD_BITOFF_TO_LE {
	        local($x) = @_;
    		eval q((($x) ^ 0x18));
	    }' unless defined(&WORD_BITOFF_TO_LE);
	}
	if((defined(&__LINUX_ARM_ARCH__) ? &__LINUX_ARM_ARCH__ : 0) < 5) {
	    eval 'sub fls {
	        local($x) = @_;
    		eval q( &generic_fls($x));
	    }' unless defined(&fls);
	    eval 'sub fls64 {
	        local($x) = @_;
    		eval q( &generic_fls64($x));
	    }' unless defined(&fls64);
	    eval 'sub ffs {
	        local($x) = @_;
    		eval q( &generic_ffs($x));
	    }' unless defined(&ffs);
	} else {
	    eval 'sub fls {
	        local($x) = @_;
    		eval q((  &__builtin_constant_p($x) ?  &generic_fls($x) : ({ \'int\'  &__r;  &asm(\\"clz\\\\t%0, %1\\" : \\"=r\\"( &__r) : \\"r\\"($x) : \\"cc\\"); 32- &__r; }) ));
	    }' unless defined(&fls);
	    eval 'sub fls64 {
	        local($x) = @_;
    		eval q( &generic_fls64($x));
	    }' unless defined(&fls64);
	    eval 'sub ffs {
	        local($x) = @_;
    		eval q(({ \'unsigned long __t\' = ($x);  &fls( &__t & - &__t); }));
	    }' unless defined(&ffs);
	    eval 'sub __ffs {
	        local($x) = @_;
    		eval q(( &ffs($x) - 1));
	    }' unless defined(&__ffs);
	    eval 'sub ffz {
	        local($x) = @_;
    		eval q( &__ffs( ~($x) ));
	    }' unless defined(&ffz);
	}
	eval 'sub hweight32 {
	    local($x) = @_;
    	    eval q( &generic_hweight32($x));
	}' unless defined(&hweight32);
	eval 'sub hweight16 {
	    local($x) = @_;
    	    eval q( &generic_hweight16($x));
	}' unless defined(&hweight16);
	eval 'sub hweight8 {
	    local($x) = @_;
    	    eval q( &generic_hweight8($x));
	}' unless defined(&hweight8);
	eval 'sub ext2_set_bit {
	    local($nr,$p) = @_;
    	    eval q( &__test_and_set_bit( &WORD_BITOFF_TO_LE, ($p)));
	}' unless defined(&ext2_set_bit);
	eval 'sub ext2_set_bit_atomic {
	    local($lock,$nr,$p) = @_;
    	    eval q( &test_and_set_bit( &WORD_BITOFF_TO_LE, ($p)));
	}' unless defined(&ext2_set_bit_atomic);
	eval 'sub ext2_clear_bit {
	    local($nr,$p) = @_;
    	    eval q( &__test_and_clear_bit( &WORD_BITOFF_TO_LE, ($p)));
	}' unless defined(&ext2_clear_bit);
	eval 'sub ext2_clear_bit_atomic {
	    local($lock,$nr,$p) = @_;
    	    eval q( &test_and_clear_bit( &WORD_BITOFF_TO_LE, ($p)));
	}' unless defined(&ext2_clear_bit_atomic);
	eval 'sub ext2_test_bit {
	    local($nr,$p) = @_;
    	    eval q( &__test_bit( &WORD_BITOFF_TO_LE, ($p)));
	}' unless defined(&ext2_test_bit);
	eval 'sub ext2_find_first_zero_bit {
	    local($p,$sz) = @_;
    	    eval q( &_find_first_zero_bit_le($p,$sz));
	}' unless defined(&ext2_find_first_zero_bit);
	eval 'sub ext2_find_next_zero_bit {
	    local($p,$sz,$off) = @_;
    	    eval q( &_find_next_zero_bit_le($p,$sz,$off));
	}' unless defined(&ext2_find_next_zero_bit);
	eval 'sub minix_set_bit {
	    local($nr,$p) = @_;
    	    eval q( &__set_bit( &WORD_BITOFF_TO_LE, ($p)));
	}' unless defined(&minix_set_bit);
	eval 'sub minix_test_bit {
	    local($nr,$p) = @_;
    	    eval q( &__test_bit( &WORD_BITOFF_TO_LE, ($p)));
	}' unless defined(&minix_test_bit);
	eval 'sub minix_test_and_set_bit {
	    local($nr,$p) = @_;
    	    eval q( &__test_and_set_bit( &WORD_BITOFF_TO_LE, ($p)));
	}' unless defined(&minix_test_and_set_bit);
	eval 'sub minix_test_and_clear_bit {
	    local($nr,$p) = @_;
    	    eval q( &__test_and_clear_bit( &WORD_BITOFF_TO_LE, ($p)));
	}' unless defined(&minix_test_and_clear_bit);
	eval 'sub minix_find_first_zero_bit {
	    local($p,$sz) = @_;
    	    eval q( &_find_first_zero_bit_le($p,$sz));
	}' unless defined(&minix_find_first_zero_bit);
    }
}
1;
