/*
 * tp-constants.h - constants used in telepathy 
 * Copyright (C) 2005 Collabora Ltd.
 * Copyright (C) 2005 Nokia Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TELEPATHY_CONSTANTS_H__
#define __TELEPATHY_CONSTANTS_H__ 

#include <glib.h>
G_BEGIN_DECLS

typedef enum {
TP_CONN_ALIAS_FLAG_USER_SET = 1,
LAST_TP_CONN_ALIAS_FLAG
} ConnectionAliasFlags;

typedef enum {
TP_CONN_CAPABILITY_TYPE_CREATE = 0,
TP_CONN_CAPABILITY_TYPE_INVITE = 1,
LAST_TP_CONN_CAPABILITY_TYPE
} TelepathyConnectionCapabilityType;

typedef enum {
TP_CONN_HANDLE_TYPE_NONE = 0,
TP_CONN_HANDLE_TYPE_CONTACT = 1,
TP_CONN_HANDLE_TYPE_ROOM = 2,
TP_CONN_HANDLE_TYPE_LIST = 3,
LAST_TP_CONN_HANDLE_TYPE
} TelepathyConnectionHandleType;

typedef enum {
TP_CONN_PRESENCE_TYPE_UNSET = 0,
TP_CONN_PRESENCE_TYPE_OFFLINE = 1,
TP_CONN_PRESENCE_TYPE_AVAILABLE = 2,
TP_CONN_PRESENCE_TYPE_AWAY = 3,
TP_CONN_PRESENCE_TYPE_EXTENDED_AWAY = 4,
TP_CONN_PRESENCE_TYPE_HIDDEN = 5,
LAST_TP_CONN_PRESENCE_TYPE
} TelepathyConnectionPresenceType;

typedef enum {
TP_CONN_STATUS_CONNECTED = 0,
TP_CONN_STATUS_CONNECTING = 1,
TP_CONN_STATUS_DISCONNECTED = 2,
LAST_TP_CONN_STATUS
} TelepathyConnectionStatus;

typedef enum {
TP_CONN_STATUS_REASON_NONE_SPECIFIED = 0,
TP_CONN_STATUS_REASON_REQUESTED = 1,
TP_CONN_STATUS_REASON_NETWORK_ERROR = 2,
TP_CONN_STATUS_REASON_AUTHENTICATION_FAILED = 3,
TP_CONN_STATUS_REASON_ENCRYPTION_ERROR = 4,
TP_CONN_STATUS_REASON_NAME_IN_USE = 5,
TP_CONN_STATUS_REASON_CERT_NOT_PROVIDED = 6,
TP_CONN_STATUS_REASON_CERT_UNTRUSTED = 7,
TP_CONN_STATUS_REASON_CERT_EXPIRED = 8,
TP_CONN_STATUS_REASON_CERT_NOT_ACTIVATED = 9,
TP_CONN_STATUS_REASON_CERT_HOSTNAME_MISMATCH = 10,
TP_CONN_STATUS_REASON_CERT_FINGERPRINT_MISMATCH = 11,
TP_CONN_STATUS_REASON_CERT_SELF_SIGNED = 12,
TP_CONN_STATUS_REASON_CERT_OTHER_ERROR = 13,
LAST_TP_CONN_STATUS_REASON
} TelepathyConnectionStatusReason;

typedef enum {
TP_CHANNEL_CONTACT_SEARCH_STATE_BEFORE = 0,
TP_CHANNEL_CONTACT_SEARCH_STATE_DURING = 1,
TP_CHANNEL_CONTACT_SEARCH_STATE_AFTER = 2,
LAST_TP_CHANNEL_CONTACT_SEARCH_STATE
} TelepathyChannelContactSearchState;

typedef enum {
TP_CHANNEL_TEXT_MESSAGE_TYPE_NORMAL = 0,
TP_CHANNEL_TEXT_MESSAGE_TYPE_ACTION = 1,
TP_CHANNEL_TEXT_MESSAGE_TYPE_NOTICE = 2,
TP_CHANNEL_TEXT_MESSAGE_TYPE_AUTO_REPLY = 3,
LAST_TP_CHANNEL_TEXT_MESSAGE_TYPE
} TelepathyChannelTextMessageType;

typedef enum {
TP_CHANNEL_TEXT_SEND_ERROR_UNKNOWN = 0,
TP_CHANNEL_TEXT_SEND_ERROR_OFFLINE = 1,
TP_CHANNEL_TEXT_SEND_ERROR_INVALID_CONTACT = 2,
TP_CHANNEL_TEXT_SEND_ERROR_PERMISSION_DENIED = 3,
TP_CHANNEL_TEXT_SEND_ERROR_TOO_LONG = 4,
LAST_TP_CHANNEL_TEXT_SEND_ERROR
} TelepathyChannelTextSendError;

typedef enum {
TP_CHANNEL_GROUP_FLAG_CAN_ADD = 1,
TP_CHANNEL_GROUP_FLAG_CAN_REMOVE = 2,
TP_CHANNEL_GROUP_FLAG_CAN_RESCIND = 4,
TP_CHANNEL_GROUP_FLAG_MESSAGE_ADD = 8,
TP_CHANNEL_GROUP_FLAG_MESSAGE_REMOVE = 16,
TP_CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT = 32,
TP_CHANNEL_GROUP_FLAG_MESSAGE_REJECT = 64,
TP_CHANNEL_GROUP_FLAG_MESSAGE_RESCIND = 128,
TP_CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES = 256,
LAST_TP_CHANNEL_GROUP_FLAG
} TelepathyChannelGroupFlags;

typedef enum {
TP_CHANNEL_HOLD_STATE_NONE = 0,
TP_CHANNEL_HOLD_STATE_SEND_ONLY = 1,
TP_CHANNEL_HOLD_STATE_RECV_ONLY = 2,
TP_CHANNEL_HOLD_STATE_BOTH = 3,
LAST_TP_CHANNEL_HOLD_STATE
} TelepathyChannelHoldState;

typedef enum {
TP_CHANNEL_PASSWORD_FLAG_REQUIRED = 1,
TP_CHANNEL_PASSWORD_FLAG_VISIBLE = 2,
TP_CHANNEL_PASSWORD_FLAG_MODIFIABLE = 4,
TP_CHANNEL_PASSWORD_FLAG_PROVIDE = 8,
LAST_TP_CHANNEL_PASSWORD_FLAG
} TelepathyChannelPasswordFlags;

typedef enum {
TP_CHANNEL_SUBJECT_FLAG_PRESENT = 1,
TP_CHANNEL_SUBJECT_FLAG_MODIFIABLE = 2,
LAST_TP_CHANNEL_SUBJECT_FLAG
} TelepathyChannelSubjectFlags;

typedef enum {
TP_MEDIA_STREAM_TYPE_AUDIO = 0,
TP_MEDIA_STREAM_TYPE_VIDEO = 1,
LAST_TP_MEDIA_STREAM_TYPE
} TelepathyMediaStreamType;

typedef enum {
TP_MEDIA_STREAM_DIRECTION_NONE = 0,
TP_MEDIA_STREAM_DIRECTION_SEND = 1,
TP_MEDIA_STREAM_DIRECTION_RECIEVE = 2,
TP_MEDIA_STREAM_DIRECTION_BIDIRECTIONAL = 3,
LAST_TP_MEDIA_STREAM_DIRECTION
} TelepathyMediaStreamDirection;

typedef enum {
TP_MEDIA_STREAM_ERROR_UNKNOWN = 0,
TP_MEDIA_STREAM_ERROR_EOS = 1,
LAST_TP_MEDIA_STREAM_ERROR
} TelepathyMediaStreamError;

typedef enum {
TP_MEDIA_STREAM_PROTO_UDP = 0,
TP_MEDIA_STREAM_PROTO_TCP = 1,
LAST_TP_MEDIA_STREAM_PROTO
} TelepathyMediaStreamProto;

typedef enum {
TP_MEDIA_STREAM_TRANSPORT_TYPE_LOCAL = 0,
TP_MEDIA_STREAM_TRANSPORT_TYPE_DERIVED = 1,
TP_MEDIA_STREAM_TRANSPORT_TYPE_RELAY = 2,
LAST_TP_MEDIA_STREAM_TRANSPORT_TYPE
} TelepathyMediaStreamTransportType;

typedef enum {
TP_CODEC_MEDIA_TYPE_AUDIO = 0,
TP_CODEC_MEDIA_TYPE_VIDEO = 1,
} TelepathyCodecMediaType;

typedef enum {
TP_MEDIA_STREAM_STATE_STOPPED = 0,
TP_MEDIA_STREAM_STATE_PLAYING = 1,
TP_MEDIA_STREAM_STATE_CONNECTING = 2,
TP_MEDIA_STREAM_STATE_CONNECTED = 3
} TelepathyMediaStreamState;

typedef enum {
TP_PROPERTY_FLAG_READ = 1,
TP_PROPERTY_FLAG_WRITE = 2
} TelepathyPropertyFlags;

G_END_DECLS


#endif
