require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_PM_H)) {
    eval 'sub _LINUX_PM_H () {1;}' unless defined(&_LINUX_PM_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/list.ph';
	require 'asm/atomic.ph';
	eval 'sub PM_SUSPEND () {( 1);}' unless defined(&PM_SUSPEND);
	eval 'sub PM_RESUME () {( 2);}' unless defined(&PM_RESUME);
	eval 'sub PM_UNKNOWN_DEV () {( 0);}' unless defined(&PM_UNKNOWN_DEV);
	eval 'sub PM_SYS_DEV () {( 1);}' unless defined(&PM_SYS_DEV);
	eval 'sub PM_PCI_DEV () {( 2);}' unless defined(&PM_PCI_DEV);
	eval 'sub PM_USB_DEV () {( 3);}' unless defined(&PM_USB_DEV);
	eval 'sub PM_SCSI_DEV () {( 4);}' unless defined(&PM_SCSI_DEV);
	eval 'sub PM_ISA_DEV () {( 5);}' unless defined(&PM_ISA_DEV);
	eval 'sub PM_MTD_DEV () {( 6);}' unless defined(&PM_MTD_DEV);
	eval("sub PM_SYS_UNKNOWN () { 0x00000000; }") unless defined(&PM_SYS_UNKNOWN);
	eval("sub PM_SYS_KBC () { 0x41d00303; }") unless defined(&PM_SYS_KBC);
	eval("sub PM_SYS_COM () { 0x41d00500; }") unless defined(&PM_SYS_COM);
	eval("sub PM_SYS_IRDA () { 0x41d00510; }") unless defined(&PM_SYS_IRDA);
	eval("sub PM_SYS_FDC () { 0x41d00700; }") unless defined(&PM_SYS_FDC);
	eval("sub PM_SYS_VGA () { 0x41d00900; }") unless defined(&PM_SYS_VGA);
	eval("sub PM_SYS_PCMCIA () { 0x41d00e00; }") unless defined(&PM_SYS_PCMCIA);
	eval 'sub PM_PCI_ID {
	    local($dev) = @_;
    	    eval q((($dev)-> ($bus->{number}) << 16| ($dev)-> &devfn));
	}' unless defined(&PM_PCI_ID);
	eval 'sub PM_SUSPEND_ON () {( 0);}' unless defined(&PM_SUSPEND_ON);
	eval 'sub PM_SUSPEND_STANDBY () {( 1);}' unless defined(&PM_SUSPEND_STANDBY);
	eval 'sub PM_SUSPEND_MEM () {( 3);}' unless defined(&PM_SUSPEND_MEM);
	eval 'sub PM_SUSPEND_DISK () {( 4);}' unless defined(&PM_SUSPEND_DISK);
	eval 'sub PM_SUSPEND_MAX () {( 5);}' unless defined(&PM_SUSPEND_MAX);
	eval 'sub PM_DISK_FIRMWARE () {( 1);}' unless defined(&PM_DISK_FIRMWARE);
	eval 'sub PM_DISK_PLATFORM () {( 2);}' unless defined(&PM_DISK_PLATFORM);
	eval 'sub PM_DISK_SHUTDOWN () {( 3);}' unless defined(&PM_DISK_SHUTDOWN);
	eval 'sub PM_DISK_REBOOT () {( 4);}' unless defined(&PM_DISK_REBOOT);
	eval 'sub PM_DISK_MAX () {( 5);}' unless defined(&PM_DISK_MAX);
	eval 'sub PM_EVENT_ON () {0;}' unless defined(&PM_EVENT_ON);
	eval 'sub PM_EVENT_FREEZE () {1;}' unless defined(&PM_EVENT_FREEZE);
	eval 'sub PM_EVENT_SUSPEND () {2;}' unless defined(&PM_EVENT_SUSPEND);
	eval 'sub PMSG_FREEZE () {({ . &event =  &PM_EVENT_FREEZE, });}' unless defined(&PMSG_FREEZE);
	eval 'sub PMSG_SUSPEND () {({ . &event =  &PM_EVENT_SUSPEND, });}' unless defined(&PMSG_SUSPEND);
	eval 'sub PMSG_ON () {({ . &event =  &PM_EVENT_ON, });}' unless defined(&PMSG_ON);
	if(defined(&CONFIG_PM)) {
	}
	if(defined(&CONFIG_PM)) {
	    eval 'sub device_set_wakeup_enable {
	        local($dev,$val) = @_;
    		eval q((($dev)-> ($power->{should_wakeup}) = !!($val)));
	    }' unless defined(&device_set_wakeup_enable);
	    eval 'sub device_may_wakeup {
	        local($dev) = @_;
    		eval q(( &device_can_wakeup($dev)  && ($dev)-> ($power->{should_wakeup})));
	    }' unless defined(&device_may_wakeup);
	} else {
	    eval 'sub device_set_wakeup_enable {
	        local($dev,$val) = @_;
    		eval q( &do{} &while(0));
	    }' unless defined(&device_set_wakeup_enable);
	    eval 'sub device_may_wakeup {
	        local($dev) = @_;
    		eval q((0));
	    }' unless defined(&device_may_wakeup);
	}
	eval 'sub device_can_wakeup {
	    local($dev) = @_;
    	    eval q((($dev)-> ($power->{can_wakeup})));
	}' unless defined(&device_can_wakeup);
	eval 'sub device_init_wakeup {
	    local($dev,$val) = @_;
    	    eval q( &do {  &device_can_wakeup($dev) = !!($val);  &device_set_wakeup_enable($dev,$val); }  &while(0));
	}' unless defined(&device_init_wakeup);
    }
}
1;
