require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_MEMORY_H)) {
    eval 'sub __ASM_ARM_MEMORY_H () {1;}' unless defined(&__ASM_ARM_MEMORY_H);
    unless(defined(&__ASSEMBLY__)) {
	eval 'sub UL {
	    local($x) = @_;
    	    eval q(($x &UL));
	}' unless defined(&UL);
    } else {
	eval 'sub UL {
	    local($x) = @_;
    	    eval q(($x));
	}' unless defined(&UL);
    }
    require 'linux/config.ph';
    require 'linux/compiler.ph';
    require 'asm/arch/memory.ph';
    require 'asm/sizes.ph';
    unless(defined(&TASK_SIZE)) {
	eval 'sub TASK_SIZE () { &UL(0xbf000000);}' unless defined(&TASK_SIZE);
	eval 'sub TASK_UNMAPPED_BASE () { &UL(0x40000000);}' unless defined(&TASK_UNMAPPED_BASE);
    }
    eval 'sub TASK_SIZE_26 () { &UL(0x4000000);}' unless defined(&TASK_SIZE_26);
    unless(defined(&PAGE_OFFSET)) {
	eval 'sub PAGE_OFFSET () { &UL(0xc0000000);}' unless defined(&PAGE_OFFSET);
    }
    unless(defined(&CONSISTENT_DMA_SIZE)) {
	eval 'sub CONSISTENT_DMA_SIZE () { &SZ_2M;}' unless defined(&CONSISTENT_DMA_SIZE);
    }
    unless(defined(&__virt_to_phys)) {
	eval 'sub __virt_to_phys {
	    local($x) = @_;
    	    eval q((($x) -  &PAGE_OFFSET +  &PHYS_OFFSET));
	}' unless defined(&__virt_to_phys);
	eval 'sub __phys_to_virt {
	    local($x) = @_;
    	    eval q((($x) -  &PHYS_OFFSET +  &PAGE_OFFSET));
	}' unless defined(&__phys_to_virt);
    }
    eval 'sub __phys_to_pfn {
        local($paddr) = @_;
	    eval q((($paddr) >>  &PAGE_SHIFT));
    }' unless defined(&__phys_to_pfn);
    eval 'sub __pfn_to_phys {
        local($pfn) = @_;
	    eval q((($pfn) <<  &PAGE_SHIFT));
    }' unless defined(&__pfn_to_phys);
    eval 'sub MODULE_END () {( &PAGE_OFFSET);}' unless defined(&MODULE_END);
    eval 'sub MODULE_START () {( &MODULE_END - 16*1048576);}' unless defined(&MODULE_START);
    if((defined(&TASK_SIZE) ? &TASK_SIZE : 0) > (defined(&MODULE_START) ? &MODULE_START : 0)) {
	die("Top\ of\ user\ space\ clashes\ with\ start\ of\ module\ space");
    }
    eval 'sub XIP_VIRT_ADDR {
        local($physaddr) = @_;
	    eval q(( &MODULE_START + (($physaddr) & 0xfffff)));
    }' unless defined(&XIP_VIRT_ADDR);
    unless(defined(&__ASSEMBLY__)) {
	unless(defined(&ISA_DMA_THRESHOLD)) {
	    eval 'sub ISA_DMA_THRESHOLD () {(0xffffffff);}' unless defined(&ISA_DMA_THRESHOLD);
	}
	unless(defined(&arch_adjust_zones)) {
	    eval 'sub arch_adjust_zones {
	        local($node,$size,$holes) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&arch_adjust_zones);
	}
	eval 'sub PHYS_PFN_OFFSET () {( &PHYS_OFFSET >>  &PAGE_SHIFT);}' unless defined(&PHYS_PFN_OFFSET);
	eval 'sub __pa {
	    local($x) = @_;
    	    eval q( &__virt_to_phys(($x)));
	}' unless defined(&__pa);
	eval 'sub __va {
	    local($x) = @_;
    	    eval q(( &__phys_to_virt(($x))));
	}' unless defined(&__va);
	eval 'sub pfn_to_kaddr {
	    local($pfn) = @_;
    	    eval q( &__va(($pfn) <<  &PAGE_SHIFT));
	}' unless defined(&pfn_to_kaddr);
	unless(defined(&CONFIG_DISCONTIGMEM)) {
	    eval 'sub page_to_pfn {
	        local($page) = @_;
    		eval q(((($page) -  &mem_map) +  &PHYS_PFN_OFFSET));
	    }' unless defined(&page_to_pfn);
	    eval 'sub pfn_to_page {
	        local($pfn) = @_;
    		eval q((( &mem_map + ($pfn)) -  &PHYS_PFN_OFFSET));
	    }' unless defined(&pfn_to_page);
	    eval 'sub pfn_valid {
	        local($pfn) = @_;
    		eval q((($pfn) >=  &PHYS_PFN_OFFSET  && ($pfn) < ( &PHYS_PFN_OFFSET +  &max_mapnr)));
	    }' unless defined(&pfn_valid);
	    eval 'sub virt_to_page {
	        local($kaddr) = @_;
    		eval q(( &pfn_to_page( &__pa($kaddr) >>  &PAGE_SHIFT)));
	    }' unless defined(&virt_to_page);
	    eval 'sub virt_addr_valid {
	        local($kaddr) = @_;
    		eval q(( >=  &PAGE_OFFSET  && <  &high_memory));
	    }' unless defined(&virt_addr_valid);
	    eval 'sub PHYS_TO_NID {
	        local($addr) = @_;
    		eval q((0));
	    }' unless defined(&PHYS_TO_NID);
	} else {
	    require 'linux/numa.ph';
	    eval 'sub page_to_pfn {
	        local($page) = @_;
    		eval q((( ($page) -  &page_zone($page)-> &zone_mem_map) +  &page_zone($page)-> &zone_start_pfn));
	    }' unless defined(&page_to_pfn);
	    eval 'sub pfn_to_page {
	        local($pfn) = @_;
    		eval q(( &PFN_TO_MAPBASE($pfn) +  &LOCAL_MAP_NR(($pfn) <<  &PAGE_SHIFT)));
	    }' unless defined(&pfn_to_page);
	    eval 'sub pfn_valid {
	        local($pfn) = @_;
    		eval q(({ \'unsigned int nid\' =  &PFN_TO_NID($pfn); \'int\'  &valid =  &nid <  &MAX_NUMNODES;  &if ( &valid) {  &pg_data_t * &node =  &NODE_DATA( &nid);  &valid = ($pfn -  ($node->{node_start_pfn})) <  ($node->{node_spanned_pages}); }  &valid; }));
	    }' unless defined(&pfn_valid);
	    eval 'sub virt_to_page {
	        local($kaddr) = @_;
    		eval q(( &ADDR_TO_MAPBASE($kaddr) +  &LOCAL_MAP_NR($kaddr)));
	    }' unless defined(&virt_to_page);
	    eval 'sub virt_addr_valid {
	        local($kaddr) = @_;
    		eval q(( &KVADDR_TO_NID($kaddr) <  &MAX_NUMNODES));
	    }' unless defined(&virt_addr_valid);
	    eval 'sub PHYS_TO_NID {
	        local($addr) = @_;
    		eval q( &PFN_TO_NID(($addr) >>  &PAGE_SHIFT));
	    }' unless defined(&PHYS_TO_NID);
	}
	eval 'sub page_to_phys {
	    local($page) = @_;
    	    eval q(( &page_to_pfn($page) <<  &PAGE_SHIFT));
	}' unless defined(&page_to_phys);
	unless(defined(&__arch_page_to_dma)) {
	    eval 'sub page_to_dma {
	        local($dev, $page) = @_;
    		eval q(( &__virt_to_bus( &page_address($page))));
	    }' unless defined(&page_to_dma);
	    eval 'sub dma_to_virt {
	        local($dev, $addr) = @_;
    		eval q(( &__bus_to_virt($addr)));
	    }' unless defined(&dma_to_virt);
	    eval 'sub virt_to_dma {
	        local($dev, $addr) = @_;
    		eval q(( &__virt_to_bus(($addr))));
	    }' unless defined(&virt_to_dma);
	} else {
	    eval 'sub page_to_dma {
	        local($dev, $page) = @_;
    		eval q(( &__arch_page_to_dma($dev, $page)));
	    }' unless defined(&page_to_dma);
	    eval 'sub dma_to_virt {
	        local($dev, $addr) = @_;
    		eval q(( &__arch_dma_to_virt($dev, $addr)));
	    }' unless defined(&dma_to_virt);
	    eval 'sub virt_to_dma {
	        local($dev, $addr) = @_;
    		eval q(( &__arch_virt_to_dma($dev, $addr)));
	    }' unless defined(&virt_to_dma);
	}
    }
}
1;
