require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I386_PGTABLE_3LEVEL_H)) {
    eval 'sub _I386_PGTABLE_3LEVEL_H () {1;}' unless defined(&_I386_PGTABLE_3LEVEL_H);
    require 'asm-generic/pgtable-nopud.ph';
    eval 'sub pte_ERROR {
        local($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pte %p(%08lx%08lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e), ($e). &pte_high, ($e). &pte_low));
    }' unless defined(&pte_ERROR);
    eval 'sub pmd_ERROR {
        local($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pmd %p(%016Lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e),  &pmd_val($e)));
    }' unless defined(&pmd_ERROR);
    eval 'sub pgd_ERROR {
        local($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pgd %p(%016Lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e),  &pgd_val($e)));
    }' unless defined(&pgd_ERROR);
    eval 'sub pud_none {
        local($pud) = @_;
	    eval q(0);
    }' unless defined(&pud_none);
    eval 'sub pud_bad {
        local($pud) = @_;
	    eval q(0);
    }' unless defined(&pud_bad);
    eval 'sub pud_present {
        local($pud) = @_;
	    eval q(1);
    }' unless defined(&pud_present);
    eval 'sub set_pte_at {
        local($mm,$addr,$ptep,$pteval) = @_;
	    eval q( &set_pte($ptep,$pteval));
    }' unless defined(&set_pte_at);
    eval 'sub __HAVE_ARCH_SET_PTE_ATOMIC () {1;}' unless defined(&__HAVE_ARCH_SET_PTE_ATOMIC);
    eval 'sub set_pte_atomic {
        local($pteptr,$pteval) = @_;
	    eval q( &set_64bit(($pteptr), &pte_val($pteval)));
    }' unless defined(&set_pte_atomic);
    eval 'sub set_pmd {
        local($pmdptr,$pmdval) = @_;
	    eval q( &set_64bit(($pmdptr), &pmd_val($pmdval)));
    }' unless defined(&set_pmd);
    eval 'sub set_pud {
        local($pudptr,$pudval) = @_;
	    eval q((*($pudptr) = ($pudval)));
    }' unless defined(&set_pud);
    eval 'sub pud_page {
        local($pud) = @_;
	    eval q((  &__va( &pud_val($pud) &  &PAGE_MASK)));
    }' unless defined(&pud_page);
    eval 'sub pud_page_kernel {
        local($pud) = @_;
	    eval q((  &__va( &pud_val($pud) &  &PAGE_MASK)));
    }' unless defined(&pud_page_kernel);
    eval 'sub pmd_offset {
        local($pud, $address) = @_;
	    eval q((  &pud_page(*($pud)) +  &pmd_index($address)));
    }' unless defined(&pmd_offset);
    eval 'sub pte_page {
        local($x) = @_;
	    eval q( &pfn_to_page( &pte_pfn($x)));
    }' unless defined(&pte_page);
    eval 'sub pte_to_pgoff {
        local($pte) = @_;
	    eval q((($pte). &pte_high));
    }' unless defined(&pte_to_pgoff);
    eval 'sub pgoff_to_pte {
        local($off) = @_;
	    eval q((( &pte_t) {  &_PAGE_FILE, ($off) }));
    }' unless defined(&pgoff_to_pte);
    eval 'sub PTE_FILE_MAX_BITS () {32;}' unless defined(&PTE_FILE_MAX_BITS);
    eval 'sub __swp_type {
        local($x) = @_;
	    eval q(((($x). &val) & 0x1f));
    }' unless defined(&__swp_type);
    eval 'sub __swp_offset {
        local($x) = @_;
	    eval q((($x). &val >> 5));
    }' unless defined(&__swp_offset);
    eval 'sub __swp_entry {
        local($type, $offset) = @_;
	    eval q((( &swp_entry_t){($type) | ($offset) << 5}));
    }' unless defined(&__swp_entry);
    eval 'sub __pte_to_swp_entry {
        local($pte) = @_;
	    eval q((( &swp_entry_t){ ($pte). &pte_high }));
    }' unless defined(&__pte_to_swp_entry);
    eval 'sub __swp_entry_to_pte {
        local($x) = @_;
	    eval q((( &pte_t){ 0, ($x). &val }));
    }' unless defined(&__swp_entry_to_pte);
    eval 'sub __pmd_free_tlb {
        local($tlb, $x) = @_;
	    eval q( &do { }  &while (0));
    }' unless defined(&__pmd_free_tlb);
}
1;
