require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SCHED_H)) {
    eval 'sub _LINUX_SCHED_H () {1;}' unless defined(&_LINUX_SCHED_H);
    require 'asm/param.ph';
    require 'linux/config.ph';
    require 'linux/capability.ph';
    require 'linux/threads.ph';
    require 'linux/kernel.ph';
    require 'linux/types.ph';
    require 'linux/timex.ph';
    require 'linux/jiffies.ph';
    require 'linux/rbtree.ph';
    require 'linux/thread_info.ph';
    require 'linux/cpumask.ph';
    require 'linux/errno.ph';
    require 'linux/nodemask.ph';
    require 'asm/system.ph';
    require 'asm/semaphore.ph';
    require 'asm/page.ph';
    require 'asm/ptrace.ph';
    require 'asm/mmu.ph';
    require 'asm/cputime.ph';
    require 'linux/smp.ph';
    require 'linux/sem.ph';
    require 'linux/signal.ph';
    require 'linux/securebits.ph';
    require 'linux/fs_struct.ph';
    require 'linux/compiler.ph';
    require 'linux/completion.ph';
    require 'linux/pid.ph';
    require 'linux/percpu.ph';
    require 'linux/topology.ph';
    require 'linux/seccomp.ph';
    require 'linux/rcupdate.ph';
    require 'linux/auxvec.ph';
    eval 'sub CSIGNAL () {0xff;}' unless defined(&CSIGNAL);
    eval 'sub CLONE_VM () {0x100;}' unless defined(&CLONE_VM);
    eval 'sub CLONE_FS () {0x200;}' unless defined(&CLONE_FS);
    eval 'sub CLONE_FILES () {0x400;}' unless defined(&CLONE_FILES);
    eval 'sub CLONE_SIGHAND () {0x800;}' unless defined(&CLONE_SIGHAND);
    eval 'sub CLONE_PTRACE () {0x2000;}' unless defined(&CLONE_PTRACE);
    eval 'sub CLONE_VFORK () {0x4000;}' unless defined(&CLONE_VFORK);
    eval 'sub CLONE_PARENT () {0x8000;}' unless defined(&CLONE_PARENT);
    eval 'sub CLONE_THREAD () {0x10000;}' unless defined(&CLONE_THREAD);
    eval 'sub CLONE_NEWNS () {0x20000;}' unless defined(&CLONE_NEWNS);
    eval 'sub CLONE_SYSVSEM () {0x40000;}' unless defined(&CLONE_SYSVSEM);
    eval 'sub CLONE_SETTLS () {0x80000;}' unless defined(&CLONE_SETTLS);
    eval 'sub CLONE_PARENT_SETTID () {0x100000;}' unless defined(&CLONE_PARENT_SETTID);
    eval 'sub CLONE_CHILD_CLEARTID () {0x200000;}' unless defined(&CLONE_CHILD_CLEARTID);
    eval 'sub CLONE_DETACHED () {0x400000;}' unless defined(&CLONE_DETACHED);
    eval 'sub CLONE_UNTRACED () {0x800000;}' unless defined(&CLONE_UNTRACED);
    eval 'sub CLONE_CHILD_SETTID () {0x1000000;}' unless defined(&CLONE_CHILD_SETTID);
    eval 'sub CLONE_STOPPED () {0x2000000;}' unless defined(&CLONE_STOPPED);
    eval 'sub CLONE_KERNEL () {( &CLONE_FS |  &CLONE_FILES |  &CLONE_SIGHAND);}' unless defined(&CLONE_KERNEL);
    eval 'sub FSHIFT () {11;}' unless defined(&FSHIFT);
    eval 'sub FIXED_1 () {(1<< &FSHIFT);}' unless defined(&FIXED_1);
    eval 'sub LOAD_FREQ () {(5* &HZ);}' unless defined(&LOAD_FREQ);
    eval 'sub EXP_1 () {1884;}' unless defined(&EXP_1);
    eval 'sub EXP_5 () {2014;}' unless defined(&EXP_5);
    eval 'sub EXP_15 () {2037;}' unless defined(&EXP_15);
    eval 'sub CALC_LOAD {
        local($load,$exp,$n) = @_;
	    eval q($load *= $exp; $load += $n*( &FIXED_1-$exp); $load >>=  &FSHIFT;);
    }' unless defined(&CALC_LOAD);
    require 'linux/time.ph';
    require 'linux/param.ph';
    require 'linux/resource.ph';
    require 'linux/timer.ph';
    require 'linux/hrtimer.ph';
    require 'asm/processor.ph';
    eval 'sub TASK_RUNNING () {0;}' unless defined(&TASK_RUNNING);
    eval 'sub TASK_INTERRUPTIBLE () {1;}' unless defined(&TASK_INTERRUPTIBLE);
    eval 'sub TASK_UNINTERRUPTIBLE () {2;}' unless defined(&TASK_UNINTERRUPTIBLE);
    eval 'sub TASK_STOPPED () {4;}' unless defined(&TASK_STOPPED);
    eval 'sub TASK_TRACED () {8;}' unless defined(&TASK_TRACED);
    eval 'sub EXIT_ZOMBIE () {16;}' unless defined(&EXIT_ZOMBIE);
    eval 'sub EXIT_DEAD () {32;}' unless defined(&EXIT_DEAD);
    eval 'sub TASK_NONINTERACTIVE () {64;}' unless defined(&TASK_NONINTERACTIVE);
    eval 'sub __set_task_state {
        local($tsk, $state_value) = @_;
	    eval q( &do { ($tsk)-> &state = ($state_value); }  &while (0));
    }' unless defined(&__set_task_state);
    eval 'sub set_task_state {
        local($tsk, $state_value) = @_;
	    eval q( &set_mb(($tsk)-> &state, ($state_value)));
    }' unless defined(&set_task_state);
    eval 'sub __set_current_state {
        local($state_value) = @_;
	    eval q( &do {  ($current->{state}) = ($state_value); }  &while (0));
    }' unless defined(&__set_current_state);
    eval 'sub set_current_state {
        local($state_value) = @_;
	    eval q( &set_mb( ($current->{state}), ($state_value)));
    }' unless defined(&set_current_state);
    eval 'sub TASK_COMM_LEN () {16;}' unless defined(&TASK_COMM_LEN);
    eval 'sub SCHED_NORMAL () {0;}' unless defined(&SCHED_NORMAL);
    eval 'sub SCHED_FIFO () {1;}' unless defined(&SCHED_FIFO);
    eval 'sub SCHED_RR () {2;}' unless defined(&SCHED_RR);
    eval 'sub SCHED_BATCH () {3;}' unless defined(&SCHED_BATCH);
    if(defined(&__KERNEL__)) {
	require 'linux/spinlock.ph';
	if(defined(&CONFIG_DETECT_SOFTLOCKUP)) {
	} else {
	}
	eval 'sub __sched () { &__attribute__(( &__section__(".sched.text")));}' unless defined(&__sched);
	eval 'sub MAX_SCHEDULE_TIMEOUT () { &LONG_MAX;}' unless defined(&MAX_SCHEDULE_TIMEOUT);
	eval 'sub DEFAULT_MAX_MAP_COUNT () {65536;}' unless defined(&DEFAULT_MAX_MAP_COUNT);
	require 'linux/aio.ph';
	if((defined(&NR_CPUS) ? &NR_CPUS : 0) >= (defined(&CONFIG_SPLIT_PTLOCK_CPUS) ? &CONFIG_SPLIT_PTLOCK_CPUS : 0)) {
	    eval 'sub set_mm_counter {
	        local($mm, $member, $value) = @_;
    		eval q( &atomic_long_set(($mm)-> &_$member, $value));
	    }' unless defined(&set_mm_counter);
	    eval 'sub get_mm_counter {
	        local($mm, $member) = @_;
    		eval q(( &atomic_long_read(($mm)-> &_$member)));
	    }' unless defined(&get_mm_counter);
	    eval 'sub add_mm_counter {
	        local($mm, $member, $value) = @_;
    		eval q( &atomic_long_add($value, ($mm)-> &_$member));
	    }' unless defined(&add_mm_counter);
	    eval 'sub inc_mm_counter {
	        local($mm, $member) = @_;
    		eval q( &atomic_long_inc(($mm)-> &_$member));
	    }' unless defined(&inc_mm_counter);
	    eval 'sub dec_mm_counter {
	        local($mm, $member) = @_;
    		eval q( &atomic_long_dec(($mm)-> &_$member));
	    }' unless defined(&dec_mm_counter);
	} else {
	    eval 'sub set_mm_counter {
	        local($mm, $member, $value) = @_;
    		eval q(($mm)-> &_$member = ($value));
	    }' unless defined(&set_mm_counter);
	    eval 'sub get_mm_counter {
	        local($mm, $member) = @_;
    		eval q((($mm)-> &_$member));
	    }' unless defined(&get_mm_counter);
	    eval 'sub add_mm_counter {
	        local($mm, $member, $value) = @_;
    		eval q(($mm)-> &_$member += ($value));
	    }' unless defined(&add_mm_counter);
	    eval 'sub inc_mm_counter {
	        local($mm, $member) = @_;
    		eval q(($mm)-> &_$member++);
	    }' unless defined(&inc_mm_counter);
	    eval 'sub dec_mm_counter {
	        local($mm, $member) = @_;
    		eval q(($mm)-> &_$member--);
	    }' unless defined(&dec_mm_counter);
	}
	eval 'sub get_mm_rss {
	    local($mm) = @_;
    	    eval q(( &get_mm_counter($mm,  &file_rss) +  &get_mm_counter($mm,  &anon_rss)));
	}' unless defined(&get_mm_rss);
	eval 'sub update_hiwater_rss {
	    local($mm) = @_;
    	    eval q( &do { \'unsigned long _rss\' =  &get_mm_rss($mm);  &if (($mm)-> &hiwater_rss <  &_rss) ($mm)-> &hiwater_rss =  &_rss; }  &while (0));
	}' unless defined(&update_hiwater_rss);
	eval 'sub update_hiwater_vm {
	    local($mm) = @_;
    	    eval q( &do {  &if (($mm)-> &hiwater_vm < ($mm)-> &total_vm) ($mm)-> &hiwater_vm = ($mm)-> &total_vm; }  &while (0));
	}' unless defined(&update_hiwater_vm);
	if(defined(&CONFIG_KEYS)) {
	}
	if(defined(&__ARCH_WANT_INTERRUPTS_ON_CTXSW)) {
	    eval 'sub __ARCH_WANT_UNLOCKED_CTXSW () {1;}' unless defined(&__ARCH_WANT_UNLOCKED_CTXSW);
	}
	eval 'sub SIGNAL_STOP_STOPPED () {0x1;}' unless defined(&SIGNAL_STOP_STOPPED);
	eval 'sub SIGNAL_STOP_DEQUEUED () {0x2;}' unless defined(&SIGNAL_STOP_DEQUEUED);
	eval 'sub SIGNAL_STOP_CONTINUED () {0x4;}' unless defined(&SIGNAL_STOP_CONTINUED);
	eval 'sub SIGNAL_GROUP_EXIT () {0x8;}' unless defined(&SIGNAL_GROUP_EXIT);
	eval 'sub MAX_USER_RT_PRIO () {100;}' unless defined(&MAX_USER_RT_PRIO);
	eval 'sub MAX_RT_PRIO () { &MAX_USER_RT_PRIO;}' unless defined(&MAX_RT_PRIO);
	eval 'sub MAX_PRIO () {( &MAX_RT_PRIO + 40);}' unless defined(&MAX_PRIO);
	eval 'sub rt_task {
	    local($p) = @_;
    	    eval q(( &unlikely(($p)-> &prio <  &MAX_RT_PRIO)));
	}' unless defined(&rt_task);
	if(defined(&CONFIG_INOTIFY)) {
	}
	if(defined(&CONFIG_KEYS)) {
	}
	eval 'sub INIT_USER () {( &root_user);}' unless defined(&INIT_USER);
	if(defined(&CONFIG_SCHEDSTATS)) {
	}
	eval("sub SCHED_IDLE () { 0; }") unless defined(&SCHED_IDLE);
	eval("sub NOT_IDLE () { 1; }") unless defined(&NOT_IDLE);
	eval("sub NEWLY_IDLE () { 2; }") unless defined(&NEWLY_IDLE);
	eval("sub MAX_IDLE_TYPES () { 3; }") unless defined(&MAX_IDLE_TYPES);
	if(defined(&CONFIG_SMP)) {
	    eval 'sub SCHED_LOAD_SCALE () {128;}' unless defined(&SCHED_LOAD_SCALE);
	    eval 'sub SD_LOAD_BALANCE () {1;}' unless defined(&SD_LOAD_BALANCE);
	    eval 'sub SD_BALANCE_NEWIDLE () {2;}' unless defined(&SD_BALANCE_NEWIDLE);
	    eval 'sub SD_BALANCE_EXEC () {4;}' unless defined(&SD_BALANCE_EXEC);
	    eval 'sub SD_BALANCE_FORK () {8;}' unless defined(&SD_BALANCE_FORK);
	    eval 'sub SD_WAKE_IDLE () {16;}' unless defined(&SD_WAKE_IDLE);
	    eval 'sub SD_WAKE_AFFINE () {32;}' unless defined(&SD_WAKE_AFFINE);
	    eval 'sub SD_WAKE_BALANCE () {64;}' unless defined(&SD_WAKE_BALANCE);
	    eval 'sub SD_SHARE_CPUPOWER () {128;}' unless defined(&SD_SHARE_CPUPOWER);
	    if(defined(&CONFIG_SCHEDSTATS)) {
	    }
	}
	eval 'sub NGROUPS_SMALL () {32;}' unless defined(&NGROUPS_SMALL);
	eval 'sub NGROUPS_PER_BLOCK () {(( &PAGE_SIZE / $sizeof{ &gid_t}));}' unless defined(&NGROUPS_PER_BLOCK);
	eval 'sub get_group_info {
	    local($group_info) = @_;
    	    eval q( &do {  &atomic_inc(($group_info)-> &usage); }  &while (0));
	}' unless defined(&get_group_info);
	eval 'sub put_group_info {
	    local($group_info) = @_;
    	    eval q( &do {  &if ( &atomic_dec_and_test(($group_info)-> &usage))  &groups_free($group_info); }  &while (0));
	}' unless defined(&put_group_info);
	eval 'sub GROUP_AT {
	    local($gi, $i) = @_;
    	    eval q((($gi)-> $blocks[($i)/ &NGROUPS_PER_BLOCK][($i)% &NGROUPS_PER_BLOCK]));
	}' unless defined(&GROUP_AT);
	if(defined(&ARCH_HAS_PREFETCH_SWITCH_STACK)) {
	} else {
	}
	if(defined( &CONFIG_SMP)  && defined( &__ARCH_WANT_UNLOCKED_CTXSW)) {
	}
	if(defined(&CONFIG_SCHEDSTATS)) {
	}
	if(defined(&CONFIG_KEYS)) {
	}
	if(defined(&CONFIG_DEBUG_MUTEXES)) {
	}
	if(defined( &CONFIG_BSD_PROCESS_ACCT)) {
	}
	if(defined(&CONFIG_NUMA)) {
	}
	if(defined(&CONFIG_CPUSETS)) {
	}
	eval 'sub get_task_struct {
	    local($tsk) = @_;
    	    eval q( &do {  &atomic_inc(($tsk)-> &usage); }  &while(0));
	}' unless defined(&get_task_struct);
	eval 'sub PF_ALIGNWARN () {0x1;}' unless defined(&PF_ALIGNWARN);
	eval 'sub PF_STARTING () {0x2;}' unless defined(&PF_STARTING);
	eval 'sub PF_EXITING () {0x4;}' unless defined(&PF_EXITING);
	eval 'sub PF_DEAD () {0x8;}' unless defined(&PF_DEAD);
	eval 'sub PF_FORKNOEXEC () {0x40;}' unless defined(&PF_FORKNOEXEC);
	eval 'sub PF_SUPERPRIV () {0x100;}' unless defined(&PF_SUPERPRIV);
	eval 'sub PF_DUMPCORE () {0x200;}' unless defined(&PF_DUMPCORE);
	eval 'sub PF_SIGNALED () {0x400;}' unless defined(&PF_SIGNALED);
	eval 'sub PF_MEMALLOC () {0x800;}' unless defined(&PF_MEMALLOC);
	eval 'sub PF_FLUSHER () {0x1000;}' unless defined(&PF_FLUSHER);
	eval 'sub PF_USED_MATH () {0x2000;}' unless defined(&PF_USED_MATH);
	eval 'sub PF_FREEZE () {0x4000;}' unless defined(&PF_FREEZE);
	eval 'sub PF_NOFREEZE () {0x8000;}' unless defined(&PF_NOFREEZE);
	eval 'sub PF_FROZEN () {0x10000;}' unless defined(&PF_FROZEN);
	eval 'sub PF_FSTRANS () {0x20000;}' unless defined(&PF_FSTRANS);
	eval 'sub PF_KSWAPD () {0x40000;}' unless defined(&PF_KSWAPD);
	eval 'sub PF_SWAPOFF () {0x80000;}' unless defined(&PF_SWAPOFF);
	eval 'sub PF_LESS_THROTTLE () {0x100000;}' unless defined(&PF_LESS_THROTTLE);
	eval 'sub PF_SYNCWRITE () {0x200000;}' unless defined(&PF_SYNCWRITE);
	eval 'sub PF_BORROWED_MM () {0x400000;}' unless defined(&PF_BORROWED_MM);
	eval 'sub PF_RANDOMIZE () {0x800000;}' unless defined(&PF_RANDOMIZE);
	eval 'sub PF_SWAPWRITE () {0x1000000;}' unless defined(&PF_SWAPWRITE);
	eval 'sub clear_stopped_child_used_math {
	    local($child) = @_;
    	    eval q( &do { ($child)-> &flags &= ~ &PF_USED_MATH; }  &while (0));
	}' unless defined(&clear_stopped_child_used_math);
	eval 'sub set_stopped_child_used_math {
	    local($child) = @_;
    	    eval q( &do { ($child)-> &flags |=  &PF_USED_MATH; }  &while (0));
	}' unless defined(&set_stopped_child_used_math);
	eval 'sub clear_used_math () {
	    eval q( &clear_stopped_child_used_math( &current));
	}' unless defined(&clear_used_math);
	eval 'sub set_used_math () {
	    eval q( &set_stopped_child_used_math( &current));
	}' unless defined(&set_used_math);
	eval 'sub conditional_stopped_child_used_math {
	    local($condition, $child) = @_;
    	    eval q( &do { ($child)-> &flags &= ~ &PF_USED_MATH, ($child)-> &flags |= ($condition) ?  &PF_USED_MATH : 0; }  &while (0));
	}' unless defined(&conditional_stopped_child_used_math);
	eval 'sub conditional_used_math {
	    local($condition) = @_;
    	    eval q( &conditional_stopped_child_used_math($condition,  &current));
	}' unless defined(&conditional_used_math);
	eval 'sub copy_to_stopped_child_used_math {
	    local($child) = @_;
    	    eval q( &do { ($child)-> &flags &= ~ &PF_USED_MATH, ($child)-> &flags |=  ($current->{flags}) &  &PF_USED_MATH; }  &while (0));
	}' unless defined(&copy_to_stopped_child_used_math);
	eval 'sub tsk_used_math {
	    local($p) = @_;
    	    eval q((($p)-> &flags &  &PF_USED_MATH));
	}' unless defined(&tsk_used_math);
	eval 'sub used_math () {
	    eval q( &tsk_used_math( &current));
	}' unless defined(&used_math);
	if(defined(&CONFIG_SMP)) {
	} else {
	}
	if(defined(&CONFIG_SMP)) {
	} else {
	    eval 'sub sched_exec () {
	        eval q({});
	    }' unless defined(&sched_exec);
	}
	if(defined(&CONFIG_HOTPLUG_CPU)) {
	} else {
	}
	unless(defined(&__HAVE_ARCH_KSTACK_END)) {
	}
	eval 'sub find_task_by_pid {
	    local($nr) = @_;
    	    eval q( &find_task_by_pid_type( &PIDTYPE_PID, $nr));
	}' unless defined(&find_task_by_pid);
	require 'asm/current.ph';
	if(defined(&CONFIG_SMP)) {
	} else {
	}
	eval 'sub SEND_SIG_NOINFO () {( 0);}' unless defined(&SEND_SIG_NOINFO);
	eval 'sub SEND_SIG_PRIV () {( 1);}' unless defined(&SEND_SIG_PRIV);
	eval 'sub SEND_SIG_FORCED () {( 2);}' unless defined(&SEND_SIG_FORCED);
	if(defined(&CONFIG_SMP)) {
	} else {
	    eval 'sub wait_task_inactive {
	        local($p) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&wait_task_inactive);
	}
	eval 'sub remove_parent {
	    local($p) = @_;
    	    eval q( &list_del_init(($p)-> &sibling));
	}' unless defined(&remove_parent);
	eval 'sub add_parent {
	    local($p, $parent) = @_;
    	    eval q( &list_add_tail(($p)-> &sibling,($parent)-> &children));
	}' unless defined(&add_parent);
	eval 'sub REMOVE_LINKS {
	    local($p) = @_;
    	    eval q( &do {  &if ( &thread_group_leader($p))  &list_del_init(($p)-> &tasks);  &remove_parent($p); }  &while (0));
	}' unless defined(&REMOVE_LINKS);
	eval 'sub SET_LINKS {
	    local($p) = @_;
    	    eval q( &do {  &if ( &thread_group_leader($p))  &list_add_tail(($p)-> &tasks, ($init_task->{tasks}));  &add_parent($p, ($p)-> &parent); }  &while (0));
	}' unless defined(&SET_LINKS);
	eval 'sub next_task {
	    local($p) = @_;
    	    eval q( &list_entry(($p)-> ($tasks->{next}), 1;
	}' unless defined(&next_task);
	eval 'sub prev_task {
	    local($p) = @_;
    	    eval q( &list_entry(($p)-> ($tasks->{prev}), 1;
	}' unless defined(&prev_task);
	eval 'sub for_each_process {
	    local($p) = @_;
    	    eval q( &for ($p =  &init_task ; ($p =  &next_task($p)) !=  &init_task ; ));
	}' unless defined(&for_each_process);
	eval 'sub do_each_thread {
	    local($g, $t) = @_;
    	    eval q( &for ($g = $t =  &init_task ; ($g = $t =  &next_task($g)) !=  &init_task ; )  &do);
	}' unless defined(&do_each_thread);
	eval 'sub while_each_thread {
	    local($g, $t) = @_;
    	    eval q( &while (($t =  &next_thread($t)) != $g));
	}' unless defined(&while_each_thread);
	eval 'sub thread_group_leader {
	    local($p) = @_;
    	    eval q(( ($p->{pid}) ==  ($p->{tgid})));
	}' unless defined(&thread_group_leader);
	eval 'sub delay_group_leader {
	    local($p) = @_;
    	    eval q(( &thread_group_leader($p)  && ! &thread_group_empty($p)));
	}' unless defined(&delay_group_leader);
	unless(defined(&__HAVE_THREAD_FUNCTIONS)) {
	    eval 'sub task_thread_info {
	        local($task) = @_;
    		eval q(($task)-> &thread_info);
	    }' unless defined(&task_thread_info);
	    eval 'sub task_stack_page {
	        local($task) = @_;
    		eval q(((($task)-> &thread_info)));
	    }' unless defined(&task_stack_page);
	}
	if(defined( &CONFIG_PREEMPT)  && defined( &CONFIG_SMP)) {
	    eval 'sub need_lockbreak {
	        local($lock) = @_;
    		eval q((($lock)-> &break_lock));
	    }' unless defined(&need_lockbreak);
	} else {
	    eval 'sub need_lockbreak {
	        local($lock) = @_;
    		eval q(0);
	    }' unless defined(&need_lockbreak);
	}
	if(defined(&CONFIG_SMP)) {
	} else {
	}
	if(defined(&HAVE_ARCH_PICK_MMAP_LAYOUT)) {
	} else {
	}
	if(defined(&CONFIG_PM)) {
	} else {
	}
    }
}
1;
