require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_MM_H)) {
    eval 'sub _LINUX_MM_H () {1;}' unless defined(&_LINUX_MM_H);
    require 'linux/sched.ph';
    require 'linux/errno.ph';
    require 'linux/capability.ph';
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/gfp.ph';
	require 'linux/list.ph';
	require 'linux/mmzone.ph';
	require 'linux/rbtree.ph';
	require 'linux/prio_tree.ph';
	require 'linux/fs.ph';
	require 'linux/mutex.ph';
	unless(defined(&CONFIG_DISCONTIGMEM)) {
	}
	if(defined(&CONFIG_SYSCTL)) {
	} else {
	    eval 'sub sysctl_legacy_va_layout () {0;}' unless defined(&sysctl_legacy_va_layout);
	}
	require 'asm/page.ph';
	require 'asm/pgtable.ph';
	require 'asm/processor.ph';
	require 'asm/atomic.ph';
	eval 'sub nth_page {
	    local($page,$n) = @_;
    	    eval q( &pfn_to_page( &page_to_pfn(($page)) + ($n)));
	}' unless defined(&nth_page);
	unless(defined(&CONFIG_MMU)) {
	}
	if(defined(&CONFIG_NUMA)) {
	}
	unless(defined(&CONFIG_MMU)) {
	}
	eval 'sub VM_READ () {0x1;}' unless defined(&VM_READ);
	eval 'sub VM_WRITE () {0x2;}' unless defined(&VM_WRITE);
	eval 'sub VM_EXEC () {0x4;}' unless defined(&VM_EXEC);
	eval 'sub VM_SHARED () {0x8;}' unless defined(&VM_SHARED);
	eval 'sub VM_MAYREAD () {0x10;}' unless defined(&VM_MAYREAD);
	eval 'sub VM_MAYWRITE () {0x20;}' unless defined(&VM_MAYWRITE);
	eval 'sub VM_MAYEXEC () {0x40;}' unless defined(&VM_MAYEXEC);
	eval 'sub VM_MAYSHARE () {0x80;}' unless defined(&VM_MAYSHARE);
	eval 'sub VM_GROWSDOWN () {0x100;}' unless defined(&VM_GROWSDOWN);
	eval 'sub VM_GROWSUP () {0x200;}' unless defined(&VM_GROWSUP);
	eval 'sub VM_SHM () {0x;}' unless defined(&VM_SHM);
	eval 'sub VM_PFNMAP () {0x400;}' unless defined(&VM_PFNMAP);
	eval 'sub VM_DENYWRITE () {0x800;}' unless defined(&VM_DENYWRITE);
	eval 'sub VM_EXECUTABLE () {0x1000;}' unless defined(&VM_EXECUTABLE);
	eval 'sub VM_LOCKED () {0x2000;}' unless defined(&VM_LOCKED);
	eval 'sub VM_IO () {0x4000;}' unless defined(&VM_IO);
	eval 'sub VM_SEQ_READ () {0x8000;}' unless defined(&VM_SEQ_READ);
	eval 'sub VM_RAND_READ () {0x10000;}' unless defined(&VM_RAND_READ);
	eval 'sub VM_DONTCOPY () {0x20000;}' unless defined(&VM_DONTCOPY);
	eval 'sub VM_DONTEXPAND () {0x40000;}' unless defined(&VM_DONTEXPAND);
	eval 'sub VM_RESERVED () {0x80000;}' unless defined(&VM_RESERVED);
	eval 'sub VM_ACCOUNT () {0x100000;}' unless defined(&VM_ACCOUNT);
	eval 'sub VM_HUGETLB () {0x400000;}' unless defined(&VM_HUGETLB);
	eval 'sub VM_NONLINEAR () {0x800000;}' unless defined(&VM_NONLINEAR);
	eval 'sub VM_MAPPED_COPY () {0x1000000;}' unless defined(&VM_MAPPED_COPY);
	eval 'sub VM_INSERTPAGE () {0x2000000;}' unless defined(&VM_INSERTPAGE);
	unless(defined(&VM_STACK_DEFAULT_FLAGS)) {
	    eval 'sub VM_STACK_DEFAULT_FLAGS () { &VM_DATA_DEFAULT_FLAGS;}' unless defined(&VM_STACK_DEFAULT_FLAGS);
	}
	if(defined(&CONFIG_STACK_GROWSUP)) {
	    eval 'sub VM_STACK_FLAGS () {( &VM_GROWSUP |  &VM_STACK_DEFAULT_FLAGS |  &VM_ACCOUNT);}' unless defined(&VM_STACK_FLAGS);
	} else {
	    eval 'sub VM_STACK_FLAGS () {( &VM_GROWSDOWN |  &VM_STACK_DEFAULT_FLAGS |  &VM_ACCOUNT);}' unless defined(&VM_STACK_FLAGS);
	}
	eval 'sub VM_READHINTMASK () {( &VM_SEQ_READ |  &VM_RAND_READ);}' unless defined(&VM_READHINTMASK);
	eval 'sub VM_ClearReadHint {
	    local($v) = @_;
    	    eval q(($v)-> &vm_flags &= ~ &VM_READHINTMASK);
	}' unless defined(&VM_ClearReadHint);
	eval 'sub VM_NormalReadHint {
	    local($v) = @_;
    	    eval q((!(($v)-> &vm_flags &  &VM_READHINTMASK)));
	}' unless defined(&VM_NormalReadHint);
	eval 'sub VM_SequentialReadHint {
	    local($v) = @_;
    	    eval q((($v)-> &vm_flags &  &VM_SEQ_READ));
	}' unless defined(&VM_SequentialReadHint);
	eval 'sub VM_RandomReadHint {
	    local($v) = @_;
    	    eval q((($v)-> &vm_flags &  &VM_RAND_READ));
	}' unless defined(&VM_RandomReadHint);
	if(defined(&CONFIG_NUMA)) {
	}
	if((defined(&NR_CPUS) ? &NR_CPUS : 0) >= (defined(&CONFIG_SPLIT_PTLOCK_CPUS) ? &CONFIG_SPLIT_PTLOCK_CPUS : 0)) {
	}
	if(defined( &WANT_PAGE_VIRTUAL)) {
	}
	eval 'sub page_private {
	    local($page) = @_;
    	    eval q((($page)-> &private));
	}' unless defined(&page_private);
	eval 'sub set_page_private {
	    local($page, $v) = @_;
    	    eval q((($page)-> &private = ($v)));
	}' unless defined(&set_page_private);
	require 'linux/page-flags.ph';
	eval 'sub put_page_testzero {
	    local($p) = @_;
    	    eval q(({  &BUG_ON( &atomic_read(($p)-> &_count) == -1);  &atomic_add_negative(-1, ($p)-> &_count); }));
	}' unless defined(&put_page_testzero);
	eval 'sub get_page_testone {
	    local($p) = @_;
    	    eval q( &atomic_inc_and_test(($p)-> &_count));
	}' unless defined(&get_page_testone);
	eval 'sub set_page_count {
	    local($p,$v) = @_;
    	    eval q( &atomic_set(($p)-> &_count, ($v) - 1));
	}' unless defined(&set_page_count);
	eval 'sub __put_page {
	    local($p) = @_;
    	    eval q( &atomic_dec(($p)-> &_count));
	}' unless defined(&__put_page);
	if(defined(&CONFIG_SPARSEMEM)) {
	    eval 'sub SECTIONS_WIDTH () { &SECTIONS_SHIFT;}' unless defined(&SECTIONS_WIDTH);
	} else {
	    eval 'sub SECTIONS_WIDTH () {0;}' unless defined(&SECTIONS_WIDTH);
	}
	eval 'sub ZONES_WIDTH () { &ZONES_SHIFT;}' unless defined(&ZONES_WIDTH);
	if((defined(&SECTIONS_WIDTH) ? &SECTIONS_WIDTH : 0)+(defined(&ZONES_WIDTH) ? &ZONES_WIDTH : 0)+(defined(&NODES_SHIFT) ? &NODES_SHIFT : 0) <= (defined(&FLAGS_RESERVED) ? &FLAGS_RESERVED : 0)) {
	    eval 'sub NODES_WIDTH () { &NODES_SHIFT;}' unless defined(&NODES_WIDTH);
	} else {
	    eval 'sub NODES_WIDTH () {0;}' unless defined(&NODES_WIDTH);
	}
	eval 'sub SECTIONS_PGOFF () {(($sizeof{\'unsigned long\'}*8) -  &SECTIONS_WIDTH);}' unless defined(&SECTIONS_PGOFF);
	eval 'sub NODES_PGOFF () {( &SECTIONS_PGOFF -  &NODES_WIDTH);}' unless defined(&NODES_PGOFF);
	eval 'sub ZONES_PGOFF () {( &NODES_PGOFF -  &ZONES_WIDTH);}' unless defined(&ZONES_PGOFF);
	eval 'sub FLAGS_HAS_NODE () {( &NODES_WIDTH > 0||  &NODES_SHIFT == 0);}' unless defined(&FLAGS_HAS_NODE);
	unless(defined(&PFN_SECTION_SHIFT)) {
	    eval 'sub PFN_SECTION_SHIFT () {0;}' unless defined(&PFN_SECTION_SHIFT);
	}
	eval 'sub SECTIONS_PGSHIFT () {( &SECTIONS_PGOFF * ( &SECTIONS_WIDTH != 0));}' unless defined(&SECTIONS_PGSHIFT);
	eval 'sub NODES_PGSHIFT () {( &NODES_PGOFF * ( &NODES_WIDTH != 0));}' unless defined(&NODES_PGSHIFT);
	eval 'sub ZONES_PGSHIFT () {( &ZONES_PGOFF * ( &ZONES_WIDTH != 0));}' unless defined(&ZONES_PGSHIFT);
	if((defined(&FLAGS_HAS_NODE) ? &FLAGS_HAS_NODE : 0)) {
	    eval 'sub ZONETABLE_SHIFT () {( &NODES_SHIFT +  &ZONES_SHIFT);}' unless defined(&ZONETABLE_SHIFT);
	} else {
	    eval 'sub ZONETABLE_SHIFT () {( &SECTIONS_SHIFT +  &ZONES_SHIFT);}' unless defined(&ZONETABLE_SHIFT);
	}
	eval 'sub ZONETABLE_PGSHIFT () { &ZONES_PGSHIFT;}' unless defined(&ZONETABLE_PGSHIFT);
	if((defined(&SECTIONS_WIDTH) ? &SECTIONS_WIDTH : 0)+(defined(&NODES_WIDTH) ? &NODES_WIDTH : 0)+(defined(&ZONES_WIDTH) ? &ZONES_WIDTH : 0) > (defined(&FLAGS_RESERVED) ? &FLAGS_RESERVED : 0)) {
	    die("SECTIONS_WIDTH\+NODES_WIDTH\+ZONES_WIDTH\ \>\ FLAGS_RESERVED");
	}
	eval 'sub ZONES_MASK () {((1 <<  &ZONES_WIDTH) - 1);}' unless defined(&ZONES_MASK);
	eval 'sub NODES_MASK () {((1 <<  &NODES_WIDTH) - 1);}' unless defined(&NODES_MASK);
	eval 'sub SECTIONS_MASK () {((1 <<  &SECTIONS_WIDTH) - 1);}' unless defined(&SECTIONS_MASK);
	eval 'sub ZONETABLE_MASK () {((1 <<  &ZONETABLE_SHIFT) - 1);}' unless defined(&ZONETABLE_MASK);
	unless(defined(&CONFIG_DISCONTIGMEM)) {
	}
	if(defined( &CONFIG_HIGHMEM)  && !defined( &WANT_PAGE_VIRTUAL)) {
	    eval 'sub HASHED_PAGE_VIRTUAL () {1;}' unless defined(&HASHED_PAGE_VIRTUAL);
	}
	if(defined( &WANT_PAGE_VIRTUAL)) {
	    eval 'sub page_address {
	        local($page) = @_;
    		eval q((($page)-> &virtual));
	    }' unless defined(&page_address);
	    eval 'sub set_page_address {
	        local($page, $address) = @_;
    		eval q( &do { ($page)-> &virtual = ($address); }  &while(0));
	    }' unless defined(&set_page_address);
	    eval 'sub page_address_init () {
	        eval q( &do { }  &while(0));
	    }' unless defined(&page_address_init);
	}
	if(defined( &HASHED_PAGE_VIRTUAL)) {
	}
	if(!defined( &HASHED_PAGE_VIRTUAL)  && !defined( &WANT_PAGE_VIRTUAL)) {
	    eval 'sub page_address {
	        local($page) = @_;
    		eval q( &lowmem_page_address($page));
	    }' unless defined(&page_address);
	    eval 'sub set_page_address {
	        local($page, $address) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&set_page_address);
	    eval 'sub page_address_init () {
	        eval q( &do { }  &while(0));
	    }' unless defined(&page_address_init);
	}
	eval 'sub PAGE_MAPPING_ANON () {1;}' unless defined(&PAGE_MAPPING_ANON);
	eval 'sub NOPAGE_SIGBUS () {( &NULL);}' unless defined(&NOPAGE_SIGBUS);
	eval 'sub NOPAGE_OOM () {( (-1));}' unless defined(&NOPAGE_OOM);
	eval 'sub VM_FAULT_OOM () {0x;}' unless defined(&VM_FAULT_OOM);
	eval 'sub VM_FAULT_SIGBUS () {0x1;}' unless defined(&VM_FAULT_SIGBUS);
	eval 'sub VM_FAULT_MINOR () {0x2;}' unless defined(&VM_FAULT_MINOR);
	eval 'sub VM_FAULT_MAJOR () {0x3;}' unless defined(&VM_FAULT_MAJOR);
	eval 'sub VM_FAULT_WRITE () {0x10;}' unless defined(&VM_FAULT_WRITE);
	eval 'sub offset_in_page {
	    local($p) = @_;
    	    eval q((($p) & ~ &PAGE_MASK));
	}' unless defined(&offset_in_page);
	if(defined(&CONFIG_SHMEM)) {
	} else {
	    eval 'sub shmem_nopage () { &filemap_nopage;}' unless defined(&shmem_nopage);
	}
	unless(defined(&CONFIG_MMU)) {
	}
	if(defined(&CONFIG_MMU)) {
	} else {
	}
	eval 'sub DEFAULT_SEEKS () {2;}' unless defined(&DEFAULT_SEEKS);
	if(defined( &CONFIG_MMU)  && !defined( &__ARCH_HAS_4LEVEL_HACK)) {
	}
	if((defined(&NR_CPUS) ? &NR_CPUS : 0) >= (defined(&CONFIG_SPLIT_PTLOCK_CPUS) ? &CONFIG_SPLIT_PTLOCK_CPUS : 0)) {
	    eval 'sub __pte_lockptr {
	        local($page) = @_;
    		eval q((($page)-> &ptl));
	    }' unless defined(&__pte_lockptr);
	    eval 'sub pte_lock_init {
	        local($_page) = @_;
    		eval q( &do {  &spin_lock_init( &__pte_lockptr($_page)); }  &while (0));
	    }' unless defined(&pte_lock_init);
	    eval 'sub pte_lock_deinit {
	        local($page) = @_;
    		eval q((($page)-> &mapping =  &NULL));
	    }' unless defined(&pte_lock_deinit);
	    eval 'sub pte_lockptr {
	        local($mm, $pmd) = @_;
    		eval q(({($mm);  &__pte_lockptr( &pmd_page(*($pmd)));}));
	    }' unless defined(&pte_lockptr);
	} else {
	    eval 'sub pte_lock_init {
	        local($page) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&pte_lock_init);
	    eval 'sub pte_lock_deinit {
	        local($page) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&pte_lock_deinit);
	    eval 'sub pte_lockptr {
	        local($mm, $pmd) = @_;
    		eval q(({($pmd); ($mm)-> &page_table_lock;}));
	    }' unless defined(&pte_lockptr);
	}
	eval 'sub pte_offset_map_lock {
	    local($mm, $pmd, $address, $ptlp) = @_;
    	    eval q(({  &spinlock_t * &__ptl =  &pte_lockptr($mm, $pmd);  &pte_t * &__pte =  &pte_offset_map($pmd, $address); *($ptlp) =  &__ptl;  &spin_lock( &__ptl);  &__pte; }));
	}' unless defined(&pte_offset_map_lock);
	eval 'sub pte_unmap_unlock {
	    local($pte, $ptl) = @_;
    	    eval q( &do {  &spin_unlock($ptl);  &pte_unmap($pte); }  &while (0));
	}' unless defined(&pte_unmap_unlock);
	eval 'sub pte_alloc_map {
	    local($mm, $pmd, $address) = @_;
    	    eval q((( &unlikely(! &pmd_present(*($pmd)))  &&  &__pte_alloc($mm, $pmd, $address))?  &NULL:  &pte_offset_map($pmd, $address)));
	}' unless defined(&pte_alloc_map);
	eval 'sub pte_alloc_map_lock {
	    local($mm, $pmd, $address, $ptlp) = @_;
    	    eval q((( &unlikely(! &pmd_present(*($pmd)))  &&  &__pte_alloc($mm, $pmd, $address))?  &NULL:  &pte_offset_map_lock($mm, $pmd, $address, $ptlp)));
	}' unless defined(&pte_alloc_map_lock);
	eval 'sub pte_alloc_kernel {
	    local($pmd, $address) = @_;
    	    eval q((( &unlikely(! &pmd_present(*($pmd)))  &&  &__pte_alloc_kernel($pmd, $address))?  &NULL:  &pte_offset_kernel($pmd, $address)));
	}' unless defined(&pte_alloc_kernel);
	if(defined(&CONFIG_NUMA)) {
	} else {
	}
	eval 'sub vma_prio_tree_foreach {
	    local($vma, $iter, $root, $begin, $end) = @_;
    	    eval q( &for ( &prio_tree_iter_init($iter, $root, $begin, $end), $vma =  &NULL; ($vma =  &vma_prio_tree_next($vma, $iter)); ));
	}' unless defined(&vma_prio_tree_foreach);
	eval 'sub VM_MAX_READAHEAD () {128;}' unless defined(&VM_MAX_READAHEAD);
	eval 'sub VM_MIN_READAHEAD () {16;}' unless defined(&VM_MIN_READAHEAD);
	eval 'sub VM_MAX_CACHE_HIT () {256;}' unless defined(&VM_MAX_CACHE_HIT);
	if(defined(&CONFIG_IA64)) {
	}
	eval 'sub FOLL_WRITE () {0x1;}' unless defined(&FOLL_WRITE);
	eval 'sub FOLL_TOUCH () {0x2;}' unless defined(&FOLL_TOUCH);
	eval 'sub FOLL_GET () {0x4;}' unless defined(&FOLL_GET);
	eval 'sub FOLL_ANON () {0x8;}' unless defined(&FOLL_ANON);
	if(defined(&CONFIG_PROC_FS)) {
	} else {
	}
	unless(defined(&CONFIG_DEBUG_PAGEALLOC)) {
	}
	if(defined(&__HAVE_ARCH_GATE_AREA)) {
	} else {
	    eval 'sub in_gate_area {
	        local($task, $addr) = @_;
    		eval q(({$task;  &in_gate_area_no_task($addr);}));
	    }' unless defined(&in_gate_area);
	}
	eval 'sub OOM_DISABLE () {-17;}' unless defined(&OOM_DISABLE);
	unless(defined(&CONFIG_MMU)) {
	    eval 'sub randomize_va_space () {0;}' unless defined(&randomize_va_space);
	} else {
	}
    }
}
1;
