require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_X86_64_PAGE_H)) {
    eval 'sub _X86_64_PAGE_H () {1;}' unless defined(&_X86_64_PAGE_H);
    require 'linux/config.ph';
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    if(defined(&__ASSEMBLY__)) {
	eval 'sub PAGE_SIZE () {(0x1 <<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    } else {
	eval 'sub PAGE_SIZE () {(1 <<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    }
    eval 'sub PAGE_MASK () {(~( &PAGE_SIZE-1));}' unless defined(&PAGE_MASK);
    eval 'sub PHYSICAL_PAGE_MASK () {(~( &PAGE_SIZE-1) &  &__PHYSICAL_MASK);}' unless defined(&PHYSICAL_PAGE_MASK);
    eval 'sub THREAD_ORDER () {1;}' unless defined(&THREAD_ORDER);
    eval 'sub THREAD_SIZE () {( &PAGE_SIZE <<  &THREAD_ORDER);}' unless defined(&THREAD_SIZE);
    eval 'sub CURRENT_MASK () {(~( &THREAD_SIZE-1));}' unless defined(&CURRENT_MASK);
    eval 'sub EXCEPTION_STACK_ORDER () {0;}' unless defined(&EXCEPTION_STACK_ORDER);
    eval 'sub EXCEPTION_STKSZ () {( &PAGE_SIZE <<  &EXCEPTION_STACK_ORDER);}' unless defined(&EXCEPTION_STKSZ);
    eval 'sub DEBUG_STACK_ORDER () { &EXCEPTION_STACK_ORDER;}' unless defined(&DEBUG_STACK_ORDER);
    eval 'sub DEBUG_STKSZ () {( &PAGE_SIZE <<  &DEBUG_STACK_ORDER);}' unless defined(&DEBUG_STKSZ);
    eval 'sub IRQSTACK_ORDER () {2;}' unless defined(&IRQSTACK_ORDER);
    eval 'sub IRQSTACKSIZE () {( &PAGE_SIZE <<  &IRQSTACK_ORDER);}' unless defined(&IRQSTACKSIZE);
    eval 'sub STACKFAULT_STACK () {1;}' unless defined(&STACKFAULT_STACK);
    eval 'sub DOUBLEFAULT_STACK () {2;}' unless defined(&DOUBLEFAULT_STACK);
    eval 'sub NMI_STACK () {3;}' unless defined(&NMI_STACK);
    eval 'sub DEBUG_STACK () {4;}' unless defined(&DEBUG_STACK);
    eval 'sub MCE_STACK () {5;}' unless defined(&MCE_STACK);
    eval 'sub N_EXCEPTION_STACKS () {5;}' unless defined(&N_EXCEPTION_STACKS);
    eval 'sub LARGE_PAGE_MASK () {(~( &LARGE_PAGE_SIZE-1));}' unless defined(&LARGE_PAGE_MASK);
    eval 'sub LARGE_PAGE_SIZE () {(1 <<  &PMD_SHIFT);}' unless defined(&LARGE_PAGE_SIZE);
    eval 'sub HPAGE_SHIFT () { &PMD_SHIFT;}' unless defined(&HPAGE_SHIFT);
    eval 'sub HPAGE_SIZE () {((1) <<  &HPAGE_SHIFT);}' unless defined(&HPAGE_SIZE);
    eval 'sub HPAGE_MASK () {(~( &HPAGE_SIZE - 1));}' unless defined(&HPAGE_MASK);
    eval 'sub HUGETLB_PAGE_ORDER () {( &HPAGE_SHIFT -  &PAGE_SHIFT);}' unless defined(&HUGETLB_PAGE_ORDER);
    if(defined(&__KERNEL__)) {
	unless(defined(&__ASSEMBLY__)) {
	    eval 'sub clear_user_page {
	        local($page, $vaddr, $pg) = @_;
    		eval q( &clear_page($page));
	    }' unless defined(&clear_user_page);
	    eval 'sub copy_user_page {
	        local($to, $from, $vaddr, $pg) = @_;
    		eval q( &copy_page($to, $from));
	    }' unless defined(&copy_user_page);
	    eval 'sub alloc_zeroed_user_highpage {
	        local($vma, $vaddr) = @_;
    		eval q( &alloc_page_vma( &GFP_HIGHUSER |  &__GFP_ZERO, $vma, $vaddr));
	    }' unless defined(&alloc_zeroed_user_highpage);
	    eval 'sub __HAVE_ARCH_ALLOC_ZEROED_USER_HIGHPAGE () {1;}' unless defined(&__HAVE_ARCH_ALLOC_ZEROED_USER_HIGHPAGE);
	    eval 'sub PTE_MASK () { &PHYSICAL_PAGE_MASK;}' unless defined(&PTE_MASK);
	    eval 'sub pte_val {
	        local($x) = @_;
    		eval q((($x). &pte));
	    }' unless defined(&pte_val);
	    eval 'sub pmd_val {
	        local($x) = @_;
    		eval q((($x). &pmd));
	    }' unless defined(&pmd_val);
	    eval 'sub pud_val {
	        local($x) = @_;
    		eval q((($x). &pud));
	    }' unless defined(&pud_val);
	    eval 'sub pgd_val {
	        local($x) = @_;
    		eval q((($x). &pgd));
	    }' unless defined(&pgd_val);
	    eval 'sub pgprot_val {
	        local($x) = @_;
    		eval q((($x). &pgprot));
	    }' unless defined(&pgprot_val);
	    eval 'sub __pte {
	        local($x) = @_;
    		eval q((( &pte_t) { ($x) } ));
	    }' unless defined(&__pte);
	    eval 'sub __pmd {
	        local($x) = @_;
    		eval q((( &pmd_t) { ($x) } ));
	    }' unless defined(&__pmd);
	    eval 'sub __pud {
	        local($x) = @_;
    		eval q((( &pud_t) { ($x) } ));
	    }' unless defined(&__pud);
	    eval 'sub __pgd {
	        local($x) = @_;
    		eval q((( &pgd_t) { ($x) } ));
	    }' unless defined(&__pgd);
	    eval 'sub __pgprot {
	        local($x) = @_;
    		eval q((( &pgprot_t) { ($x) } ));
	    }' unless defined(&__pgprot);
	    eval 'sub __PHYSICAL_START () {( &CONFIG_PHYSICAL_START);}' unless defined(&__PHYSICAL_START);
	    eval 'sub __START_KERNEL () {( &__START_KERNEL_map +  &__PHYSICAL_START);}' unless defined(&__START_KERNEL);
	    eval 'sub __START_KERNEL_map () {1.84467440715621e+19;}' unless defined(&__START_KERNEL_map);
	    eval 'sub __PAGE_OFFSET () {1.84466044357328e+19;}' unless defined(&__PAGE_OFFSET);
	} else {
	    eval 'sub __PHYSICAL_START () { &CONFIG_PHYSICAL_START;}' unless defined(&__PHYSICAL_START);
	    eval 'sub __START_KERNEL () {( &__START_KERNEL_map +  &__PHYSICAL_START);}' unless defined(&__START_KERNEL);
	    eval 'sub __START_KERNEL_map () {1.84467440715621e+19;}' unless defined(&__START_KERNEL_map);
	    eval 'sub __PAGE_OFFSET () {1.84466044357328e+19;}' unless defined(&__PAGE_OFFSET);
	}
	eval 'sub PAGE_ALIGN {
	    local($addr) = @_;
    	    eval q(((($addr)+ &PAGE_SIZE-1) &PAGE_MASK));
	}' unless defined(&PAGE_ALIGN);
	eval 'sub __PHYSICAL_MASK_SHIFT () {46;}' unless defined(&__PHYSICAL_MASK_SHIFT);
	eval 'sub __PHYSICAL_MASK () {((1 <<  &__PHYSICAL_MASK_SHIFT) - 1);}' unless defined(&__PHYSICAL_MASK);
	eval 'sub __VIRTUAL_MASK_SHIFT () {48;}' unless defined(&__VIRTUAL_MASK_SHIFT);
	eval 'sub __VIRTUAL_MASK () {((1 <<  &__VIRTUAL_MASK_SHIFT) - 1);}' unless defined(&__VIRTUAL_MASK);
	eval 'sub KERNEL_TEXT_SIZE () {(40*1024*1024);}' unless defined(&KERNEL_TEXT_SIZE);
	eval 'sub KERNEL_TEXT_START () {1.84467440715621e+19;}' unless defined(&KERNEL_TEXT_START);
	unless(defined(&__ASSEMBLY__)) {
	    require 'asm/bug.ph';
	}
	eval 'sub PAGE_OFFSET () {( &__PAGE_OFFSET);}' unless defined(&PAGE_OFFSET);
	eval 'sub __pa {
	    local($x) = @_;
    	    eval q(((>= &__START_KERNEL_map)? -  &__START_KERNEL_map:($x) -  &PAGE_OFFSET));
	}' unless defined(&__pa);
	eval 'sub __pa_symbol {
	    local($x) = @_;
    	    eval q(({\'unsigned long v\';  &asm(\\"\\" : \\"=r\\" ( &v) : \\"0\\" ($x));  &__pa( &v); }));
	}' unless defined(&__pa_symbol);
	eval 'sub __va {
	    local($x) = @_;
    	    eval q(((($x)+ &PAGE_OFFSET)));
	}' unless defined(&__va);
	eval 'sub __boot_va {
	    local($x) = @_;
    	    eval q( &__va($x));
	}' unless defined(&__boot_va);
	eval 'sub __boot_pa {
	    local($x) = @_;
    	    eval q( &__pa($x));
	}' unless defined(&__boot_pa);
	if(defined(&CONFIG_FLATMEM)) {
	    eval 'sub pfn_to_page {
	        local($pfn) = @_;
    		eval q(( &mem_map + ($pfn)));
	    }' unless defined(&pfn_to_page);
	    eval 'sub page_to_pfn {
	        local($page) = @_;
    		eval q(((($page) -  &mem_map)));
	    }' unless defined(&page_to_pfn);
	    eval 'sub pfn_valid {
	        local($pfn) = @_;
    		eval q((($pfn) <  &end_pfn));
	    }' unless defined(&pfn_valid);
	}
	eval 'sub virt_to_page {
	    local($kaddr) = @_;
    	    eval q( &pfn_to_page( &__pa($kaddr) >>  &PAGE_SHIFT));
	}' unless defined(&virt_to_page);
	eval 'sub virt_addr_valid {
	    local($kaddr) = @_;
    	    eval q( &pfn_valid( &__pa($kaddr) >>  &PAGE_SHIFT));
	}' unless defined(&virt_addr_valid);
	eval 'sub pfn_to_kaddr {
	    local($pfn) = @_;
    	    eval q( &__va(($pfn) <<  &PAGE_SHIFT));
	}' unless defined(&pfn_to_kaddr);
	eval 'sub VM_DATA_DEFAULT_FLAGS () {((( ($current->{personality}) &  &READ_IMPLIES_EXEC) ?  &VM_EXEC : 0) |  &VM_READ |  &VM_WRITE |  &VM_MAYREAD |  &VM_MAYWRITE |  &VM_MAYEXEC);}' unless defined(&VM_DATA_DEFAULT_FLAGS);
	eval 'sub __HAVE_ARCH_GATE_AREA () {1;}' unless defined(&__HAVE_ARCH_GATE_AREA);
    }
    require 'asm-generic/page.ph';
}
1;
