require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_SYSTEM_H)) {
    eval 'sub __ASM_SYSTEM_H () {1;}' unless defined(&__ASM_SYSTEM_H);
    require 'linux/config.ph';
    require 'linux/kernel.ph';
    require 'asm/segment.ph';
    require 'asm/cpufeature.ph';
    require 'linux/bitops.ph';
    if(defined(&__KERNEL__)) {
	eval 'sub switch_to {
	    local($prev,$next,$last) = @_;
    	    eval q( &do { \'unsigned long esi\', &edi;  &asm  &volatile(\\"pushl %%ebp\\\\n\\\\t\\" \\"movl %%esp,%0\\\\n\\\\t\\" \\"movl %5,%%esp\\\\n\\\\t\\" \\"movl $1f,%1\\\\n\\\\t\\" \\"pushl %6\\\\n\\\\t\\" \\"jmp __switch_to\\\\n\\" \\"1:\\\\t\\" \\"popl %%ebp\\\\n\\\\t\\" :\\"=m\\" ( ($prev->{thread}->{esp})),\\"=m\\" ( ($prev->{thread}->{eip})), \\"=a\\" ($last),\\"=S\\" ( &esi),\\"=D\\" ( &edi) :\\"m\\" ( ($next->{thread}->{esp})),\\"m\\" ( ($next->{thread}->{eip})), \\"2\\" ($prev), \\"d\\" ($next)); }  &while (0));
	}' unless defined(&switch_to);
	eval 'sub _set_base {
	    local($addr,$base) = @_;
    	    eval q( &do { \'unsigned long __pr\';  &__asm__  &__volatile__ (\\"movw %%dx,%1\\\\n\\\\t\\" \\"rorl $16,%%edx\\\\n\\\\t\\" \\"movb %%dl,%2\\\\n\\\\t\\" \\"movb %%dh,%3\\" :\\"=&d\\" ( &__pr) :\\"m\\" (*(($addr)+2)), \\"m\\" (*(($addr)+4)), \\"m\\" (*(($addr)+7)), \\"0\\" ($base) ); }  &while(0));
	}' unless defined(&_set_base);
	eval 'sub _set_limit {
	    local($addr,$limit) = @_;
    	    eval q( &do { \'unsigned long __lr\';  &__asm__  &__volatile__ (\\"movw %%dx,%1\\\\n\\\\t\\" \\"rorl $16,%%edx\\\\n\\\\t\\" \\"movb %2,%%dh\\\\n\\\\t\\" \\"andb $0xf0,%%dh\\\\n\\\\t\\" \\"orb %%dh,%%dl\\\\n\\\\t\\" \\"movb %%dl,%2\\" :\\"=&d\\" ( &__lr) :\\"m\\" (*($addr)), \\"m\\" (*(($addr)+6)), \\"0\\" ($limit) ); }  &while(0));
	}' unless defined(&_set_limit);
	eval 'sub set_base {
	    local($ldt,$base) = @_;
    	    eval q( &_set_base( (($ldt)) , ($base) ));
	}' unless defined(&set_base);
	eval 'sub set_limit {
	    local($ldt,$limit) = @_;
    	    eval q( &_set_limit( (($ldt)) , (($limit)-1) ));
	}' unless defined(&set_limit);
	eval 'sub loadsegment {
	    local($seg,$value) = @_;
    	    eval q( &asm  &volatile(\\"\\\\n\\" \\"1:\\\\t\\" \\"mov %0,%%\\" $seg \\"\\\\n\\" \\"2:\\\\n\\" \\".section .fixup,\\\\\\"ax\\\\\\"\\\\n\\" \\"3:\\\\t\\" \\"pushl $0\\\\n\\\\t\\" \\"popl %%\\" $seg \\"\\\\n\\\\t\\" \\"jmp 2b\\\\n\\" \\".previous\\\\n\\" \\".section __ex_table,\\\\\\"a\\\\\\"\\\\n\\\\t\\" \\".align 4\\\\n\\\\t\\" \\".long 1b,3b\\\\n\\" \\".previous\\" : :\\"rm\\" ($value)));
	}' unless defined(&loadsegment);
	eval 'sub savesegment {
	    local($seg, $value) = @_;
    	    eval q( &asm  &volatile(\\"mov %%\\" $seg \\",%0\\":\\"=rm\\" ($value)));
	}' unless defined(&savesegment);
	eval 'sub clts () {
	    eval q( &__asm__  &__volatile__ (\\"clts\\"));
	}' unless defined(&clts);
	eval 'sub read_cr0 () {
	    eval q(({ \'unsigned int __dummy\';  &__asm__  &__volatile__( \\"movl %%cr0,%0\\\\n\\\\t\\" :\\"=r\\" ( &__dummy));  &__dummy; }));
	}' unless defined(&read_cr0);
	eval 'sub write_cr0 {
	    local($x) = @_;
    	    eval q( &__asm__  &__volatile__(\\"movl %0,%%cr0\\": :\\"r\\" ($x)););
	}' unless defined(&write_cr0);
	eval 'sub read_cr2 () {
	    eval q(({ \'unsigned int __dummy\';  &__asm__  &__volatile__( \\"movl %%cr2,%0\\\\n\\\\t\\" :\\"=r\\" ( &__dummy));  &__dummy; }));
	}' unless defined(&read_cr2);
	eval 'sub write_cr2 {
	    local($x) = @_;
    	    eval q( &__asm__  &__volatile__(\\"movl %0,%%cr2\\": :\\"r\\" ($x)););
	}' unless defined(&write_cr2);
	eval 'sub read_cr3 () {
	    eval q(({ \'unsigned int __dummy\';  &__asm__ ( \\"movl %%cr3,%0\\\\n\\\\t\\" :\\"=r\\" ( &__dummy));  &__dummy; }));
	}' unless defined(&read_cr3);
	eval 'sub write_cr3 {
	    local($x) = @_;
    	    eval q( &__asm__  &__volatile__(\\"movl %0,%%cr3\\": :\\"r\\" ($x)););
	}' unless defined(&write_cr3);
	eval 'sub read_cr4 () {
	    eval q(({ \'unsigned int __dummy\';  &__asm__( \\"movl %%cr4,%0\\\\n\\\\t\\" :\\"=r\\" ( &__dummy));  &__dummy; }));
	}' unless defined(&read_cr4);
	eval 'sub read_cr4_safe () {
	    eval q(({ \'unsigned int __dummy\';  &__asm__(\\"1: movl %%cr4, %0		\\\\n\\" \\"2:				\\\\n\\" \\".section __ex_table,\\\\\\"a\\\\\\"	\\\\n\\" \\".long 1b,2b			\\\\n\\" \\".previous			\\\\n\\" : \\"=r\\" ( &__dummy): \\"0\\" (0));  &__dummy; }));
	}' unless defined(&read_cr4_safe);
	eval 'sub write_cr4 {
	    local($x) = @_;
    	    eval q( &__asm__  &__volatile__(\\"movl %0,%%cr4\\": :\\"r\\" ($x)););
	}' unless defined(&write_cr4);
	eval 'sub stts () {
	    eval q( &write_cr0(8|  &read_cr0()));
	}' unless defined(&stts);
    }
    eval 'sub wbinvd () {
        eval q( &__asm__  &__volatile__ (\\"wbinvd\\": : :\\"memory\\"););
    }' unless defined(&wbinvd);
    eval 'sub nop () {
        eval q( &__asm__  &__volatile__ (\\"nop\\"));
    }' unless defined(&nop);
    eval 'sub xchg {
        local($ptr,$v) = @_;
	    eval q((( &__typeof__(*)) &__xchg(($v),($ptr),$sizeof{($ptr)})));
    }' unless defined(&xchg);
    eval 'sub tas {
        local($ptr) = @_;
	    eval q(( &xchg(($ptr),1)));
    }' unless defined(&tas);
    eval 'sub __xg {
        local($x) = @_;
	    eval q((($x)));
    }' unless defined(&__xg);
    if(defined(&CONFIG_X86_CMPXCHG64)) {
	eval 'sub ll_low {
	    local($x) = @_;
    	    eval q(*((($x))+0));
	}' unless defined(&ll_low);
	eval 'sub ll_high {
	    local($x) = @_;
    	    eval q(*((($x))+1));
	}' unless defined(&ll_high);
	eval 'sub set_64bit {
	    local($ptr,$value) = @_;
    	    eval q(( &__builtin_constant_p($value) ?  &__set_64bit_constant($ptr, $value) :  &__set_64bit_var($ptr, $value) ));
	}' unless defined(&set_64bit);
	eval 'sub _set_64bit {
	    local($ptr,$value) = @_;
    	    eval q(( &__builtin_constant_p ?  &__set_64bit($ptr, , (($value)>>32) ) :  &__set_64bit($ptr,  &ll_low($value),  &ll_high($value)) ));
	}' unless defined(&_set_64bit);
    }
    if(defined(&CONFIG_X86_CMPXCHG)) {
	eval 'sub __HAVE_ARCH_CMPXCHG () {1;}' unless defined(&__HAVE_ARCH_CMPXCHG);
	eval 'sub cmpxchg {
	    local($ptr,$o,$n) = @_;
    	    eval q((( &__typeof__(*)) &__cmpxchg(,, ($n),$sizeof{($ptr)})));
	}' unless defined(&cmpxchg);
    }
    unless(defined(&CONFIG_X86_CMPXCHG)) {
	eval 'sub cmpxchg {
	    local($ptr,$o,$n) = @_;
    	    eval q(({  &__typeof__(*)  &__ret;  &if ( &likely( ($b$oot_cpu_data->{x86}) > 3))  &__ret =  &__cmpxchg(, , , $sizeof{});  &else  &__ret =  &cmpxchg_386(, , ($n), $sizeof{($ptr)});  &__ret; }));
	}' unless defined(&cmpxchg);
    }
    if(defined(&CONFIG_X86_CMPXCHG64)) {
	eval 'sub cmpxchg64 {
	    local($ptr,$o,$n) = @_;
    	    eval q((( &__typeof__(*)) &__cmpxchg64(,, ($n))));
	}' unless defined(&cmpxchg64);
    }
    if(defined(&__KERNEL__)) {
    }
    eval 'sub alternative {
        local($oldinstr, $newinstr, $feature) = @_;
	    eval q( &asm  &volatile (\\"661:\\\\n\\\\t\\" $oldinstr \\"\\\\n662:\\\\n\\" \\".section .altinstructions,\\\\\\"a\\\\\\"\\\\n\\" \\"  .align 4\\\\n\\" \\"  .long 661b\\\\n\\" \\"  .long 663f\\\\n\\" \\"  .byte %c0\\\\n\\" \\"  .byte 662b-661b\\\\n\\" \\"  .byte 664f-663f\\\\n\\" \\".previous\\\\n\\" \\".section .altinstr_replacement,\\\\\\"ax\\\\\\"\\\\n\\" \\"663:\\\\n\\\\t\\" $newinstr \\"\\\\n664:\\\\n\\" \\".previous\\" :: \\"i\\" ($feature) : \\"memory\\"));
    }' unless defined(&alternative);
    eval 'sub alternative_input () {( &oldinstr,  &newinstr,  &feature,  &input...)  &asm  &volatile ("661:\\n\\t"  &oldinstr "\\n662:\\n" ".section .altinstructions,\\"a\\"\\n" "  .align 4\\n" "  .long 661b\\n" "  .long 663f\\n" "  .byte %c0\\n" "  .byte 662b-661b\\n" "  .byte 664f-663f\\n" ".previous\\n" ".section .altinstr_replacement,\\"ax\\"\\n" "663:\\n\\t"  &newinstr "\\n664:\\n" ".previous" :: "i" ( &feature),  &input);}' unless defined(&alternative_input);
    eval 'sub mb () {
        eval q( &alternative(\\"lock; addl $0,0(%%esp)\\", \\"mfence\\",  &X86_FEATURE_XMM2));
    }' unless defined(&mb);
    eval 'sub rmb () {
        eval q( &alternative(\\"lock; addl $0,0(%%esp)\\", \\"lfence\\",  &X86_FEATURE_XMM2));
    }' unless defined(&rmb);
    eval 'sub read_barrier_depends () {
        eval q( &do { }  &while(0));
    }' unless defined(&read_barrier_depends);
    if(defined(&CONFIG_X86_OOSTORE)) {
	eval 'sub wmb () {
	    eval q( &alternative(\\"lock; addl $0,0(%%esp)\\", \\"sfence\\",  &X86_FEATURE_XMM));
	}' unless defined(&wmb);
    } else {
	eval 'sub wmb () {
	    eval q( &__asm__  &__volatile__ (\\"\\": : :\\"memory\\"));
	}' unless defined(&wmb);
    }
    if(defined(&CONFIG_SMP)) {
	eval 'sub smp_mb () {
	    eval q( &mb());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &rmb());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &wmb());
	}' unless defined(&smp_wmb);
	eval 'sub smp_read_barrier_depends () {
	    eval q( &read_barrier_depends());
	}' unless defined(&smp_read_barrier_depends);
	eval 'sub set_mb {
	    local($var, $value) = @_;
    	    eval q( &do {  &xchg($var, $value); }  &while (0));
	}' unless defined(&set_mb);
    } else {
	eval 'sub smp_mb () {
	    eval q( &barrier());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &barrier());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &barrier());
	}' unless defined(&smp_wmb);
	eval 'sub smp_read_barrier_depends () {
	    eval q( &do { }  &while(0));
	}' unless defined(&smp_read_barrier_depends);
	eval 'sub set_mb {
	    local($var, $value) = @_;
    	    eval q( &do { $var = $value;  &barrier(); }  &while (0));
	}' unless defined(&set_mb);
    }
    eval 'sub set_wmb {
        local($var, $value) = @_;
	    eval q( &do { $var = $value;  &wmb(); }  &while (0));
    }' unless defined(&set_wmb);
    eval 'sub local_save_flags {
        local($x) = @_;
	    eval q( &do {  &typecheck(\'unsigned long\',$x);  &__asm__  &__volatile__(\\"pushfl ; popl %0\\":\\"=g\\" ($x): ); }  &while (0));
    }' unless defined(&local_save_flags);
    eval 'sub local_irq_restore {
        local($x) = @_;
	    eval q( &do {  &typecheck(\'unsigned long\',$x);  &__asm__  &__volatile__(\\"pushl %0 ; popfl\\": :\\"g\\" ($x):\\"memory\\", \\"cc\\"); }  &while (0));
    }' unless defined(&local_irq_restore);
    eval 'sub local_irq_disable () {
        eval q( &__asm__  &__volatile__(\\"cli\\": : :\\"memory\\"));
    }' unless defined(&local_irq_disable);
    eval 'sub local_irq_enable () {
        eval q( &__asm__  &__volatile__(\\"sti\\": : :\\"memory\\"));
    }' unless defined(&local_irq_enable);
    eval 'sub safe_halt () {
        eval q( &__asm__  &__volatile__(\\"sti; hlt\\": : :\\"memory\\"));
    }' unless defined(&safe_halt);
    eval 'sub halt () {
        eval q( &__asm__  &__volatile__(\\"hlt\\": : :\\"memory\\"));
    }' unless defined(&halt);
    eval 'sub irqs_disabled () {
        eval q(({ \'unsigned long flags\';  &local_save_flags( &flags); !( &flags & (1<<9)); }));
    }' unless defined(&irqs_disabled);
    eval 'sub local_irq_save {
        local($x) = @_;
	    eval q( &__asm__  &__volatile__(\\"pushfl ; popl %0 ; cli\\":\\"=g\\" ($x): :\\"memory\\"));
    }' unless defined(&local_irq_save);
    eval 'sub HAVE_DISABLE_HLT () {1;}' unless defined(&HAVE_DISABLE_HLT);
}
1;
