require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_IO_H)) {
    eval 'sub _ASM_IO_H () {1;}' unless defined(&_ASM_IO_H);
    require 'linux/config.ph';
    require 'linux/string.ph';
    require 'linux/compiler.ph';
    eval 'sub IO_SPACE_LIMIT () {0xffff;}' unless defined(&IO_SPACE_LIMIT);
    eval 'sub XQUAD_PORTIO_BASE () {0xfe400000;}' unless defined(&XQUAD_PORTIO_BASE);
    eval 'sub XQUAD_PORTIO_QUAD () {0x40000;}' unless defined(&XQUAD_PORTIO_QUAD);
    if(defined(&__KERNEL__)) {
	require 'asm-generic/iomap.ph';
	require 'linux/vmalloc.ph';
	eval 'sub xlate_dev_mem_ptr {
	    local($p) = @_;
    	    eval q( &__va($p));
	}' unless defined(&xlate_dev_mem_ptr);
	eval 'sub xlate_dev_kmem_ptr {
	    local($p) = @_;
    	    eval q($p);
	}' unless defined(&xlate_dev_kmem_ptr);
	eval 'sub page_to_phys {
	    local($page) = @_;
    	    eval q(( &page_to_pfn($page) <<  &PAGE_SHIFT));
	}' unless defined(&page_to_phys);
	eval 'sub dmi_ioremap () { &bt_ioremap;}' unless defined(&dmi_ioremap);
	eval 'sub dmi_iounmap () { &bt_iounmap;}' unless defined(&dmi_iounmap);
	eval 'sub dmi_alloc () { &alloc_bootmem;}' unless defined(&dmi_alloc);
	eval 'sub isa_virt_to_bus () { &virt_to_phys;}' unless defined(&isa_virt_to_bus);
	eval 'sub isa_page_to_bus () { &page_to_phys;}' unless defined(&isa_page_to_bus);
	eval 'sub isa_bus_to_virt () { &phys_to_virt;}' unless defined(&isa_bus_to_virt);
	eval 'sub virt_to_bus () { &virt_to_phys;}' unless defined(&virt_to_bus);
	eval 'sub bus_to_virt () { &phys_to_virt;}' unless defined(&bus_to_virt);
	eval 'sub readb_relaxed {
	    local($addr) = @_;
    	    eval q( &readb($addr));
	}' unless defined(&readb_relaxed);
	eval 'sub readw_relaxed {
	    local($addr) = @_;
    	    eval q( &readw($addr));
	}' unless defined(&readw_relaxed);
	eval 'sub readl_relaxed {
	    local($addr) = @_;
    	    eval q( &readl($addr));
	}' unless defined(&readl_relaxed);
	eval 'sub __raw_readb () { &readb;}' unless defined(&__raw_readb);
	eval 'sub __raw_readw () { &readw;}' unless defined(&__raw_readw);
	eval 'sub __raw_readl () { &readl;}' unless defined(&__raw_readl);
	eval 'sub __raw_writeb () { &writeb;}' unless defined(&__raw_writeb);
	eval 'sub __raw_writew () { &writew;}' unless defined(&__raw_writew);
	eval 'sub __raw_writel () { &writel;}' unless defined(&__raw_writel);
	eval 'sub mmiowb () {
	    eval q();
	}' unless defined(&mmiowb);
	eval 'sub __ISA_IO_base () {(( &PAGE_OFFSET));}' unless defined(&__ISA_IO_base);
	eval 'sub isa_readb {
	    local($a) = @_;
    	    eval q( &readb( &__ISA_IO_base + ($a)));
	}' unless defined(&isa_readb);
	eval 'sub isa_readw {
	    local($a) = @_;
    	    eval q( &readw( &__ISA_IO_base + ($a)));
	}' unless defined(&isa_readw);
	eval 'sub isa_readl {
	    local($a) = @_;
    	    eval q( &readl( &__ISA_IO_base + ($a)));
	}' unless defined(&isa_readl);
	eval 'sub isa_writeb {
	    local($b,$a) = @_;
    	    eval q( &writeb($b, &__ISA_IO_base + ($a)));
	}' unless defined(&isa_writeb);
	eval 'sub isa_writew {
	    local($w,$a) = @_;
    	    eval q( &writew($w, &__ISA_IO_base + ($a)));
	}' unless defined(&isa_writew);
	eval 'sub isa_writel {
	    local($l,$a) = @_;
    	    eval q( &writel($l, &__ISA_IO_base + ($a)));
	}' unless defined(&isa_writel);
	eval 'sub isa_memset_io {
	    local($a,$b,$c) = @_;
    	    eval q( &memset_io( &__ISA_IO_base + ($a),($b),($c)));
	}' unless defined(&isa_memset_io);
	eval 'sub isa_memcpy_fromio {
	    local($a,$b,$c) = @_;
    	    eval q( &memcpy_fromio(($a), &__ISA_IO_base + ($b),($c)));
	}' unless defined(&isa_memcpy_fromio);
	eval 'sub isa_memcpy_toio {
	    local($a,$b,$c) = @_;
    	    eval q( &memcpy_toio( &__ISA_IO_base + ($a),($b),($c)));
	}' unless defined(&isa_memcpy_toio);
	eval 'sub eth_io_copy_and_sum {
	    local($a,$b,$c,$d) = @_;
    	    eval q( &eth_copy_and_sum(,($b),($c),($d)));
	}' unless defined(&eth_io_copy_and_sum);
	eval 'sub isa_eth_io_copy_and_sum {
	    local($a,$b,$c,$d) = @_;
    	    eval q( &eth_copy_and_sum(,( &__ISA_IO_base + ($b)),($c),($d)));
	}' unless defined(&isa_eth_io_copy_and_sum);
	if(defined( &CONFIG_X86_OOSTORE) || defined( &CONFIG_X86_PPRO_FENCE)) {
	    eval 'sub dma_cache_inv {
	        local($_start,$_size) = @_;
    		eval q( &flush_write_buffers());
	    }' unless defined(&dma_cache_inv);
	    eval 'sub dma_cache_wback {
	        local($_start,$_size) = @_;
    		eval q( &flush_write_buffers());
	    }' unless defined(&dma_cache_wback);
	    eval 'sub dma_cache_wback_inv {
	        local($_start,$_size) = @_;
    		eval q( &flush_write_buffers());
	    }' unless defined(&dma_cache_wback_inv);
	} else {
	    eval 'sub dma_cache_inv {
	        local($_start,$_size) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_cache_inv);
	    eval 'sub dma_cache_wback {
	        local($_start,$_size) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_cache_wback);
	    eval 'sub dma_cache_wback_inv {
	        local($_start,$_size) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_cache_wback_inv);
	    eval 'sub flush_write_buffers () {
	        eval q();
	    }' unless defined(&flush_write_buffers);
	}
    }
    if(defined(&SLOW_IO_BY_JUMPING)) {
	eval 'sub __SLOW_DOWN_IO () {"jmp 1f; 1: jmp 1f; 1:";}' unless defined(&__SLOW_DOWN_IO);
    } else {
	eval 'sub __SLOW_DOWN_IO () {"outb %%al,$0x80;";}' unless defined(&__SLOW_DOWN_IO);
    }
    if(defined(&REALLY_SLOW_IO)) {
    }
    if(defined(&CONFIG_X86_NUMAQ)) {
	eval 'sub XQUAD_PORT_ADDR {
	    local($port, $quad) = @_;
    	    eval q(( &xquad_portio + ( &XQUAD_PORTIO_QUAD*$quad) + $port));
	}' unless defined(&XQUAD_PORT_ADDR);
	eval 'sub __BUILDIO {
	    local($bwl,$bw,$type) = @_;
    	    eval q( &static  &inline  &void  &out$bwl &_quad(\'unsigned type value\', \'int\'  &port, \'int\'  &quad) {  &if  &write$bwl( &value,  &XQUAD_PORT_ADDR( &port,  &quad));  &else  &out$bwl &_local( &value,  &port); }  &static  &inline  &void  &out$bwl(\'unsigned type value\', \'int\'  &port) {  &out$bwl &_quad( &value,  &port, 0); }  &static  &inline \'unsigned type in\'$bwl &_quad(\'int\'  &port, \'int\'  &quad) {  &if  &return  &read$bwl( &XQUAD_PORT_ADDR( &port,  &quad));  &else  &return  &in$bwl &_local( &port); }  &static  &inline \'unsigned type in\'$bwl(\'int\'  &port) {  &return  &in$bwl &_quad( &port, 0); });
	}' unless defined(&__BUILDIO);
    } else {
	eval 'sub __BUILDIO {
	    local($bwl,$bw,$type) = @_;
    	    eval q( &static  &inline  &void  &out$bwl(\'unsigned type value\', \'int\'  &port) {  &out$bwl &_local( &value,  &port); }  &static  &inline \'unsigned type in\'$bwl(\'int\'  &port) {  &return  &in$bwl &_local( &port); });
	}' unless defined(&__BUILDIO);
    }
    eval 'sub BUILDIO {
        local($bwl,$bw,$type) = @_;
	    eval q( &static  &inline  &void  &out$bwl &_local(\'unsigned type value\', \'int\'  &port) {  &__asm__  &__volatile__(\\"out\\" $bwl \\" %\\" $bw \\"0, %w1\\" : : \\"a\\"( &value), \\"Nd\\"( &port)); }  &static  &inline \'unsigned type in\'$bwl &_local(\'int\'  &port) { \'unsigned type value\';  &__asm__  &__volatile__(\\"in\\" $bwl \\" %w1, %\\" $bw \\"0\\" : \\"=a\\"( &value) : \\"Nd\\"( &port));  &return  &value; }  &static  &inline  &void  &out$bwl &_local_p(\'unsigned type value\', \'int\'  &port) {  &out$bwl &_local( &value,  &port);  &slow_down_io(); }  &static  &inline \'unsigned type in\'$bwl &_local_p(\'int\'  &port) { \'unsigned type value\' =  &in$bwl &_local( &port);  &slow_down_io();  &return  &value; }  &__BUILDIO($bwl,$bw,$type)  &static  &inline  &void  &out$bwl &_p(\'unsigned type value\', \'int\'  &port) {  &out$bwl( &value,  &port);  &slow_down_io(); }  &static  &inline \'unsigned type in\'$bwl &_p(\'int\'  &port) { \'unsigned type value\' =  &in$bwl( &port);  &slow_down_io();  &return  &value; }  &static  &inline  &void  &outs$bwl(\'int\'  &port,  &const  &void * &addr, \'unsigned long count\') {  &__asm__  &__volatile__(\\"rep; outs\\" $bwl : \\"+S\\"( &addr), \\"+c\\"( &count) : \\"d\\"( &port)); }  &static  &inline  &void  &ins$bwl(\'int\'  &port,  &void * &addr, \'unsigned long count\') {  &__asm__  &__volatile__(\\"rep; ins\\" $bwl : \\"+D\\"( &addr), \\"+c\\"( &count) : \\"d\\"( &port)); });
    }' unless defined(&BUILDIO);
}
1;
