require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&PAGE_FLAGS_H)) {
    eval 'sub PAGE_FLAGS_H () {1;}' unless defined(&PAGE_FLAGS_H);
    require 'linux/percpu.ph';
    require 'linux/cache.ph';
    require 'asm/pgtable.ph';
    eval 'sub PG_locked () {0;}' unless defined(&PG_locked);
    eval 'sub PG_error () {1;}' unless defined(&PG_error);
    eval 'sub PG_referenced () {2;}' unless defined(&PG_referenced);
    eval 'sub PG_uptodate () {3;}' unless defined(&PG_uptodate);
    eval 'sub PG_dirty () {4;}' unless defined(&PG_dirty);
    eval 'sub PG_lru () {5;}' unless defined(&PG_lru);
    eval 'sub PG_active () {6;}' unless defined(&PG_active);
    eval 'sub PG_slab () {7;}' unless defined(&PG_slab);
    eval 'sub PG_checked () {8;}' unless defined(&PG_checked);
    eval 'sub PG_arch_1 () {9;}' unless defined(&PG_arch_1);
    eval 'sub PG_reserved () {10;}' unless defined(&PG_reserved);
    eval 'sub PG_private () {11;}' unless defined(&PG_private);
    eval 'sub PG_writeback () {12;}' unless defined(&PG_writeback);
    eval 'sub PG_nosave () {13;}' unless defined(&PG_nosave);
    eval 'sub PG_compound () {14;}' unless defined(&PG_compound);
    eval 'sub PG_swapcache () {15;}' unless defined(&PG_swapcache);
    eval 'sub PG_mappedtodisk () {16;}' unless defined(&PG_mappedtodisk);
    eval 'sub PG_reclaim () {17;}' unless defined(&PG_reclaim);
    eval 'sub PG_nosave_free () {18;}' unless defined(&PG_nosave_free);
    eval 'sub PG_uncached () {19;}' unless defined(&PG_uncached);
    eval 'sub GET_PAGE_STATE_LAST () { &nr_slab;}' unless defined(&GET_PAGE_STATE_LAST);
    eval 'sub read_page_state {
        local($member) = @_;
	    eval q( &read_page_state_offset( &offsetof(1;
    }' unless defined(&read_page_state);
    eval 'sub mod_page_state {
        local($member, $delta) = @_;
	    eval q( &mod_page_state_offset( &offsetof(1;
    }' unless defined(&mod_page_state);
    eval 'sub __mod_page_state {
        local($member, $delta) = @_;
	    eval q( &__mod_page_state_offset( &offsetof(1;
    }' unless defined(&__mod_page_state);
    eval 'sub inc_page_state {
        local($member) = @_;
	    eval q( &mod_page_state($member, 1));
    }' unless defined(&inc_page_state);
    eval 'sub dec_page_state {
        local($member) = @_;
	    eval q( &mod_page_state($member, 0 - 1));
    }' unless defined(&dec_page_state);
    eval 'sub add_page_state {
        local($member,$delta) = @_;
	    eval q( &mod_page_state($member, ($delta)));
    }' unless defined(&add_page_state);
    eval 'sub sub_page_state {
        local($member,$delta) = @_;
	    eval q( &mod_page_state($member, 0 - ($delta)));
    }' unless defined(&sub_page_state);
    eval 'sub __inc_page_state {
        local($member) = @_;
	    eval q( &__mod_page_state($member, 1));
    }' unless defined(&__inc_page_state);
    eval 'sub __dec_page_state {
        local($member) = @_;
	    eval q( &__mod_page_state($member, 0 - 1));
    }' unless defined(&__dec_page_state);
    eval 'sub __add_page_state {
        local($member,$delta) = @_;
	    eval q( &__mod_page_state($member, ($delta)));
    }' unless defined(&__add_page_state);
    eval 'sub __sub_page_state {
        local($member,$delta) = @_;
	    eval q( &__mod_page_state($member, 0 - ($delta)));
    }' unless defined(&__sub_page_state);
    eval 'sub page_state {
        local($member) = @_;
	    eval q((* &__page_state( &offsetof(1;
    }' unless defined(&page_state);
    eval 'sub state_zone_offset {
        local($zone, $member) = @_;
	    eval q(({ \'unsigned offset\';  &if ( &is_highmem($zone))  &offset =  &offsetof(1;  &else  &if ( &is_normal($zone))  &offset =  &offsetof(1;  &else  &if ( &is_dma32($zone))  &offset =  &offsetof(1;  &else  &offset =  &offsetof(1;  &offset; }));
    }' unless defined(&state_zone_offset);
    eval 'sub __mod_page_state_zone {
        local($zone, $member, $delta) = @_;
	    eval q( &do {  &__mod_page_state_offset( &state_zone_offset($zone, $member), ($delta)); }  &while (0));
    }' unless defined(&__mod_page_state_zone);
    eval 'sub mod_page_state_zone {
        local($zone, $member, $delta) = @_;
	    eval q( &do {  &mod_page_state_offset( &state_zone_offset($zone, $member), ($delta)); }  &while (0));
    }' unless defined(&mod_page_state_zone);
    eval 'sub PageLocked {
        local($page) = @_;
	    eval q( &test_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&PageLocked);
    eval 'sub SetPageLocked {
        local($page) = @_;
	    eval q( &set_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&SetPageLocked);
    eval 'sub TestSetPageLocked {
        local($page) = @_;
	    eval q( &test_and_set_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&TestSetPageLocked);
    eval 'sub ClearPageLocked {
        local($page) = @_;
	    eval q( &clear_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&ClearPageLocked);
    eval 'sub TestClearPageLocked {
        local($page) = @_;
	    eval q( &test_and_clear_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&TestClearPageLocked);
    eval 'sub PageError {
        local($page) = @_;
	    eval q( &test_bit( &PG_error, ($page)-> &flags));
    }' unless defined(&PageError);
    eval 'sub SetPageError {
        local($page) = @_;
	    eval q( &set_bit( &PG_error, ($page)-> &flags));
    }' unless defined(&SetPageError);
    eval 'sub ClearPageError {
        local($page) = @_;
	    eval q( &clear_bit( &PG_error, ($page)-> &flags));
    }' unless defined(&ClearPageError);
    eval 'sub PageReferenced {
        local($page) = @_;
	    eval q( &test_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&PageReferenced);
    eval 'sub SetPageReferenced {
        local($page) = @_;
	    eval q( &set_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&SetPageReferenced);
    eval 'sub ClearPageReferenced {
        local($page) = @_;
	    eval q( &clear_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&ClearPageReferenced);
    eval 'sub TestClearPageReferenced {
        local($page) = @_;
	    eval q( &test_and_clear_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&TestClearPageReferenced);
    eval 'sub PageUptodate {
        local($page) = @_;
	    eval q( &test_bit( &PG_uptodate, ($page)-> &flags));
    }' unless defined(&PageUptodate);
    unless(defined(&SetPageUptodate)) {
	eval 'sub SetPageUptodate {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_uptodate, ($page)-> &flags));
	}' unless defined(&SetPageUptodate);
    }
    eval 'sub ClearPageUptodate {
        local($page) = @_;
	    eval q( &clear_bit( &PG_uptodate, ($page)-> &flags));
    }' unless defined(&ClearPageUptodate);
    eval 'sub PageDirty {
        local($page) = @_;
	    eval q( &test_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&PageDirty);
    eval 'sub SetPageDirty {
        local($page) = @_;
	    eval q( &set_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&SetPageDirty);
    eval 'sub TestSetPageDirty {
        local($page) = @_;
	    eval q( &test_and_set_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&TestSetPageDirty);
    eval 'sub ClearPageDirty {
        local($page) = @_;
	    eval q( &clear_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&ClearPageDirty);
    eval 'sub __ClearPageDirty {
        local($page) = @_;
	    eval q( &__clear_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&__ClearPageDirty);
    eval 'sub TestClearPageDirty {
        local($page) = @_;
	    eval q( &test_and_clear_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&TestClearPageDirty);
    eval 'sub SetPageLRU {
        local($page) = @_;
	    eval q( &set_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&SetPageLRU);
    eval 'sub PageLRU {
        local($page) = @_;
	    eval q( &test_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&PageLRU);
    eval 'sub TestSetPageLRU {
        local($page) = @_;
	    eval q( &test_and_set_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&TestSetPageLRU);
    eval 'sub TestClearPageLRU {
        local($page) = @_;
	    eval q( &test_and_clear_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&TestClearPageLRU);
    eval 'sub PageActive {
        local($page) = @_;
	    eval q( &test_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&PageActive);
    eval 'sub SetPageActive {
        local($page) = @_;
	    eval q( &set_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&SetPageActive);
    eval 'sub ClearPageActive {
        local($page) = @_;
	    eval q( &clear_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&ClearPageActive);
    eval 'sub TestClearPageActive {
        local($page) = @_;
	    eval q( &test_and_clear_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&TestClearPageActive);
    eval 'sub TestSetPageActive {
        local($page) = @_;
	    eval q( &test_and_set_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&TestSetPageActive);
    eval 'sub PageSlab {
        local($page) = @_;
	    eval q( &test_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&PageSlab);
    eval 'sub SetPageSlab {
        local($page) = @_;
	    eval q( &set_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&SetPageSlab);
    eval 'sub ClearPageSlab {
        local($page) = @_;
	    eval q( &clear_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&ClearPageSlab);
    eval 'sub TestClearPageSlab {
        local($page) = @_;
	    eval q( &test_and_clear_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&TestClearPageSlab);
    eval 'sub TestSetPageSlab {
        local($page) = @_;
	    eval q( &test_and_set_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&TestSetPageSlab);
    if(defined(&CONFIG_HIGHMEM)) {
	eval 'sub PageHighMem {
	    local($page) = @_;
    	    eval q( &is_highmem( &page_zone($page)));
	}' unless defined(&PageHighMem);
    } else {
	eval 'sub PageHighMem {
	    local($page) = @_;
    	    eval q(0);
	}' unless defined(&PageHighMem);
    }
    eval 'sub PageChecked {
        local($page) = @_;
	    eval q( &test_bit( &PG_checked, ($page)-> &flags));
    }' unless defined(&PageChecked);
    eval 'sub SetPageChecked {
        local($page) = @_;
	    eval q( &set_bit( &PG_checked, ($page)-> &flags));
    }' unless defined(&SetPageChecked);
    eval 'sub ClearPageChecked {
        local($page) = @_;
	    eval q( &clear_bit( &PG_checked, ($page)-> &flags));
    }' unless defined(&ClearPageChecked);
    eval 'sub PageReserved {
        local($page) = @_;
	    eval q( &test_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&PageReserved);
    eval 'sub SetPageReserved {
        local($page) = @_;
	    eval q( &set_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&SetPageReserved);
    eval 'sub ClearPageReserved {
        local($page) = @_;
	    eval q( &clear_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&ClearPageReserved);
    eval 'sub __ClearPageReserved {
        local($page) = @_;
	    eval q( &__clear_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&__ClearPageReserved);
    eval 'sub SetPagePrivate {
        local($page) = @_;
	    eval q( &set_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&SetPagePrivate);
    eval 'sub ClearPagePrivate {
        local($page) = @_;
	    eval q( &clear_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&ClearPagePrivate);
    eval 'sub PagePrivate {
        local($page) = @_;
	    eval q( &test_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&PagePrivate);
    eval 'sub __SetPagePrivate {
        local($page) = @_;
	    eval q( &__set_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&__SetPagePrivate);
    eval 'sub __ClearPagePrivate {
        local($page) = @_;
	    eval q( &__clear_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&__ClearPagePrivate);
    eval 'sub PageWriteback {
        local($page) = @_;
	    eval q( &test_bit( &PG_writeback, ($page)-> &flags));
    }' unless defined(&PageWriteback);
    eval 'sub SetPageWriteback {
        local($page) = @_;
	    eval q( &do {  &if (! &test_and_set_bit( &PG_writeback, ($page)-> &flags))  &inc_page_state( &nr_writeback); }  &while (0));
    }' unless defined(&SetPageWriteback);
    eval 'sub TestSetPageWriteback {
        local($page) = @_;
	    eval q(({ \'int\'  &ret;  &ret =  &test_and_set_bit( &PG_writeback, ($page)-> &flags);  &if (! &ret)  &inc_page_state( &nr_writeback);  &ret; }));
    }' unless defined(&TestSetPageWriteback);
    eval 'sub ClearPageWriteback {
        local($page) = @_;
	    eval q( &do {  &if ( &test_and_clear_bit( &PG_writeback, ($page)-> &flags))  &dec_page_state( &nr_writeback); }  &while (0));
    }' unless defined(&ClearPageWriteback);
    eval 'sub TestClearPageWriteback {
        local($page) = @_;
	    eval q(({ \'int\'  &ret;  &ret =  &test_and_clear_bit( &PG_writeback, &-> &flags);  &if  &dec_page_state( &nr_writeback);  &ret; }));
    }' unless defined(&TestClearPageWriteback);
    eval 'sub PageNosave {
        local($page) = @_;
	    eval q( &test_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&PageNosave);
    eval 'sub SetPageNosave {
        local($page) = @_;
	    eval q( &set_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&SetPageNosave);
    eval 'sub TestSetPageNosave {
        local($page) = @_;
	    eval q( &test_and_set_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&TestSetPageNosave);
    eval 'sub ClearPageNosave {
        local($page) = @_;
	    eval q( &clear_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&ClearPageNosave);
    eval 'sub TestClearPageNosave {
        local($page) = @_;
	    eval q( &test_and_clear_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&TestClearPageNosave);
    eval 'sub PageNosaveFree {
        local($page) = @_;
	    eval q( &test_bit( &PG_nosave_free, ($page)-> &flags));
    }' unless defined(&PageNosaveFree);
    eval 'sub SetPageNosaveFree {
        local($page) = @_;
	    eval q( &set_bit( &PG_nosave_free, ($page)-> &flags));
    }' unless defined(&SetPageNosaveFree);
    eval 'sub ClearPageNosaveFree {
        local($page) = @_;
	    eval q( &clear_bit( &PG_nosave_free, ($page)-> &flags));
    }' unless defined(&ClearPageNosaveFree);
    eval 'sub PageMappedToDisk {
        local($page) = @_;
	    eval q( &test_bit( &PG_mappedtodisk, ($page)-> &flags));
    }' unless defined(&PageMappedToDisk);
    eval 'sub SetPageMappedToDisk {
        local($page) = @_;
	    eval q( &set_bit( &PG_mappedtodisk, ($page)-> &flags));
    }' unless defined(&SetPageMappedToDisk);
    eval 'sub ClearPageMappedToDisk {
        local($page) = @_;
	    eval q( &clear_bit( &PG_mappedtodisk, ($page)-> &flags));
    }' unless defined(&ClearPageMappedToDisk);
    eval 'sub PageReclaim {
        local($page) = @_;
	    eval q( &test_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&PageReclaim);
    eval 'sub SetPageReclaim {
        local($page) = @_;
	    eval q( &set_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&SetPageReclaim);
    eval 'sub ClearPageReclaim {
        local($page) = @_;
	    eval q( &clear_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&ClearPageReclaim);
    eval 'sub TestClearPageReclaim {
        local($page) = @_;
	    eval q( &test_and_clear_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&TestClearPageReclaim);
    eval 'sub PageCompound {
        local($page) = @_;
	    eval q( &test_bit( &PG_compound, ($page)-> &flags));
    }' unless defined(&PageCompound);
    eval 'sub SetPageCompound {
        local($page) = @_;
	    eval q( &set_bit( &PG_compound, ($page)-> &flags));
    }' unless defined(&SetPageCompound);
    eval 'sub ClearPageCompound {
        local($page) = @_;
	    eval q( &clear_bit( &PG_compound, ($page)-> &flags));
    }' unless defined(&ClearPageCompound);
    if(defined(&CONFIG_SWAP)) {
	eval 'sub PageSwapCache {
	    local($page) = @_;
    	    eval q( &test_bit( &PG_swapcache, ($page)-> &flags));
	}' unless defined(&PageSwapCache);
	eval 'sub SetPageSwapCache {
	    local($page) = @_;
    	    eval q( &set_bit( &PG_swapcache, ($page)-> &flags));
	}' unless defined(&SetPageSwapCache);
	eval 'sub ClearPageSwapCache {
	    local($page) = @_;
    	    eval q( &clear_bit( &PG_swapcache, ($page)-> &flags));
	}' unless defined(&ClearPageSwapCache);
    } else {
	eval 'sub PageSwapCache {
	    local($page) = @_;
    	    eval q(0);
	}' unless defined(&PageSwapCache);
    }
    eval 'sub PageUncached {
        local($page) = @_;
	    eval q( &test_bit( &PG_uncached, ($page)-> &flags));
    }' unless defined(&PageUncached);
    eval 'sub SetPageUncached {
        local($page) = @_;
	    eval q( &set_bit( &PG_uncached, ($page)-> &flags));
    }' unless defined(&SetPageUncached);
    eval 'sub ClearPageUncached {
        local($page) = @_;
	    eval q( &clear_bit( &PG_uncached, ($page)-> &flags));
    }' unless defined(&ClearPageUncached);
}
1;
