require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_NODEMASK_H)) {
    eval 'sub __LINUX_NODEMASK_H () {1;}' unless defined(&__LINUX_NODEMASK_H);
    require 'linux/kernel.ph';
    require 'linux/threads.ph';
    require 'linux/bitmap.ph';
    require 'linux/numa.ph';
    eval 'sub node_set {
        local($node, $dst) = @_;
	    eval q( &__node_set(($node), ($dst)));
    }' unless defined(&node_set);
    eval 'sub node_clear {
        local($node, $dst) = @_;
	    eval q( &__node_clear(($node), ($dst)));
    }' unless defined(&node_clear);
    eval 'sub nodes_setall {
        local($dst) = @_;
	    eval q( &__nodes_setall(($dst),  &MAX_NUMNODES));
    }' unless defined(&nodes_setall);
    eval 'sub nodes_clear {
        local($dst) = @_;
	    eval q( &__nodes_clear(($dst),  &MAX_NUMNODES));
    }' unless defined(&nodes_clear);
    eval 'sub node_isset {
        local($node, $nodemask) = @_;
	    eval q( &test_bit(($node), ($nodemask). &bits));
    }' unless defined(&node_isset);
    eval 'sub node_test_and_set {
        local($node, $nodemask) = @_;
	    eval q( &__node_test_and_set(($node), ($nodemask)));
    }' unless defined(&node_test_and_set);
    eval 'sub nodes_and {
        local($dst, $src1, $src2) = @_;
	    eval q( &__nodes_and(($dst), ($src1), ($src2),  &MAX_NUMNODES));
    }' unless defined(&nodes_and);
    eval 'sub nodes_or {
        local($dst, $src1, $src2) = @_;
	    eval q( &__nodes_or(($dst), ($src1), ($src2),  &MAX_NUMNODES));
    }' unless defined(&nodes_or);
    eval 'sub nodes_xor {
        local($dst, $src1, $src2) = @_;
	    eval q( &__nodes_xor(($dst), ($src1), ($src2),  &MAX_NUMNODES));
    }' unless defined(&nodes_xor);
    eval 'sub nodes_andnot {
        local($dst, $src1, $src2) = @_;
	    eval q( &__nodes_andnot(($dst), ($src1), ($src2),  &MAX_NUMNODES));
    }' unless defined(&nodes_andnot);
    eval 'sub nodes_complement {
        local($dst, $src) = @_;
	    eval q( &__nodes_complement(($dst), ($src),  &MAX_NUMNODES));
    }' unless defined(&nodes_complement);
    eval 'sub nodes_equal {
        local($src1, $src2) = @_;
	    eval q( &__nodes_equal(($src1), ($src2),  &MAX_NUMNODES));
    }' unless defined(&nodes_equal);
    eval 'sub nodes_intersects {
        local($src1, $src2) = @_;
	    eval q( &__nodes_intersects(($src1), ($src2),  &MAX_NUMNODES));
    }' unless defined(&nodes_intersects);
    eval 'sub nodes_subset {
        local($src1, $src2) = @_;
	    eval q( &__nodes_subset(($src1), ($src2),  &MAX_NUMNODES));
    }' unless defined(&nodes_subset);
    eval 'sub nodes_empty {
        local($src) = @_;
	    eval q( &__nodes_empty(($src),  &MAX_NUMNODES));
    }' unless defined(&nodes_empty);
    eval 'sub nodes_full {
        local($nodemask) = @_;
	    eval q( &__nodes_full(($nodemask),  &MAX_NUMNODES));
    }' unless defined(&nodes_full);
    eval 'sub nodes_weight {
        local($nodemask) = @_;
	    eval q( &__nodes_weight(($nodemask),  &MAX_NUMNODES));
    }' unless defined(&nodes_weight);
    eval 'sub nodes_shift_right {
        local($dst, $src, $n) = @_;
	    eval q( &__nodes_shift_right(($dst), ($src), ($n),  &MAX_NUMNODES));
    }' unless defined(&nodes_shift_right);
    eval 'sub nodes_shift_left {
        local($dst, $src, $n) = @_;
	    eval q( &__nodes_shift_left(($dst), ($src), ($n),  &MAX_NUMNODES));
    }' unless defined(&nodes_shift_left);
    eval 'sub first_node {
        local($src) = @_;
	    eval q( &__first_node(($src)));
    }' unless defined(&first_node);
    eval 'sub next_node {
        local($n, $src) = @_;
	    eval q( &__next_node(($n), ($src)));
    }' unless defined(&next_node);
    eval 'sub nodemask_of_node {
        local($node) = @_;
	    eval q(({  &typeof  &m;  &if ($sizeof{ &m} == $sizeof{\'unsigned long\'}) {  ($m->{bits[0]}) = 1<<($node); }  &else {  &nodes_clear( &m);  &node_set(($node),  &m); }  &m; }));
    }' unless defined(&nodemask_of_node);
    eval 'sub first_unset_node {
        local($mask) = @_;
	    eval q( &__first_unset_node(($mask)));
    }' unless defined(&first_unset_node);
    eval 'sub NODE_MASK_LAST_WORD () { &BITMAP_LAST_WORD_MASK( &MAX_NUMNODES);}' unless defined(&NODE_MASK_LAST_WORD);
    if((defined(&MAX_NUMNODES) ? &MAX_NUMNODES : 0) <= (defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)) {
	eval 'sub NODE_MASK_ALL () {(( &nodemask_t) { { [ &BITS_TO_LONGS( &MAX_NUMNODES)-1] =  &NODE_MASK_LAST_WORD } });}' unless defined(&NODE_MASK_ALL);
    } else {
	eval 'sub NODE_MASK_ALL () {(( &nodemask_t) { { [0...  &BITS_TO_LONGS( &MAX_NUMNODES)-2] = ~0, [ &BITS_TO_LONGS( &MAX_NUMNODES)-1] =  &NODE_MASK_LAST_WORD } });}' unless defined(&NODE_MASK_ALL);
    }
    eval 'sub NODE_MASK_NONE () {(( &nodemask_t) { { [0...  &BITS_TO_LONGS( &MAX_NUMNODES)-1] = 0 } });}' unless defined(&NODE_MASK_NONE);
    eval 'sub nodes_addr {
        local($src) = @_;
	    eval q((($src). &bits));
    }' unless defined(&nodes_addr);
    eval 'sub nodemask_scnprintf {
        local($buf, $len, $src) = @_;
	    eval q( &__nodemask_scnprintf(($buf), ($len), ($src),  &MAX_NUMNODES));
    }' unless defined(&nodemask_scnprintf);
    eval 'sub nodemask_parse {
        local($ubuf, $ulen, $dst) = @_;
	    eval q( &__nodemask_parse(($ubuf), ($ulen), ($dst),  &MAX_NUMNODES));
    }' unless defined(&nodemask_parse);
    eval 'sub nodelist_scnprintf {
        local($buf, $len, $src) = @_;
	    eval q( &__nodelist_scnprintf(($buf), ($len), ($src),  &MAX_NUMNODES));
    }' unless defined(&nodelist_scnprintf);
    eval 'sub nodelist_parse {
        local($buf, $dst) = @_;
	    eval q( &__nodelist_parse(($buf), ($dst),  &MAX_NUMNODES));
    }' unless defined(&nodelist_parse);
    eval 'sub node_remap {
        local($oldbit, $old, $new) = @_;
	    eval q( &__node_remap(($oldbit), ($old), ($new),  &MAX_NUMNODES));
    }' unless defined(&node_remap);
    eval 'sub nodes_remap {
        local($dst, $src, $old, $new) = @_;
	    eval q( &__nodes_remap(($dst), ($src), ($old), ($new),  &MAX_NUMNODES));
    }' unless defined(&nodes_remap);
    if((defined(&MAX_NUMNODES) ? &MAX_NUMNODES : 0) > 1) {
	eval 'sub for_each_node_mask {
	    local($node, $mask) = @_;
    	    eval q( &for (($node) =  &first_node($mask); ($node) <  &MAX_NUMNODES; ($node) =  &next_node(($node), ($mask))));
	}' unless defined(&for_each_node_mask);
    } else {
	eval 'sub for_each_node_mask {
	    local($node, $mask) = @_;
    	    eval q( &if (! &nodes_empty($mask))  &for (($node) = 0; ($node) < 1; ($node)++));
	}' unless defined(&for_each_node_mask);
    }
    if((defined(&MAX_NUMNODES) ? &MAX_NUMNODES : 0) > 1) {
	eval 'sub num_online_nodes () {
	    eval q( &nodes_weight( &node_online_map));
	}' unless defined(&num_online_nodes);
	eval 'sub num_possible_nodes () {
	    eval q( &nodes_weight( &node_possible_map));
	}' unless defined(&num_possible_nodes);
	eval 'sub node_online {
	    local($node) = @_;
    	    eval q( &node_isset(($node),  &node_online_map));
	}' unless defined(&node_online);
	eval 'sub node_possible {
	    local($node) = @_;
    	    eval q( &node_isset(($node),  &node_possible_map));
	}' unless defined(&node_possible);
    } else {
	eval 'sub num_online_nodes () {
	    eval q(1);
	}' unless defined(&num_online_nodes);
	eval 'sub num_possible_nodes () {
	    eval q(1);
	}' unless defined(&num_possible_nodes);
	eval 'sub node_online {
	    local($node) = @_;
    	    eval q((($node) == 0));
	}' unless defined(&node_online);
	eval 'sub node_possible {
	    local($node) = @_;
    	    eval q((($node) == 0));
	}' unless defined(&node_possible);
    }
    eval 'sub any_online_node {
        local($mask) = @_;
	    eval q(({ \'int\'  &node;  &for_each_node_mask( &node, ($mask))  &if ( &node_online( &node))  &break;  &node; }));
    }' unless defined(&any_online_node);
    eval 'sub node_set_online {
        local($node) = @_;
	    eval q( &set_bit(($node),  ($node_online_map->{bits})));
    }' unless defined(&node_set_online);
    eval 'sub node_set_offline {
        local($node) = @_;
	    eval q( &clear_bit(($node),  ($node_online_map->{bits})));
    }' unless defined(&node_set_offline);
    eval 'sub for_each_node {
        local($node) = @_;
	    eval q( &for_each_node_mask(($node),  &node_possible_map));
    }' unless defined(&for_each_node);
    eval 'sub for_each_online_node {
        local($node) = @_;
	    eval q( &for_each_node_mask(($node),  &node_online_map));
    }' unless defined(&for_each_online_node);
}
1;
