require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_MMZONE_H)) {
    eval 'sub _LINUX_MMZONE_H () {1;}' unless defined(&_LINUX_MMZONE_H);
    if(defined(&__KERNEL__)) {
	unless(defined(&__ASSEMBLY__)) {
	    require 'linux/config.ph';
	    require 'linux/spinlock.ph';
	    require 'linux/list.ph';
	    require 'linux/wait.ph';
	    require 'linux/cache.ph';
	    require 'linux/threads.ph';
	    require 'linux/numa.ph';
	    require 'linux/init.ph';
	    require 'linux/seqlock.ph';
	    require 'asm/atomic.ph';
	    unless(defined(&CONFIG_FORCE_MAX_ZONEORDER)) {
		eval 'sub MAX_ORDER () {11;}' unless defined(&MAX_ORDER);
	    } else {
		eval 'sub MAX_ORDER () { &CONFIG_FORCE_MAX_ZONEORDER;}' unless defined(&MAX_ORDER);
	    }
	    if(defined( &CONFIG_SMP)) {
		eval 'sub ZONE_PADDING {
		    local($name) = @_;
    		    eval q(1;);
		}' unless defined(&ZONE_PADDING);
	    } else {
		eval 'sub ZONE_PADDING {
		    local($name) = @_;
    		    eval q();
		}' unless defined(&ZONE_PADDING);
	    }
	    if(defined(&CONFIG_NUMA)) {
	    }
	    if(defined(&CONFIG_NUMA)) {
		eval 'sub zone_pcp {
		    local($__z, $__cpu) = @_;
    		    eval q((($__z)-> $pageset[($__cpu)]));
		}' unless defined(&zone_pcp);
	    } else {
		eval 'sub zone_pcp {
		    local($__z, $__cpu) = @_;
    		    eval q((($__z)-> $pageset[($__cpu)]));
		}' unless defined(&zone_pcp);
	    }
	    eval 'sub ZONE_DMA () {0;}' unless defined(&ZONE_DMA);
	    eval 'sub ZONE_DMA32 () {1;}' unless defined(&ZONE_DMA32);
	    eval 'sub ZONE_NORMAL () {2;}' unless defined(&ZONE_NORMAL);
	    eval 'sub ZONE_HIGHMEM () {3;}' unless defined(&ZONE_HIGHMEM);
	    eval 'sub MAX_NR_ZONES () {4;}' unless defined(&MAX_NR_ZONES);
	    eval 'sub ZONES_SHIFT () {2;}' unless defined(&ZONES_SHIFT);
	    eval 'sub GFP_ZONEMASK () {0x7;}' unless defined(&GFP_ZONEMASK);
	    eval 'sub GFP_ZONETYPES () {(( &GFP_ZONEMASK + 1) / 2+ 1);}' unless defined(&GFP_ZONETYPES);
	    if(defined(&CONFIG_NUMA)) {
	    } else {
	    }
	    if(defined(&CONFIG_MEMORY_HOTPLUG)) {
	    }
	    eval 'sub DEF_PRIORITY () {12;}' unless defined(&DEF_PRIORITY);
	    if(defined(&CONFIG_FLAT_NODE_MEM_MAP)) {
	    }
	    if(defined(&CONFIG_MEMORY_HOTPLUG)) {
	    }
	    eval 'sub node_present_pages {
	        local($nid) = @_;
    		eval q(( &NODE_DATA($nid)-> &node_present_pages));
	    }' unless defined(&node_present_pages);
	    eval 'sub node_spanned_pages {
	        local($nid) = @_;
    		eval q(( &NODE_DATA($nid)-> &node_spanned_pages));
	    }' unless defined(&node_spanned_pages);
	    if(defined(&CONFIG_FLAT_NODE_MEM_MAP)) {
		eval 'sub pgdat_page_nr {
		    local($pgdat, $pagenr) = @_;
    		    eval q((($pgdat)-> &node_mem_map + ($pagenr)));
		}' unless defined(&pgdat_page_nr);
	    } else {
		eval 'sub pgdat_page_nr {
		    local($pgdat, $pagenr) = @_;
    		    eval q( &pfn_to_page(($pgdat)-> &node_start_pfn + ($pagenr)));
		}' unless defined(&pgdat_page_nr);
	    }
	    eval 'sub nid_page_nr {
	        local($nid, $pagenr) = @_;
    		eval q( &pgdat_page_nr( &NODE_DATA($nid),($pagenr)));
	    }' unless defined(&nid_page_nr);
	    require 'linux/memory_hotplug.ph';
	    if(defined(&CONFIG_HAVE_MEMORY_PRESENT)) {
	    } else {
	    }
	    if(defined(&CONFIG_NEED_NODE_MEMMAP_SIZE)) {
	    }
	    eval 'sub zone_idx {
	        local($zone) = @_;
    		eval q((($zone) - ($zone)-> ($zone_pgdat->{node_zones})));
	    }' unless defined(&zone_idx);
	    eval 'sub for_each_pgdat {
	        local($pgdat) = @_;
    		eval q( &for ($pgdat =  &pgdat_list; $pgdat; $pgdat =  ($pgdat->{pgdat_next})));
	    }' unless defined(&for_each_pgdat);
	    eval 'sub for_each_zone {
	        local($zone) = @_;
    		eval q( &for ($zone =  ($pgdat_list->{node_zones}); $zone; $zone =  &next_zone($zone)));
	    }' unless defined(&for_each_zone);
	    require 'linux/topology.ph';
	    unless(defined(&numa_node_id)) {
		eval 'sub numa_node_id () {
		    eval q(( &cpu_to_node( &raw_smp_processor_id())));
		}' unless defined(&numa_node_id);
	    }
	    unless(defined(&CONFIG_NEED_MULTIPLE_NODES)) {
		eval 'sub NODE_DATA {
		    local($nid) = @_;
    		    eval q(( &contig_page_data));
		}' unless defined(&NODE_DATA);
		eval 'sub NODE_MEM_MAP {
		    local($nid) = @_;
    		    eval q( &mem_map);
		}' unless defined(&NODE_MEM_MAP);
		eval 'sub MAX_NODES_SHIFT () {1;}' unless defined(&MAX_NODES_SHIFT);
	    } else {
		require 'asm/mmzone.ph';
	    }
	    if(defined(&CONFIG_SPARSEMEM)) {
		require 'asm/sparsemem.ph';
	    }
	    if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 32) {
		eval 'sub FLAGS_RESERVED () {9;}' unless defined(&FLAGS_RESERVED);
	    }
 elsif((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 64) {
		eval 'sub FLAGS_RESERVED () {32;}' unless defined(&FLAGS_RESERVED);
	    } else {
		die("BITS_PER_LONG\ not\ defined");
	    }
	    unless(defined(&CONFIG_HAVE_ARCH_EARLY_PFN_TO_NID)) {
		eval 'sub early_pfn_to_nid {
		    local($nid) = @_;
    		    eval q((0));
		}' unless defined(&early_pfn_to_nid);
	    }
	    if(defined(&CONFIG_FLATMEM)) {
		eval 'sub pfn_to_nid {
		    local($pfn) = @_;
    		    eval q((0));
		}' unless defined(&pfn_to_nid);
	    }
	    eval 'sub pfn_to_section_nr {
	        local($pfn) = @_;
    		eval q((($pfn) >>  &PFN_SECTION_SHIFT));
	    }' unless defined(&pfn_to_section_nr);
	    eval 'sub section_nr_to_pfn {
	        local($sec) = @_;
    		eval q((($sec) <<  &PFN_SECTION_SHIFT));
	    }' unless defined(&section_nr_to_pfn);
	    if(defined(&CONFIG_SPARSEMEM)) {
		eval 'sub SECTIONS_SHIFT () {( &MAX_PHYSMEM_BITS -  &SECTION_SIZE_BITS);}' unless defined(&SECTIONS_SHIFT);
		eval 'sub PA_SECTION_SHIFT () {( &SECTION_SIZE_BITS);}' unless defined(&PA_SECTION_SHIFT);
		eval 'sub PFN_SECTION_SHIFT () {( &SECTION_SIZE_BITS -  &PAGE_SHIFT);}' unless defined(&PFN_SECTION_SHIFT);
		eval 'sub NR_MEM_SECTIONS () {(1 <<  &SECTIONS_SHIFT);}' unless defined(&NR_MEM_SECTIONS);
		eval 'sub PAGES_PER_SECTION () {(1 <<  &PFN_SECTION_SHIFT);}' unless defined(&PAGES_PER_SECTION);
		eval 'sub PAGE_SECTION_MASK () {(~( &PAGES_PER_SECTION-1));}' unless defined(&PAGE_SECTION_MASK);
		if(((defined(&MAX_ORDER) ? &MAX_ORDER : 0) - 1+ (defined(&PAGE_SHIFT) ? &PAGE_SHIFT : 0)) > (defined(&SECTION_SIZE_BITS) ? &SECTION_SIZE_BITS : 0)) {
		    die("Allocator\ MAX_ORDER\ exceeds\ SECTION_SIZE");
		}
		if(defined(&CONFIG_SPARSEMEM_EXTREME)) {
		    eval 'sub SECTIONS_PER_ROOT () {( &PAGE_SIZE / $sizeof{\'struct mem_section\'});}' unless defined(&SECTIONS_PER_ROOT);
		} else {
		    eval 'sub SECTIONS_PER_ROOT () {1;}' unless defined(&SECTIONS_PER_ROOT);
		}
		eval 'sub SECTION_NR_TO_ROOT {
		    local($sec) = @_;
    		    eval q((($sec) /  &SECTIONS_PER_ROOT));
		}' unless defined(&SECTION_NR_TO_ROOT);
		eval 'sub NR_SECTION_ROOTS () {( &NR_MEM_SECTIONS /  &SECTIONS_PER_ROOT);}' unless defined(&NR_SECTION_ROOTS);
		eval 'sub SECTION_ROOT_MASK () {( &SECTIONS_PER_ROOT - 1);}' unless defined(&SECTION_ROOT_MASK);
		if(defined(&CONFIG_SPARSEMEM_EXTREME)) {
		} else {
		}
		eval 'sub SECTION_MARKED_PRESENT () {(1<<0);}' unless defined(&SECTION_MARKED_PRESENT);
		eval 'sub SECTION_HAS_MEM_MAP () {(1<<1);}' unless defined(&SECTION_HAS_MEM_MAP);
		eval 'sub SECTION_MAP_LAST_BIT () {(1<<2);}' unless defined(&SECTION_MAP_LAST_BIT);
		eval 'sub SECTION_MAP_MASK () {(~( &SECTION_MAP_LAST_BIT-1));}' unless defined(&SECTION_MAP_MASK);
		eval 'sub pfn_to_page {
		    local($pfn) = @_;
    		    eval q(({ \'unsigned long __pfn\' = ($pfn);  &__section_mem_map_addr( &__pfn_to_section( &__pfn)) +  &__pfn; }));
		}' unless defined(&pfn_to_page);
		eval 'sub page_to_pfn {
		    local($page) = @_;
    		    eval q(({ $page -  &__section_mem_map_addr( &__nr_to_section(  &page_to_section($page))); }));
		}' unless defined(&page_to_pfn);
		if(defined(&CONFIG_NUMA)) {
		    eval 'sub pfn_to_nid {
		        local($pfn) = @_;
    			eval q(({ \'unsigned long __pfn_to_nid_pfn\' = ($pfn);  &page_to_nid( &pfn_to_page( &__pfn_to_nid_pfn)); }));
		    }' unless defined(&pfn_to_nid);
		} else {
		    eval 'sub pfn_to_nid {
		        local($pfn) = @_;
    			eval q((0));
		    }' unless defined(&pfn_to_nid);
		}
		eval 'sub early_pfn_valid {
		    local($pfn) = @_;
    		    eval q( &pfn_valid($pfn));
		}' unless defined(&early_pfn_valid);
	    } else {
		eval 'sub sparse_init () {
		    eval q( &do {}  &while (0));
		}' unless defined(&sparse_init);
		eval 'sub sparse_index_init {
		    local($_sec, $_nid) = @_;
    		    eval q( &do {}  &while (0));
		}' unless defined(&sparse_index_init);
	    }
	    unless(defined(&early_pfn_valid)) {
		eval 'sub early_pfn_valid {
		    local($pfn) = @_;
    		    eval q((1));
		}' unless defined(&early_pfn_valid);
	    }
	}
    }
}
1;
