require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASMARM_PAGE_H)) {
    eval 'sub _ASMARM_PAGE_H () {1;}' unless defined(&_ASMARM_PAGE_H);
    require 'linux/config.ph';
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1 <<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {(~( &PAGE_SIZE-1));}' unless defined(&PAGE_MASK);
    if(defined(&__KERNEL__)) {
	eval 'sub PAGE_ALIGN {
	    local($addr) = @_;
    	    eval q(((($addr)+ &PAGE_SIZE-1) &PAGE_MASK));
	}' unless defined(&PAGE_ALIGN);
	unless(defined(&__ASSEMBLY__)) {
	    require 'asm/glue.ph';
	    undef(&_USER) if defined(&_USER);
	    undef(&MULTI_USER) if defined(&MULTI_USER);
	    if(defined(&CONFIG_CPU_COPY_V3)) {
		if(defined(&_USER)) {
		    eval 'sub MULTI_USER () {1;}' unless defined(&MULTI_USER);
		} else {
		    eval 'sub _USER () { &v3;}' unless defined(&_USER);
		}
	    }
	    if(defined(&CONFIG_CPU_COPY_V4WT)) {
		if(defined(&_USER)) {
		    eval 'sub MULTI_USER () {1;}' unless defined(&MULTI_USER);
		} else {
		    eval 'sub _USER () { &v4wt;}' unless defined(&_USER);
		}
	    }
	    if(defined(&CONFIG_CPU_COPY_V4WB)) {
		if(defined(&_USER)) {
		    eval 'sub MULTI_USER () {1;}' unless defined(&MULTI_USER);
		} else {
		    eval 'sub _USER () { &v4wb;}' unless defined(&_USER);
		}
	    }
	    if(defined(&CONFIG_CPU_SA1100)) {
		if(defined(&_USER)) {
		    eval 'sub MULTI_USER () {1;}' unless defined(&MULTI_USER);
		} else {
		    eval 'sub _USER () { &v4_mc;}' unless defined(&_USER);
		}
	    }
	    if(defined(&CONFIG_CPU_XSCALE)) {
		if(defined(&_USER)) {
		    eval 'sub MULTI_USER () {1;}' unless defined(&MULTI_USER);
		} else {
		    eval 'sub _USER () { &xscale_mc;}' unless defined(&_USER);
		}
	    }
	    if(defined(&CONFIG_CPU_COPY_V6)) {
		eval 'sub MULTI_USER () {1;}' unless defined(&MULTI_USER);
	    }
	    if(!defined( &_USER)  && !defined( &MULTI_USER)) {
		die("Unknown\ user\ operations\ model");
	    }
	    if(defined(&MULTI_USER)) {
		eval 'sub __cpu_clear_user_page () { ($cpu_user->{cpu_clear_user_page});}' unless defined(&__cpu_clear_user_page);
		eval 'sub __cpu_copy_user_page () { ($cpu_user->{cpu_copy_user_page});}' unless defined(&__cpu_copy_user_page);
	    } else {
		eval 'sub __cpu_clear_user_page () { &__glue( &_USER, &_clear_user_page);}' unless defined(&__cpu_clear_user_page);
		eval 'sub __cpu_copy_user_page () { &__glue( &_USER, &_copy_user_page);}' unless defined(&__cpu_copy_user_page);
	    }
	    eval 'sub clear_user_page {
	        local($addr,$vaddr,$pg) = @_;
    		eval q( &__cpu_clear_user_page($addr, $vaddr));
	    }' unless defined(&clear_user_page);
	    eval 'sub copy_user_page {
	        local($to,$from,$vaddr,$pg) = @_;
    		eval q( &__cpu_copy_user_page($to, $from, $vaddr));
	    }' unless defined(&copy_user_page);
	    eval 'sub clear_page {
	        local($page) = @_;
    		eval q( &memzero(($page),  &PAGE_SIZE));
	    }' unless defined(&clear_page);
	    undef(&STRICT_MM_TYPECHECKS) if defined(&STRICT_MM_TYPECHECKS);
	    if(defined(&STRICT_MM_TYPECHECKS)) {
		eval 'sub pte_val {
		    local($x) = @_;
    		    eval q((($x). &pte));
		}' unless defined(&pte_val);
		eval 'sub pmd_val {
		    local($x) = @_;
    		    eval q((($x). &pmd));
		}' unless defined(&pmd_val);
		eval 'sub pgd_val {
		    local($x) = @_;
    		    eval q((($x). $pgd[0]));
		}' unless defined(&pgd_val);
		eval 'sub pgprot_val {
		    local($x) = @_;
    		    eval q((($x). &pgprot));
		}' unless defined(&pgprot_val);
		eval 'sub __pte {
		    local($x) = @_;
    		    eval q((( &pte_t) { ($x) } ));
		}' unless defined(&__pte);
		eval 'sub __pmd {
		    local($x) = @_;
    		    eval q((( &pmd_t) { ($x) } ));
		}' unless defined(&__pmd);
		eval 'sub __pgprot {
		    local($x) = @_;
    		    eval q((( &pgprot_t) { ($x) } ));
		}' unless defined(&__pgprot);
	    } else {
		eval 'sub pte_val {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&pte_val);
		eval 'sub pmd_val {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&pmd_val);
		eval 'sub pgd_val {
		    local($x) = @_;
    		    eval q((($x)[0]));
		}' unless defined(&pgd_val);
		eval 'sub pgprot_val {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&pgprot_val);
		eval 'sub __pte {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&__pte);
		eval 'sub __pmd {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&__pmd);
		eval 'sub __pgprot {
		    local($x) = @_;
    		    eval q(($x));
		}' unless defined(&__pgprot);
	    }
	    require 'asm/memory.ph';
	}
	eval 'sub VM_DATA_DEFAULT_FLAGS () {( &VM_READ |  &VM_WRITE |  &VM_EXEC |  &VM_MAYREAD |  &VM_MAYWRITE |  &VM_MAYEXEC);}' unless defined(&VM_DATA_DEFAULT_FLAGS);
	if(defined( &CONFIG_AEABI)  && ((defined(&__LINUX_ARM_ARCH__) ? &__LINUX_ARM_ARCH__ : 0) >= 5)) {
	    eval 'sub ARCH_SLAB_MINALIGN () {8;}' unless defined(&ARCH_SLAB_MINALIGN);
	}
    }
    require 'asm-generic/page.ph';
}
1;
