require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SIGNAL_H)) {
    eval 'sub _LINUX_SIGNAL_H () {1;}' unless defined(&_LINUX_SIGNAL_H);
    require 'linux/list.ph';
    require 'linux/spinlock.ph';
    require 'asm/signal.ph';
    require 'asm/siginfo.ph';
    if(defined(&__KERNEL__)) {
	eval 'sub SA_PROBE () { &SA_ONESHOT;}' unless defined(&SA_PROBE);
	eval 'sub SA_SAMPLE_RANDOM () { &SA_RESTART;}' unless defined(&SA_SAMPLE_RANDOM);
	eval 'sub SA_SHIRQ () {0x4000000;}' unless defined(&SA_SHIRQ);
	eval 'sub SA_TRIGGER_LOW () {0x8;}' unless defined(&SA_TRIGGER_LOW);
	eval 'sub SA_TRIGGER_HIGH () {0x4;}' unless defined(&SA_TRIGGER_HIGH);
	eval 'sub SA_TRIGGER_FALLING () {0x2;}' unless defined(&SA_TRIGGER_FALLING);
	eval 'sub SA_TRIGGER_RISING () {0x1;}' unless defined(&SA_TRIGGER_RISING);
	eval 'sub SA_TRIGGER_MASK () {( &SA_TRIGGER_HIGH| &SA_TRIGGER_LOW|  &SA_TRIGGER_RISING| &SA_TRIGGER_FALLING);}' unless defined(&SA_TRIGGER_MASK);
	eval 'sub SIGQUEUE_PREALLOC () {1;}' unless defined(&SIGQUEUE_PREALLOC);
	unless(defined(&__HAVE_ARCH_SIG_BITOPS)) {
	    require 'linux/bitops.ph';
	}
	eval 'sub sigmask {
	    local($sig) = @_;
    	    eval q((1 << (($sig) - 1)));
	}' unless defined(&sigmask);
	unless(defined(&__HAVE_ARCH_SIG_SETOPS)) {
	    require 'linux/string.ph';
	    eval 'sub _SIG_SET_BINOP {
	        local($name, $op) = @_;
    		eval q( &static  &inline  &void $name( &sigset_t * &r,  &const  &sigset_t * &a,  &const  &sigset_t * &b) {  &extern  &void  &_NSIG_WORDS_is_unsupported_size( &void); \'unsigned long a0\',  &a1,  &a2,  &a3,  &b0,  &b1,  &b2,  &b3;  &switch ( &_NSIG_WORDS) {  &case 4:  &a3 =  ($a->{sig[3]});  &a2 =  ($a->{sig[2]});  &b3 =  ($b->{sig[3]});  &b2 =  ($b->{sig[2]});  ($r->{sig[3]}) = $op( &a3,  &b3);  ($r->{sig[2]}) = $op( &a2,  &b2);  &case 2:  &a1 =  ($a->{sig[1]});  &b1 =  ($b->{sig[1]});  ($r->{sig[1]}) = $op( &a1,  &b1);  &case 1:  &a0 =  ($a->{sig[0]});  &b0 =  ($b->{sig[0]});  ($r->{sig[0]}) = $op( &a0,  &b0);  &break;  &default:  &_NSIG_WORDS_is_unsupported_size(); } });
	    }' unless defined(&_SIG_SET_BINOP);
	    eval 'sub _sig_or {
	        local($x,$y) = @_;
    		eval q((($x) | ($y)));
	    }' unless defined(&_sig_or);
	    eval 'sub _sig_and {
	        local($x,$y) = @_;
    		eval q((($x) & ($y)));
	    }' unless defined(&_sig_and);
	    eval 'sub _sig_nand {
	        local($x,$y) = @_;
    		eval q((($x) & ~($y)));
	    }' unless defined(&_sig_nand);
	    undef(&_SIG_SET_BINOP) if defined(&_SIG_SET_BINOP);
	    undef(&_sig_or) if defined(&_sig_or);
	    undef(&_sig_and) if defined(&_sig_and);
	    undef(&_sig_nand) if defined(&_sig_nand);
	    eval 'sub _SIG_SET_OP {
	        local($name, $op) = @_;
    		eval q( &static  &inline  &void $name( &sigset_t * &set) {  &extern  &void  &_NSIG_WORDS_is_unsupported_size( &void);  &switch ( &_NSIG_WORDS) {  &case 4:  ($set->{sig[3]}) = $op( ($set->{sig[3]}));  ($set->{sig[2]}) = $op( ($set->{sig[2]}));  &case 2:  ($set->{sig[1]}) = $op( ($set->{sig[1]}));  &case 1:  ($set->{sig[0]}) = $op( ($set->{sig[0]}));  &break;  &default:  &_NSIG_WORDS_is_unsupported_size(); } });
	    }' unless defined(&_SIG_SET_OP);
	    eval 'sub _sig_not {
	        local($x) = @_;
    		eval q((~($x)));
	    }' unless defined(&_sig_not);
	    undef(&_SIG_SET_OP) if defined(&_SIG_SET_OP);
	    undef(&_sig_not) if defined(&_sig_not);
	}
    }
}
1;
