require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_SYSTEM_H)) {
    eval 'sub __ASM_SYSTEM_H () {1;}' unless defined(&__ASM_SYSTEM_H);
    require 'linux/config.ph';
    require 'linux/kernel.ph';
    require 'asm/segment.ph';
    if(defined(&__KERNEL__)) {
	if(defined(&CONFIG_SMP)) {
	    eval 'sub LOCK_PREFIX () {"lock ; ";}' unless defined(&LOCK_PREFIX);
	} else {
	    eval 'sub LOCK_PREFIX () {"";}' unless defined(&LOCK_PREFIX);
	}
	eval 'sub __STR {
	    local($x) = @_;
    	    eval q($x);
	}' unless defined(&__STR);
	eval 'sub STR {
	    local($x) = @_;
    	    eval q( &__STR($x));
	}' unless defined(&STR);
	eval 'sub __SAVE {
	    local($reg,$offset) = @_;
    	    eval q(\\"movq %%\\" $reg \\",(14-\\" $offset \\")*8(%%rsp)\\\\n\\\\t\\");
	}' unless defined(&__SAVE);
	eval 'sub __RESTORE {
	    local($reg,$offset) = @_;
    	    eval q(\\"movq (14-\\" $offset \\")*8(%%rsp),%%\\" $reg \\"\\\\n\\\\t\\");
	}' unless defined(&__RESTORE);
	eval 'sub SAVE_CONTEXT () {"pushq %%rbp ; movq %%rsi,%%rbp\\n\\t";}' unless defined(&SAVE_CONTEXT);
	eval 'sub RESTORE_CONTEXT () {"movq %%rbp,%%rsi ; popq %%rbp\\n\\t";}' unless defined(&RESTORE_CONTEXT);
	eval 'sub __EXTRA_CLOBBER () {,"rcx","rbx","rdx","r8","r9","r10","r11","r12","r13","r14","r15";}' unless defined(&__EXTRA_CLOBBER);
	eval 'sub switch_to {
	    local($prev,$next,$last) = @_;
    	    eval q( &asm  &volatile( &SAVE_CONTEXT \\"movq %%rsp,%P[threadrsp](%[prev])\\\\n\\\\t\\" \\"movq %P[threadrsp](%[next]),%%rsp\\\\n\\\\t\\" \\"call __switch_to\\\\n\\\\t\\" \\".globl thread_return\\\\n\\" \\"thread_return:\\\\n\\\\t\\" \\"movq %%gs:%P[pda_pcurrent],%%rsi\\\\n\\\\t\\" \\"movq %P[thread_info](%%rsi),%%r8\\\\n\\\\t\\"  &LOCK \\"btr  %[tif_fork],%P[ti_flags](%%r8)\\\\n\\\\t\\" \\"movq %%rax,%%rdi\\\\n\\\\t\\" \\"jc   ret_from_fork\\\\n\\\\t\\"  &RESTORE_CONTEXT : \\"=a\\" ($last) : [$next] \\"S\\" ($next), [$prev] \\"D\\" ($prev), [ &threadrsp] \\"i\\" ( &offsetof(1;
	}' unless defined(&switch_to);
	eval 'sub loadsegment {
	    local($seg,$value) = @_;
    	    eval q( &asm  &volatile(\\"\\\\n\\" \\"1:\\\\t\\" \\"movl %k0,%%\\" $seg \\"\\\\n\\" \\"2:\\\\n\\" \\".section .fixup,\\\\\\"ax\\\\\\"\\\\n\\" \\"3:\\\\t\\" \\"movl %1,%%\\" $seg \\"\\\\n\\\\t\\" \\"jmp 2b\\\\n\\" \\".previous\\\\n\\" \\".section __ex_table,\\\\\\"a\\\\\\"\\\\n\\\\t\\" \\".align 8\\\\n\\\\t\\" \\".quad 1b,3b\\\\n\\" \\".previous\\" : :\\"r\\" ($value), \\"r\\" (0)));
	}' unless defined(&loadsegment);
	eval 'sub set_debug {
	    local($value,$register) = @_;
    	    eval q( &__asm__(\\"movq %0,%%db\\" $register : :\\"r\\" ( $value)));
	}' unless defined(&set_debug);
	if(defined(&__KERNEL__)) {
	}
	eval 'sub alternative {
	    local($oldinstr, $newinstr, $feature) = @_;
    	    eval q( &asm  &volatile (\\"661:\\\\n\\\\t\\" $oldinstr \\"\\\\n662:\\\\n\\" \\".section .altinstructions,\\\\\\"a\\\\\\"\\\\n\\" \\"  .align 8\\\\n\\" \\"  .quad 661b\\\\n\\" \\"  .quad 663f\\\\n\\" \\"  .byte %c0\\\\n\\" \\"  .byte 662b-661b\\\\n\\" \\"  .byte 664f-663f\\\\n\\" \\".previous\\\\n\\" \\".section .altinstr_replacement,\\\\\\"ax\\\\\\"\\\\n\\" \\"663:\\\\n\\\\t\\" $newinstr \\"\\\\n664:\\\\n\\" \\".previous\\" :: \\"i\\" ($feature) : \\"memory\\"));
	}' unless defined(&alternative);
	eval 'sub alternative_input () {( &oldinstr,  &newinstr,  &feature,  &input...)  &asm  &volatile ("661:\\n\\t"  &oldinstr "\\n662:\\n" ".section .altinstructions,\\"a\\"\\n" "  .align 8\\n" "  .quad 661b\\n" "  .quad 663f\\n" "  .byte %c0\\n" "  .byte 662b-661b\\n" "  .byte 664f-663f\\n" ".previous\\n" ".section .altinstr_replacement,\\"ax\\"\\n" "663:\\n\\t"  &newinstr "\\n664:\\n" ".previous" :: "i" ( &feature),  &input);}' unless defined(&alternative_input);
	eval 'sub alternative_io () {( &oldinstr,  &newinstr,  &feature,  &output,  &input...)  &asm  &volatile ("661:\\n\\t"  &oldinstr "\\n662:\\n" ".section .altinstructions,\\"a\\"\\n" "  .align 8\\n" "  .quad 661b\\n" "  .quad 663f\\n" "  .byte %c[feat]\\n" "  .byte 662b-661b\\n" "  .byte 664f-663f\\n" ".previous\\n" ".section .altinstr_replacement,\\"ax\\"\\n" "663:\\n\\t"  &newinstr "\\n664:\\n" ".previous" :  &output : [ &feat] "i" ( &feature),  &input);}' unless defined(&alternative_io);
	eval 'sub clts () {
	    eval q( &__asm__  &__volatile__ (\\"clts\\"));
	}' unless defined(&clts);
	eval 'sub stts () {
	    eval q( &write_cr0(8|  &read_cr0()));
	}' unless defined(&stts);
	eval 'sub wbinvd () {
	    eval q( &__asm__  &__volatile__ (\\"wbinvd\\": : :\\"memory\\"););
	}' unless defined(&wbinvd);
    }
    eval 'sub nop () {
        eval q( &__asm__  &__volatile__ (\\"nop\\"));
    }' unless defined(&nop);
    eval 'sub xchg {
        local($ptr,$v) = @_;
	    eval q((( &__typeof__(*)) &__xchg(($v),($ptr),$sizeof{($ptr)})));
    }' unless defined(&xchg);
    eval 'sub tas {
        local($ptr) = @_;
	    eval q(( &xchg(($ptr),1)));
    }' unless defined(&tas);
    eval 'sub __xg {
        local($x) = @_;
	    eval q((($x)));
    }' unless defined(&__xg);
    eval 'sub _set_64bit () { &set_64bit;}' unless defined(&_set_64bit);
    eval 'sub __HAVE_ARCH_CMPXCHG () {1;}' unless defined(&__HAVE_ARCH_CMPXCHG);
    eval 'sub cmpxchg {
        local($ptr,$o,$n) = @_;
	    eval q((( &__typeof__(*)) &__cmpxchg(,, ($n),$sizeof{($ptr)})));
    }' unless defined(&cmpxchg);
    if(defined(&CONFIG_SMP)) {
	eval 'sub smp_mb () {
	    eval q( &mb());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &rmb());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &wmb());
	}' unless defined(&smp_wmb);
	eval 'sub smp_read_barrier_depends () {
	    eval q( &do {}  &while(0));
	}' unless defined(&smp_read_barrier_depends);
    } else {
	eval 'sub smp_mb () {
	    eval q( &barrier());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &barrier());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &barrier());
	}' unless defined(&smp_wmb);
	eval 'sub smp_read_barrier_depends () {
	    eval q( &do {}  &while(0));
	}' unless defined(&smp_read_barrier_depends);
    }
    eval 'sub mb () {
        eval q( &asm  &volatile(\\"mfence\\":::\\"memory\\"));
    }' unless defined(&mb);
    eval 'sub rmb () {
        eval q( &asm  &volatile(\\"lfence\\":::\\"memory\\"));
    }' unless defined(&rmb);
    if(defined(&CONFIG_UNORDERED_IO)) {
	eval 'sub wmb () {
	    eval q( &asm  &volatile(\\"sfence\\" ::: \\"memory\\"));
	}' unless defined(&wmb);
    } else {
	eval 'sub wmb () {
	    eval q( &asm  &volatile(\\"\\" ::: \\"memory\\"));
	}' unless defined(&wmb);
    }
    eval 'sub read_barrier_depends () {
        eval q( &do {}  &while(0));
    }' unless defined(&read_barrier_depends);
    eval 'sub set_mb {
        local($var, $value) = @_;
	    eval q( &do {  &xchg($var, $value); }  &while (0));
    }' unless defined(&set_mb);
    eval 'sub set_wmb {
        local($var, $value) = @_;
	    eval q( &do { $var = $value;  &wmb(); }  &while (0));
    }' unless defined(&set_wmb);
    eval 'sub warn_if_not_ulong {
        local($x) = @_;
	    eval q( &do { \'unsigned long foo\'; (($x) ==  &foo); }  &while (0));
    }' unless defined(&warn_if_not_ulong);
    eval 'sub local_save_flags {
        local($x) = @_;
	    eval q( &do {  &warn_if_not_ulong($x);  &__asm__  &__volatile__(\\"# save_flags \\\\n\\\\t pushfq ; popq %q0\\":\\"=g\\" ($x): :\\"memory\\"); }  &while (0));
    }' unless defined(&local_save_flags);
    eval 'sub local_irq_restore {
        local($x) = @_;
	    eval q( &__asm__  &__volatile__(\\"# restore_flags \\\\n\\\\t pushq %0 ; popfq\\": :\\"g\\" ($x):\\"memory\\", \\"cc\\"));
    }' unless defined(&local_irq_restore);
    if(defined(&CONFIG_X86_VSMP)) {
	eval 'sub local_irq_disable () {
	    eval q( &do { \'unsigned long flags\';  &local_save_flags( &flags);  &local_irq_restore(( &flags & ~(1<< 9)) | (1<< 18)); }  &while (0));
	}' unless defined(&local_irq_disable);
	eval 'sub local_irq_enable () {
	    eval q( &do { \'unsigned long flags\';  &local_save_flags( &flags);  &local_irq_restore(( &flags | (1<< 9)) & ~(1<< 18)); }  &while (0));
	}' unless defined(&local_irq_enable);
	eval 'sub irqs_disabled () {
	    eval q(({ \'unsigned long flags\';  &local_save_flags( &flags); ( &flags & (1<<18)) || !( &flags & (1<<9)); }));
	}' unless defined(&irqs_disabled);
	eval 'sub local_irq_save {
	    local($x) = @_;
    	    eval q( &do {  &local_save_flags($x);  &local_irq_restore(($x & ~(1<< 9)) | (1<< 18)); }  &while (0));
	}' unless defined(&local_irq_save);
    } else {
	eval 'sub local_irq_disable () {
	    eval q( &__asm__  &__volatile__(\\"cli\\": : :\\"memory\\"));
	}' unless defined(&local_irq_disable);
	eval 'sub local_irq_enable () {
	    eval q( &__asm__  &__volatile__(\\"sti\\": : :\\"memory\\"));
	}' unless defined(&local_irq_enable);
	eval 'sub irqs_disabled () {
	    eval q(({ \'unsigned long flags\';  &local_save_flags( &flags); !( &flags & (1<<9)); }));
	}' unless defined(&irqs_disabled);
	eval 'sub local_irq_save {
	    local($x) = @_;
    	    eval q( &do {  &warn_if_not_ulong($x);  &__asm__  &__volatile__(\\"# local_irq_save \\\\n\\\\t pushfq ; popq %0 ; cli\\":\\"=g\\" ($x): :\\"memory\\"); }  &while (0));
	}' unless defined(&local_irq_save);
    }
    eval 'sub safe_halt () {
        eval q( &__asm__  &__volatile__(\\"sti; hlt\\": : :\\"memory\\"));
    }' unless defined(&safe_halt);
    eval 'sub halt () {
        eval q( &__asm__  &__volatile__(\\"hlt\\": : :\\"memory\\"));
    }' unless defined(&halt);
}
1;
