require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_GENERIC_PGTABLE_H)) {
    eval 'sub _ASM_GENERIC_PGTABLE_H () {1;}' unless defined(&_ASM_GENERIC_PGTABLE_H);
    unless(defined(&__HAVE_ARCH_PTEP_ESTABLISH)) {
	unless(defined(&__HAVE_ARCH_SET_PTE_ATOMIC)) {
	    eval 'sub ptep_establish {
	        local($__vma, $__address, $__ptep, $__entry) = @_;
    		eval q( &do {  &set_pte_at(($__vma)-> &vm_mm, ($__address), $__ptep, $__entry);  &flush_tlb_page($__vma, $__address); }  &while (0));
	    }' unless defined(&ptep_establish);
	} else {
	    eval 'sub ptep_establish {
	        local($__vma, $__address, $__ptep, $__entry) = @_;
    		eval q( &do {  &set_pte_atomic($__ptep, $__entry);  &flush_tlb_page($__vma, $__address); }  &while (0));
	    }' unless defined(&ptep_establish);
	}
    }
    unless(defined(&__HAVE_ARCH_PTEP_SET_ACCESS_FLAGS)) {
	eval 'sub ptep_set_access_flags {
	    local($__vma, $__address, $__ptep, $__entry, $__dirty) = @_;
    	    eval q( &do {  &set_pte_at(($__vma)-> &vm_mm, ($__address), $__ptep, $__entry);  &flush_tlb_page($__vma, $__address); }  &while (0));
	}' unless defined(&ptep_set_access_flags);
    }
    unless(defined(&__HAVE_ARCH_PTEP_TEST_AND_CLEAR_YOUNG)) {
	eval 'sub ptep_test_and_clear_young {
	    local($__vma, $__address, $__ptep) = @_;
    	    eval q(({  &pte_t  &__pte = *($__ptep); \'int\'  &r = 1;  &if (! &pte_young( &__pte))  &r = 0;  &else  &set_pte_at(($__vma)-> &vm_mm, ($__address), ($__ptep),  &pte_mkold( &__pte));  &r; }));
	}' unless defined(&ptep_test_and_clear_young);
    }
    unless(defined(&__HAVE_ARCH_PTEP_CLEAR_YOUNG_FLUSH)) {
	eval 'sub ptep_clear_flush_young {
	    local($__vma, $__address, $__ptep) = @_;
    	    eval q(({ \'int\'  &__young;  &__young =  &ptep_test_and_clear_young($__vma, $__address, $__ptep);  &if  &flush_tlb_page($__vma, $__address);  &__young; }));
	}' unless defined(&ptep_clear_flush_young);
    }
    unless(defined(&__HAVE_ARCH_PTEP_TEST_AND_CLEAR_DIRTY)) {
	eval 'sub ptep_test_and_clear_dirty {
	    local($__vma, $__address, $__ptep) = @_;
    	    eval q(({  &pte_t  &__pte = *$__ptep; \'int\'  &r = 1;  &if (! &pte_dirty( &__pte))  &r = 0;  &else  &set_pte_at(($__vma)-> &vm_mm, ($__address), ($__ptep),  &pte_mkclean( &__pte));  &r; }));
	}' unless defined(&ptep_test_and_clear_dirty);
    }
    unless(defined(&__HAVE_ARCH_PTEP_CLEAR_DIRTY_FLUSH)) {
	eval 'sub ptep_clear_flush_dirty {
	    local($__vma, $__address, $__ptep) = @_;
    	    eval q(({ \'int\'  &__dirty;  &__dirty =  &ptep_test_and_clear_dirty($__vma, $__address, $__ptep);  &if  &flush_tlb_page($__vma, $__address);  &__dirty; }));
	}' unless defined(&ptep_clear_flush_dirty);
    }
    unless(defined(&__HAVE_ARCH_PTEP_GET_AND_CLEAR)) {
	eval 'sub ptep_get_and_clear {
	    local($__mm, $__address, $__ptep) = @_;
    	    eval q(({  &pte_t  &__pte = *($__ptep);  &pte_clear(($__mm), ($__address), ($__ptep));  &__pte; }));
	}' unless defined(&ptep_get_and_clear);
    }
    unless(defined(&__HAVE_ARCH_PTEP_GET_AND_CLEAR_FULL)) {
	eval 'sub ptep_get_and_clear_full {
	    local($__mm, $__address, $__ptep, $__full) = @_;
    	    eval q(({  &pte_t  &__pte;  &__pte =  &ptep_get_and_clear(($__mm), ($__address), ($__ptep));  &__pte; }));
	}' unless defined(&ptep_get_and_clear_full);
    }
    unless(defined(&__HAVE_ARCH_PTE_CLEAR_FULL)) {
	eval 'sub pte_clear_full {
	    local($__mm, $__address, $__ptep, $__full) = @_;
    	    eval q( &do {  &pte_clear(($__mm), ($__address), ($__ptep)); }  &while (0));
	}' unless defined(&pte_clear_full);
    }
    unless(defined(&__HAVE_ARCH_PTEP_CLEAR_FLUSH)) {
	eval 'sub ptep_clear_flush {
	    local($__vma, $__address, $__ptep) = @_;
    	    eval q(({  &pte_t  &__pte;  &__pte =  &ptep_get_and_clear(($__vma)-> &vm_mm, $__address, $__ptep);  &flush_tlb_page($__vma, $__address);  &__pte; }));
	}' unless defined(&ptep_clear_flush);
    }
    unless(defined(&__HAVE_ARCH_PTEP_SET_WRPROTECT)) {
    }
    unless(defined(&__HAVE_ARCH_PTE_SAME)) {
	eval 'sub pte_same {
	    local($A,$B) = @_;
    	    eval q(( &pte_val($A) ==  &pte_val($B)));
	}' unless defined(&pte_same);
    }
    unless(defined(&__HAVE_ARCH_PAGE_TEST_AND_CLEAR_DIRTY)) {
	eval 'sub page_test_and_clear_dirty {
	    local($page) = @_;
    	    eval q((0));
	}' unless defined(&page_test_and_clear_dirty);
	eval 'sub pte_maybe_dirty {
	    local($pte) = @_;
    	    eval q( &pte_dirty($pte));
	}' unless defined(&pte_maybe_dirty);
    } else {
	eval 'sub pte_maybe_dirty {
	    local($pte) = @_;
    	    eval q((1));
	}' unless defined(&pte_maybe_dirty);
    }
    unless(defined(&__HAVE_ARCH_PAGE_TEST_AND_CLEAR_YOUNG)) {
	eval 'sub page_test_and_clear_young {
	    local($page) = @_;
    	    eval q((0));
	}' unless defined(&page_test_and_clear_young);
    }
    unless(defined(&__HAVE_ARCH_PGD_OFFSET_GATE)) {
	eval 'sub pgd_offset_gate {
	    local($mm, $addr) = @_;
    	    eval q( &pgd_offset($mm, $addr));
	}' unless defined(&pgd_offset_gate);
    }
    unless(defined(&__HAVE_ARCH_LAZY_MMU_PROT_UPDATE)) {
	eval 'sub lazy_mmu_prot_update {
	    local($pte) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&lazy_mmu_prot_update);
    }
    unless(defined(&__HAVE_ARCH_MULTIPLE_ZERO_PAGE)) {
	eval 'sub move_pte {
	    local($pte, $prot, $old_addr, $new_addr) = @_;
    	    eval q(($pte));
	}' unless defined(&move_pte);
    } else {
	eval 'sub move_pte {
	    local($pte, $prot, $old_addr, $new_addr) = @_;
    	    eval q(({  &pte_t  &newpte = ($pte);  &if ( &pte_present($pte)  &&  &pfn_valid( &pte_pfn($pte))  &&  &pte_page($pte) ==  &ZERO_PAGE($old_addr))  &newpte =  &mk_pte( &ZERO_PAGE($new_addr), ($prot));  &newpte; }));
	}' unless defined(&move_pte);
    }
    eval 'sub pgd_addr_end {
        local($addr, $end) = @_;
	    eval q(({ \'unsigned long __boundary\' = (($addr) +  &PGDIR_SIZE) &  &PGDIR_MASK; ( &__boundary - 1< ($end) - 1)?  &__boundary: ($end); }));
    }' unless defined(&pgd_addr_end);
    unless(defined(&pud_addr_end)) {
	eval 'sub pud_addr_end {
	    local($addr, $end) = @_;
    	    eval q(({ \'unsigned long __boundary\' = (($addr) +  &PUD_SIZE) &  &PUD_MASK; ( &__boundary - 1< ($end) - 1)?  &__boundary: ($end); }));
	}' unless defined(&pud_addr_end);
    }
    unless(defined(&pmd_addr_end)) {
	eval 'sub pmd_addr_end {
	    local($addr, $end) = @_;
    	    eval q(({ \'unsigned long __boundary\' = (($addr) +  &PMD_SIZE) &  &PMD_MASK; ( &__boundary - 1< ($end) - 1)?  &__boundary: ($end); }));
	}' unless defined(&pmd_addr_end);
    }
    unless(defined(&__ASSEMBLY__)) {
    }
}
1;
