require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_INTERRUPT_H)) {
    eval 'sub _LINUX_INTERRUPT_H () {1;}' unless defined(&_LINUX_INTERRUPT_H);
    require 'linux/config.ph';
    require 'linux/kernel.ph';
    require 'linux/linkage.ph';
    require 'linux/bitops.ph';
    require 'linux/preempt.ph';
    require 'linux/cpumask.ph';
    require 'linux/hardirq.ph';
    require 'linux/sched.ph';
    require 'asm/atomic.ph';
    require 'asm/ptrace.ph';
    require 'asm/system.ph';
    eval 'sub IRQ_NONE () {(0);}' unless defined(&IRQ_NONE);
    eval 'sub IRQ_HANDLED () {(1);}' unless defined(&IRQ_HANDLED);
    eval 'sub IRQ_RETVAL {
        local($x) = @_;
	    eval q((($x) != 0));
    }' unless defined(&IRQ_RETVAL);
    if(defined(&CONFIG_GENERIC_HARDIRQS)) {
    }
    unless(defined(&__ARCH_SET_SOFTIRQ_PENDING)) {
	eval 'sub set_softirq_pending {
	    local($x) = @_;
    	    eval q(( &local_softirq_pending() = ($x)));
	}' unless defined(&set_softirq_pending);
	eval 'sub or_softirq_pending {
	    local($x) = @_;
    	    eval q(( &local_softirq_pending() |= ($x)));
	}' unless defined(&or_softirq_pending);
    }
    unless(defined(&CONFIG_SMP)) {
	eval 'sub save_flags {
	    local($x) = @_;
    	    eval q( &save_flags($x));
	}' unless defined(&save_flags);
	eval 'sub save_and_cli {
	    local($x) = @_;
    	    eval q( &save_and_cli($x));
	}' unless defined(&save_and_cli);
    }
    eval 'sub local_bh_disable () {
        eval q( &do {  &add_preempt_count( &SOFTIRQ_OFFSET);  &barrier(); }  &while (0));
    }' unless defined(&local_bh_disable);
    eval 'sub __local_bh_enable () {
        eval q( &do {  &barrier();  &sub_preempt_count( &SOFTIRQ_OFFSET); }  &while (0));
    }' unless defined(&__local_bh_enable);
    eval("sub HI_SOFTIRQ () { 0; }") unless defined(&HI_SOFTIRQ);
    eval("sub TIMER_SOFTIRQ () { 1; }") unless defined(&TIMER_SOFTIRQ);
    eval("sub NET_TX_SOFTIRQ () { 2; }") unless defined(&NET_TX_SOFTIRQ);
    eval("sub NET_RX_SOFTIRQ () { 3; }") unless defined(&NET_RX_SOFTIRQ);
    eval("sub BLOCK_SOFTIRQ () { 4; }") unless defined(&BLOCK_SOFTIRQ);
    eval("sub TASKLET_SOFTIRQ () { 5; }") unless defined(&TASKLET_SOFTIRQ);
    eval 'sub __raise_softirq_irqoff {
        local($nr) = @_;
	    eval q( &do {  &or_softirq_pending(1 << ($nr)); }  &while (0));
    }' unless defined(&__raise_softirq_irqoff);
    eval 'sub DECLARE_TASKLET {
        local($name, $func, $data) = @_;
	    eval q(1;
    }' unless defined(&DECLARE_TASKLET);
    eval 'sub DECLARE_TASKLET_DISABLED {
        local($name, $func, $data) = @_;
	    eval q(1;
    }' unless defined(&DECLARE_TASKLET_DISABLED);
    eval("sub TASKLET_STATE_SCHED () { 0; }") unless defined(&TASKLET_STATE_SCHED);
    eval("sub TASKLET_STATE_RUN () { 1; }") unless defined(&TASKLET_STATE_RUN);
    if(defined(&CONFIG_SMP)) {
    } else {
	eval 'sub tasklet_trylock {
	    local($t) = @_;
    	    eval q(1);
	}' unless defined(&tasklet_trylock);
	eval 'sub tasklet_unlock_wait {
	    local($t) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&tasklet_unlock_wait);
	eval 'sub tasklet_unlock {
	    local($t) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&tasklet_unlock);
    }
    if(defined( &CONFIG_GENERIC_HARDIRQS)  && !defined( &CONFIG_GENERIC_IRQ_PROBE) ) {
    } else {
    }
}
1;
