require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_THREAD_INFO_H)) {
    eval 'sub __ASM_ARM_THREAD_INFO_H () {1;}' unless defined(&__ASM_ARM_THREAD_INFO_H);
    if(defined(&__KERNEL__)) {
	require 'linux/compiler.ph';
	require 'asm/fpstate.ph';
	eval 'sub THREAD_SIZE_ORDER () {1;}' unless defined(&THREAD_SIZE_ORDER);
	eval 'sub THREAD_SIZE () {8192;}' unless defined(&THREAD_SIZE);
	eval 'sub THREAD_START_SP () {( &THREAD_SIZE - 8);}' unless defined(&THREAD_START_SP);
	unless(defined(&__ASSEMBLY__)) {
	    require 'asm/ptrace.ph';
	    require 'asm/types.ph';
	    require 'asm/domain.ph';
	    eval 'sub INIT_THREAD_INFO {
	        local($tsk) = @_;
    		eval q({ . &task = $tsk, . &exec_domain =  &default_exec_domain, . &flags = 0, . &preempt_count = 1, . &addr_limit =  &KERNEL_DS, . &cpu_domain =  &domain_val( &DOMAIN_USER,  &DOMAIN_MANAGER) |  &domain_val( &DOMAIN_KERNEL,  &DOMAIN_MANAGER) |  &domain_val( &DOMAIN_IO,  &DOMAIN_CLIENT), . &restart_block = { . &fn =  &do_no_restart_syscall, }, });
	    }' unless defined(&INIT_THREAD_INFO);
	    eval 'sub init_thread_info () {( ($init_thread_union->{thread_info}));}' unless defined(&init_thread_info);
	    eval 'sub init_stack () {( ($init_thread_union->{stack}));}' unless defined(&init_stack);
	    eval 'sub thread_saved_pc {
	        local($tsk) = @_;
    		eval q((( &pc_pointer( &task_thread_info($tsk)-> ($cpu_context->{pc})))));
	    }' unless defined(&thread_saved_pc);
	    eval 'sub thread_saved_fp {
	        local($tsk) = @_;
    		eval q((( &task_thread_info($tsk)-> ($cpu_context->{fp}))));
	    }' unless defined(&thread_saved_fp);
	}
	eval 'sub PREEMPT_ACTIVE () {0x40000000;}' unless defined(&PREEMPT_ACTIVE);
	eval 'sub TIF_NOTIFY_RESUME () {0;}' unless defined(&TIF_NOTIFY_RESUME);
	eval 'sub TIF_SIGPENDING () {1;}' unless defined(&TIF_SIGPENDING);
	eval 'sub TIF_NEED_RESCHED () {2;}' unless defined(&TIF_NEED_RESCHED);
	eval 'sub TIF_SYSCALL_TRACE () {8;}' unless defined(&TIF_SYSCALL_TRACE);
	eval 'sub TIF_POLLING_NRFLAG () {16;}' unless defined(&TIF_POLLING_NRFLAG);
	eval 'sub TIF_USING_IWMMXT () {17;}' unless defined(&TIF_USING_IWMMXT);
	eval 'sub TIF_MEMDIE () {18;}' unless defined(&TIF_MEMDIE);
	eval 'sub _TIF_NOTIFY_RESUME () {(1<<  &TIF_NOTIFY_RESUME);}' unless defined(&_TIF_NOTIFY_RESUME);
	eval 'sub _TIF_SIGPENDING () {(1<<  &TIF_SIGPENDING);}' unless defined(&_TIF_SIGPENDING);
	eval 'sub _TIF_NEED_RESCHED () {(1<<  &TIF_NEED_RESCHED);}' unless defined(&_TIF_NEED_RESCHED);
	eval 'sub _TIF_SYSCALL_TRACE () {(1<<  &TIF_SYSCALL_TRACE);}' unless defined(&_TIF_SYSCALL_TRACE);
	eval 'sub _TIF_POLLING_NRFLAG () {(1<<  &TIF_POLLING_NRFLAG);}' unless defined(&_TIF_POLLING_NRFLAG);
	eval 'sub _TIF_USING_IWMMXT () {(1<<  &TIF_USING_IWMMXT);}' unless defined(&_TIF_USING_IWMMXT);
	eval 'sub _TIF_WORK_MASK () {0xff;}' unless defined(&_TIF_WORK_MASK);
    }
}
1;
