/* 
 * CyberLinkC AV API for Rendering Control Service
 *
 * crenderingcontrol.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license with patent exclusion,
 * see file COPYING.
 */

#ifndef CG_UPNP_AV_CRENDERINGCONTROL_H
#define CG_UPNP_AV_CRENDERINGCONTROL_H

#define CG_UPNP_RCS_SERVICE_TYPE "urn:schemas-upnp-org:service:RenderingControl"

/****************************************************************************
 * Mandatory Actions
 ****************************************************************************/
#define CG_UPNP_RCS_ACTION_LISTPRESETS "ListPresets"
#define CG_UPNP_RCS_ACTION_SELECTPRESET "SelectPreset"

/****************************************************************************
 * Optional Actions
 ****************************************************************************/

/****************************************************************************
 * Video 
 ****************************************************************************/
#define CG_UPNP_RCS_ACTION_GETBRIGHTNESS "GetBrightness"
#define CG_UPNP_RCS_ACTION_SETBRIGHTNESS "SetBrightness"

#define CG_UPNP_RCS_ACTION_GETCONTRAST "GetContrast"
#define CG_UPNP_RCS_ACTION_SETCONTRAST "SetContrast"

#define CG_UPNP_RCS_ACTION_GETSHARPNESS "GetSharpness"
#define CG_UPNP_RCS_ACTION_SETSHARPNESS "SetSharpness"

#define CG_UPNP_RCS_ACTION_GETREDVIDEOGAIN "GetRedVideoGain"
#define CG_UPNP_RCS_ACTION_SETREDVIDEOGAIN "SetRedVideoGain"

#define CG_UPNP_RCS_ACTION_GETGREENVIDEOGAIN "GetGreenVideoGain"
#define CG_UPNP_RCS_ACTION_SETGREENVIDEOGAIN "SetGreenVideoGain"

#define CG_UPNP_RCS_ACTION_GETBLUEVIDEOGAIN "GetBlueVideoGain"
#define CG_UPNP_RCS_ACTION_SETBLUEVIDEOGAIN "SetBlueVideoGain"

#define CG_UPNP_RCS_ACTION_GETREDVIDEOBLACKLEVEL "GetRedVideoBlackLevel"
#define CG_UPNP_RCS_ACTION_SETREDVIDEOBLACKLEVEL "SetRedVideoBlackLevel"

#define CG_UPNP_RCS_ACTION_GETGREENVIDEOBLACKLEVEL "GetGreenVideoBlackLevel"
#define CG_UPNP_RCS_ACTION_SETGREENVIDEOBLACKLEVEL "SetGreenVideoBlackLevel"

#define CG_UPNP_RCS_ACTION_GETBLUEVIDEOBLACKLEVEL "GetBlueVideoBlackLevel"
#define CG_UPNP_RCS_ACTION_SETBLUEVIDEOBLACKLEVEL "SetBlueVideoBlackLevel"

#define CG_UPNP_RCS_ACTION_GETCOLORTEMPERATURE "GetColorTemperature"
#define CG_UPNP_RCS_ACTION_SETCOLORTEMPERATURE "SetColorTemperature"

#define CG_UPNP_RCS_ACTION_GETHORIZONTALKEYSTONE "GetHorizontalKeystone"
#define CG_UPNP_RCS_ACTION_SETHORIZONTALKEYSTONE "SetHorizontalKeystone"

#define CG_UPNP_RCS_ACTION_GETVERTICALKEYSTONE "GetVerticalKeystone"
#define CG_UPNP_RCS_ACTION_SETVERTICALKEYSTONE "SetVerticalKeystone"

/****************************************************************************
 * Audio 
 ****************************************************************************/
#define CG_UPNP_RCS_ACTION_GETMUTE "GetMute"
#define CG_UPNP_RCS_ACTION_SETMUTE "SetMute"

#define CG_UPNP_RCS_ACTION_GETVOLUME "GetVolume"
#define CG_UPNP_RCS_ACTION_SETVOLUME "SetVolume"

#define CG_UPNP_RCS_ACTION_GETVOLUMEDB "GetVolumeDB"
#define CG_UPNP_RCS_ACTION_SETVOLUMEDB "SetVolumeDB"
#define CG_UPNP_RCS_ACTION_SETVOLUMEDBRANGE "SetVolumeDBRange"

#define CG_UPNP_RCS_ACTION_GETLOUDNESS "GetLoudness"
#define CG_UPNP_RCS_ACTION_SETLOUDNESS "SetLoudness"

#endif
