#ifndef __GDK_PROPERTY_H__
#define __GDK_PROPERTY_H__

#include <gdk/gdktypes.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef enum
{
  GDK_PROP_MODE_REPLACE,
  GDK_PROP_MODE_PREPEND,
  GDK_PROP_MODE_APPEND
} GdkPropMode;

GdkAtom gdk_atom_intern (const gchar *atom_name,
			 gboolean     only_if_exists);
/* Provide source compatible version to reduce porting effort.
 * GdkAtom gdk_atom_intern_static_string (const gchar *atom_name); */
#define gdk_atom_intern_static_string(x) gdk_atom_intern((x), FALSE)
gchar*  gdk_atom_name   (GdkAtom      atom);

gboolean gdk_property_get    (GdkWindow     *window,
			      GdkAtom        property,
			      GdkAtom        type,
			      gulong         offset,
			      gulong         length,
			      gint           pdelete,
			      GdkAtom       *actual_property_type,
			      gint          *actual_format,
			      gint          *actual_length,
			      guchar       **data);
void     gdk_property_change (GdkWindow     *window,
			      GdkAtom        property,
			      GdkAtom        type,
			      gint           format,
			      GdkPropMode    mode,
			      const guchar  *data,
			      gint           nelements);
void     gdk_property_delete (GdkWindow     *window,
			      GdkAtom        property);
#ifndef GDK_MULTIHEAD_SAFE
gint gdk_text_property_to_text_list (GdkAtom        encoding,
				     gint           format,
				     const guchar  *text,
				     gint           length,
				     gchar       ***list);
gint gdk_text_property_to_utf8_list (GdkAtom        encoding,
				     gint           format,
				     const guchar  *text,
				     gint           length,
				     gchar       ***list);
gboolean gdk_utf8_to_compound_text (const gchar *str,
				    GdkAtom     *encoding,
				    gint        *format,
				    guchar     **ctext,
				    gint        *length);
gint gdk_string_to_compound_text    (const gchar   *str,
				     GdkAtom       *encoding,
				     gint          *format,
				     guchar       **ctext,
				     gint          *length);
#endif

gint gdk_text_property_to_text_list_for_display (GdkDisplay     *display,
						 GdkAtom         encoding,
						 gint            format,
						 const guchar   *text,
						 gint            length,
						 gchar        ***list);
gint gdk_text_property_to_utf8_list_for_display (GdkDisplay     *display,
						 GdkAtom         encoding,
						 gint            format,
						 const guchar   *text,
						 gint            length,
						 gchar        ***list);
  
gchar   *gdk_utf8_to_string_target   (const gchar *str);
gint     gdk_string_to_compound_text_for_display (GdkDisplay   *display,
						  const gchar  *str,
						  GdkAtom      *encoding,
						  gint         *format,
						  guchar      **ctext,
						  gint         *length);
gboolean gdk_utf8_to_compound_text_for_display   (GdkDisplay   *display,
						  const gchar  *str,
						  GdkAtom      *encoding,
						  gint         *format,
						  guchar      **ctext,
						  gint         *length);

void gdk_free_text_list             (gchar        **list);
void gdk_free_compound_text         (guchar        *ctext);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GDK_PROPERTY_H__ */
