/* 
 * CyberLinkC AV API for Connection Manager Service
 *
 * ccmsactionarguments.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license with patent exclusion,
 * see file COPYING.
 */
 
#ifndef CG_UPNP_AV_CCMSACTIONARGUMENTS_H
#define CG_UPNP_AV_CCMSACTIONARGUMENTS_H

/****************************************************************************
 * Action arguments
 ****************************************************************************/

#define CG_UPNP_CMS_ARG_SOURCE "Source"
#define CG_UPNP_CMS_ARG_SINK "Sink"

#define CG_UPNP_CMS_ARG_REMOTEPROTOCOLINFO "RemoteProtocolInfo"

#define CG_UPNP_CMS_ARG_PEERCONNECTIONMANAGER "PeerConnectionManager"
#define CG_UPNP_CMS_ARG_PEERCONNECTIONID "PeerConnectionID"
#define CG_UPNP_CMS_ARG_CONNECTIONID "ConnectionID"

#define CG_UPNP_CMS_ARG_DIRECTION "Direction"
#define CG_UPNP_CMS_ARG_AV_TRNSPORTID "AVTransportID"
#define CG_UPNP_CMS_ARG_RCSID "RcsID"

#define CG_UPNP_CMS_ARG_STATUS "Status"

/****************************************************************************
 * Action parameters
 ****************************************************************************/

/****************************************************************************
 * Connection Status parameters
 ****************************************************************************/
#define CG_UPNP_CMS_CONNECTIONSTATUS_OK "OK"
#define CG_UPNP_CMS_CONNECTIONSTATUS_CONTENTFORMATMISMATCH "ContentFormatMismatch"
#define CG_UPNP_CMS_CONNECTIONSTATUS_INSUFFICIENTBANDWIDTH "InsufficientBandwidth"
#define CG_UPNP_CMS_CONNECTIONSTATUS_UNRELIABLECHANNEL "UnreliableChannel"
#define CG_UPNP_CMS_CONNECTIONSTATUS_UNKNOWN "Unknown"

/****************************************************************************
 * Direction parameters
 ****************************************************************************/

#define CG_UPNP_CMS_DIRECTION_INPUT "Input"
#define CG_UPNP_CMS_DIRECTION_OUTPUT "Output"

#endif
