/* gtktextbufferserialize.h
 *
 * Copyright (C) 2004 Nokia Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef GTK_TEXT_BUFFER_SERIALIZE_H

#include <gtk/gtktextbuffer.h>

gchar *gtk_text_buffer_serialize_rich_text (GtkTextBuffer     *buffer,
					    const GtkTextIter *start,
					    const GtkTextIter *end,
					    gint              *len);

gboolean gtk_text_buffer_deserialize_rich_text (GtkTextBuffer *buffer,
						GtkTextIter   *iter,
						const gchar   *text,
						gint           len,
						gboolean       create_tags,
						GError       **error);


#endif /* GTK_TEXT_BUFFER_SERIALIZE_H */
