/* 
 * CyberLinkC AV API for Control Points
 *
 * crcsactionarguments.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license with patent exclusion,
 * see file COPYING.
 */

#ifndef CG_UPNP_AV_CRCSACTIONARGUMENTS_H
#define CG_UPNP_AV_CRCSACTIONARGUMENTS_H

/* Generic Rendering Control Instance ID */
#define CG_UPNP_RCS_ARG_INSTANCEID "InstanceID"

/****************************************************************************
 * Presets
 ****************************************************************************/
#define CG_UPNP_RCS_ARG_CURRENTPRESETNAMELIST "CurrentPresetNameList"
#define CG_UPNP_RCS_ARG_PRESETNAME "PresetName"

/****************************************************************************
 * Video
 ****************************************************************************/
#define CG_UPNP_RCS_ARG_CURRENTBRIGHTNESS "CurrentBrightness"
#define CG_UPNP_RCS_ARG_DESIREDBRIGHTNESS "DesiredBrighness"

#define CG_UPNP_RCS_ARG_CURRENTCONTRAST "CurrentContrast"
#define CG_UPNP_RCS_ARG_DESIREDCONTRAST "DesiredContrast"

#define CG_UPNP_RCS_ARG_GETSHARPNESS "GetSharpness"
#define CG_UPNP_RCS_ARG_SETSHARPNESS "SetSharpness"

#define CG_UPNP_RCS_ARG_CURRENTREDVIDEOGAIN "CurrentRedVideoGain"
#define CG_UPNP_RCS_ARG_DESIREDREDVIDEOGAIN "DesiredRedVideoGain"

#define CG_UPNP_RCS_ARG_CURRENTGREENVIDEOGAIN "CurrentGreenVideoGain"
#define CG_UPNP_RCS_ARG_DESIREDGREENVIDEOGAIN "DesiredGreenVideoGain"

#define CG_UPNP_RCS_ARG_CURRENTBLUEVIDEOGAIN "CurrentBlueVideoGain"
#define CG_UPNP_RCS_ARG_DESIREDBLUEVIDEOGAIN "DesiredBlueVideoGain"

#define CG_UPNP_RCS_ARG_CURRENTREDVIDEOBLACKLEVEL "CurrentRedVideoBlackLevel"
#define CG_UPNP_RCS_ARG_DESIREDREDVIDEOBLACKLEVEL "DesiredRedVideoBlackLevel"

#define CG_UPNP_RCS_ARG_CURRENTGREENVIDEOBLACKLEVEL "CurrentGreenVideoBlackLevel"
#define CG_UPNP_RCS_ARG_DESIREDGREENVIDEOBLACKLEVEL "DesiredGreenVideoBlackLevel"

#define CG_UPNP_RCS_ARG_CURRENTBLUEVIDEOBLACKLEVEL "CurrentBlueVideoBlackLevel"
#define CG_UPNP_RCS_ARG_DESIREDBLUEVIDEOBLACKLEVEL "DesiredBlueVideoBlackLevel"

#define CG_UPNP_RCS_ARG_CURRENTCOLORTEMPERATURE "CurrentColorTemperature"
#define CG_UPNP_RCS_ARG_DESIREDCOLORTEMPERATURE "DesiredColorTemperature"

#define CG_UPNP_RCS_ARG_CURRENTHORIZONTALKEYSTONE "CurrentHorizontalKeystone"
#define CG_UPNP_RCS_ARG_DESIREDHORIZONTALKEYSTONE "DesiredHorizontalKeystone"

#define CG_UPNP_RCS_ARG_CURRENTVERTICALKEYSTONE "CurrentVerticalKeystone"
#define CG_UPNP_RCS_ARG_DESIREDVERTICALKEYSTONE "DesiredVerticalKeystone"

/****************************************************************************
 * Audio
 ****************************************************************************/
#define CG_UPNP_RCS_ARG_CHANNEL "Channel"

#define CG_UPNP_RCS_ARG_MINVALUE "MinValue"
#define CG_UPNP_RCS_ARG_MAXVALUE "MaxValue"

#define CG_UPNP_RCS_ARG_CURRENTMUTE "CurrentMute"
#define CG_UPNP_RCS_ARG_DESIREDMUTE "DesiredMute"

#define CG_UPNP_RCS_ARG_CURRENTVOLUME "CurrentVolume"
#define CG_UPNP_RCS_ARG_DESIREDVOLUME "DesiredVolume"

#define CG_UPNP_RCS_ARG_CURRENTVOLUMEDB "CurrentVolumeDB"
#define CG_UPNP_RCS_ARG_DESIREDVOLUMEDB "DesiredVolumeDB"

#define CG_UPNP_RCS_ARG_CURRENTLOUDNESS "CurrentLoudness"
#define CG_UPNP_RCS_ARG_DESIREDLOUDNESS "DesiredLoudness"

/****************************************************************************
 * Audio channels
 ****************************************************************************/
#define CG_UPNP_RCS_ARG_CHANNEL_MASTER "Master"
#define CG_UPNP_RCS_ARG_CHANNEL_LEFTFRONT "LF"
#define CG_UPNP_RCS_ARG_CHANNEL_RIGHTFRONT "RF"
#define CG_UPNP_RCS_ARG_CHANNEL_CENTERFRONT "CF"
#define CG_UPNP_RCS_ARG_CHANNEL_LOWFREQUENCYEFFECT "LFE"
#define CG_UPNP_RCS_ARG_CHANNEL_LEFTSURROUND "LS"
#define CG_UPNP_RCS_ARG_CHANNEL_RIGHTSURROUND "RS"
#define CG_UPNP_RCS_ARG_CHANNEL_LEFTOFCENTER "LFC"
#define CG_UPNP_RCS_ARG_CHANNEL_RIGHTOFCENTER "RFC"
#define CG_UPNP_RCS_ARG_CHANNEL_SURROUND "SD"
#define CG_UPNP_RCS_ARG_CHANNEL_SIDELEFT "SL"
#define CG_UPNP_RCS_ARG_CHANNEL_SIDERIGHT "SR"
#define CG_UPNP_RCS_ARG_CHANNEL_TOP "T"
#define CG_UPNP_RCS_ARG_CHANNEL_BOTTOM "B"

/****************************************************************************
 * Preset definitions
 ****************************************************************************/
#define CG_UPNP_RCS_ARG_PRESET_FACTORYDEFAULTS "FactoryDefaults"
#define CG_UPNP_RCS_ARG_PRESET_INSTALLATIONDEFAULTS "InstallationDefaults"

#endif
