# -*- mode: makefile; coding: utf-8 -*-
# Copyright © 2002,2003 Colin Walters <walters@debian.org>
# Description: A class to automatically update GNU autotools files
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# 02111-1307 USA.


ifndef _cdbs_bootstrap
_cdbs_scripts_path ?= /usr/lib/cdbs
_cdbs_rules_path ?= /usr/share/cdbs/1/rules
_cdbs_class_path ?= /usr/share/cdbs/1/class
endif

ifndef _cdbs_class_autotools_files
_cdbs_class_autotools_files := 1

include $(_cdbs_class_path)/autotools-vars.mk$(_cdbs_makefile_suffix)
include /usr/share/debian-dir/make.inc

# Compatibility blurb, will be eventualy removed
ifneq ($(DEB_AUTO_UPDATE_AUTOMAKE), )
ifeq ($(DEB_AUTO_UPDATE_ACLOCAL), )
$(warning WARNING: DEB_AUTO_UPDATE_AUTOMAKE will eventualy stop impliing DEB_AUTO_UPDATE_ACLOCAL.  If you meant aclocal.m4 to be re-generated, please use DEB_AUTO_UPDATE_ACLOCAL.)
DEB_AUTO_UPDATE_ACLOCAL = $(DEB_AUTO_UPDATE_AUTOMAKE)
endif
endif

# Some update rules are useless on their own
ifeq ($(DEB_AUTO_UPDATE_LIBTOOL), pre)
ifeq ($(DEB_AUTO_UPDATE_ACLOCAL), )
$(warning WARNING: DEB_AUTO_UPDATE_LIBTOOL requires DEB_AUTO_UPDATE_ACLOCAL.)
endif
endif
ifneq ($(DEB_AUTO_UPDATE_ACLOCAL), )
ifeq ($(DEB_AUTO_UPDATE_AUTOCONF), )
$(warning WARNING: DEB_AUTO_UPDATE_ACLOCAL requires DEB_AUTO_UPDATE_AUTOCONF.)
endif
endif

common-configure-arch common-configure-indep:: $(DEBIAN_DIR)/stamp-autotools-files
$(DEBIAN_DIR)/stamp-autotools-files:
	if test "$(DEB_AUTO_UPDATE_LIBTOOL)" = "pre" ; then \
		cd $(DEB_SRCDIR) && libtoolize -c -f ; \
	fi
	if test -n "$(DEB_AUTO_UPDATE_ACLOCAL)" ; then \
		if test -d $(DEB_SRCDIR)/m4 ; then m4="-I m4" ; fi ; \
		if test -e $(DEB_SRCDIR)/aclocal.m4 ; then cd $(DEB_SRCDIR) && aclocal-$(DEB_AUTO_UPDATE_ACLOCAL) $$m4 ; fi ; \
	elif test -n "$(DEB_AUTO_UPDATE_AUTOMAKE)" ; then \
		if test -d $(DEB_SRCDIR)/m4 ; then m4="-I m4" ; fi ; \
		if test -e $(DEB_SRCDIR)/aclocal.m4 ; then cd $(DEB_SRCDIR) && aclocal-$(DEB_AUTO_UPDATE_AUTOMAKE) $$m4 ; fi ; \
	fi
	if test -n "$(DEB_AUTO_UPDATE_AUTOCONF)" ; then \
		if test -e $(DEB_SRCDIR)/configure.ac || test -e $(DEB_SRCDIR)/configure.in ; then cd $(DEB_SRCDIR) && `which autoconf$(DEB_AUTO_UPDATE_AUTOCONF) || which autoconf` ; fi ; \
	fi
	if test -n "$(DEB_AUTO_UPDATE_AUTOHEADER)" ; then \
		if test -e $(DEB_SRCDIR)/configure.ac || test -e $(DEB_SRCDIR)/configure.in ; then cd $(DEB_SRCDIR) && `which autoheader$(DEB_AUTO_UPDATE_AUTOHEADER) || which autoheader` ; fi ; \
	fi
	if test -n "$(DEB_AUTO_UPDATE_AUTOMAKE)" ; then \
		if test -e $(DEB_SRCDIR)/Makefile.am ; then cd $(DEB_SRCDIR) && automake-$(DEB_AUTO_UPDATE_AUTOMAKE) ; fi ; \
	fi
	touch $(DEBIAN_DIR)/stamp-autotools-files

clean::
	if [ -f "$(DEB_BUILDDIR)/config.log" ] && grep -i 'generated.*by.*autoconf' "$(DEB_BUILDDIR)/config.log" 1>/dev/null; then \
	  rm -f "$(DEB_BUILDDIR)/config.log"; \
	fi
	rm -f $(DEBIAN_DIR)/stamp-autotools-files

endif
