/*
 * Maemo Games Startup Example
 * Copyright (c) 2006 INdT.
 * @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
 /**
  @file plugin.c

  Example plugin implementation
  <p>
  Copyright (c) 2006 INdT. All rights reserved.

  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
*/

#include <stdio.h>
#include <gtk/gtk.h>
#include <startup_plugin.h>


static GtkWidget *load_plugin      (void);
static void       unload_plugin    (void);
static void       write_config     (void);
static GtkWidget **load_menu       (guint *);
static void       update_menu      (void);

GConfClient *gcc = NULL;

static StartupPluginInfo 
plugin_info = {
  load_plugin,
  unload_plugin,
  write_config,
  load_menu,
  update_menu,
  NULL
};

static GameStartupInfo gs;
STARTUP_INIT_PLUGIN(plugin_info, gs, FALSE, FALSE)

static GtkWidget **
load_menu (guint *nitems) {
    return NULL;
}

static void 
update_menu (void)
{
    return;
}


static GtkWidget *
load_plugin (void)
{
  GtkWidget *game_hbox;
  GtkWidget *difficult_hbox;
  GtkWidget *difficult_label;
  GtkWidget *difficult_box;
  GtkWidget *sound_hbox;
  GtkWidget *sound_check;
  GtkWidget *sound_label;
 
  fprintf (stderr, "%s (%d)\n", __FUNCTION__, __LINE__);
  
  game_hbox = gtk_hbox_new (TRUE, 0);
  g_assert (game_hbox);

  difficult_hbox = gtk_hbox_new (FALSE, 8);
  
  difficult_box = gtk_combo_box_new_text ();
  g_assert (difficult_box);

  gtk_combo_box_append_text (GTK_COMBO_BOX (difficult_box),
    "Easy");
  gtk_combo_box_append_text (GTK_COMBO_BOX (difficult_box),
    "Normal");
  gtk_combo_box_append_text (GTK_COMBO_BOX (difficult_box),
    "Hard");
  gtk_combo_box_set_active (GTK_COMBO_BOX (difficult_box), 0);

  gtk_widget_set_size_request (difficult_box,
    200, -1);
  gtk_box_pack_end (GTK_BOX (difficult_hbox),
    difficult_box, FALSE, FALSE, 0);

  difficult_label = gtk_label_new ("Difficult level:");
  g_assert(difficult_label);

  gtk_box_pack_end (GTK_BOX (difficult_hbox),
    difficult_label, FALSE, FALSE, 0);

  gtk_box_pack_start (GTK_BOX (game_hbox),
    difficult_hbox, FALSE, FALSE, 2);

  sound_hbox = gtk_hbox_new (FALSE, 8);
  
  sound_check = gtk_check_button_new ();
  g_assert (sound_check);

  gtk_box_pack_start (GTK_BOX (sound_hbox),
    sound_check, FALSE, FALSE, 0);

  sound_label = gtk_label_new ("Enable Sounds");
  g_assert (sound_label);

  gtk_box_pack_start (GTK_BOX (sound_hbox),
    sound_label, FALSE, FALSE, 0);
 
  gtk_box_pack_start (GTK_BOX (game_hbox),
    sound_hbox, FALSE, FALSE, 2);
 
  return game_hbox;
}

static void
unload_plugin (void)
{
  fprintf (stderr, "%s (%d)\n", __FUNCTION__, __LINE__);
}

static void 
write_config (void)
{
  fprintf (stderr, "%s (%d)\n", __FUNCTION__, __LINE__);
}

