# -*- mode: makefile; coding: utf-8 -*-
# This file is part of CDBS
#
# Copyright (C) 2006 Nokia Corporation. All rights reserved.
#
# Contact: Eero Häkkinen <eero.hakkinen@nokia.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License 
# version 2 or (at your option) any later version
# as published by the Free Software Foundation. 
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301 USA

ifndef _cdbs_bootstrap
_cdbs_scripts_path ?= /usr/lib/cdbs
_cdbs_rules_path ?= /usr/share/cdbs/1/rules
_cdbs_class_path ?= /usr/share/cdbs/1/class
endif

ifndef _cdbs_class_parallel
_cdbs_class_parallel := 1

include $(_cdbs_class_path)/makefile-vars.mk$(_cdbs_makefile_suffix)

ifneq (,$(findstring parallel,$(DEB_BUILD_OPTIONS)))
DEB_MAKE_JOBS := $(shell ( \
	set -- $(DEB_BUILD_OPTIONS); \
	expr x"$$*" : x'.*parallel=\([0-9][0-9]*\)'     \
	|| grep -c ^processor /proc/cpuinfo 2>/dev/null \
	) | sed -e '/[123456789]/!d' -e 'q' )
endif

endif
