/*
 * This file is part of osso-dsp-headers-su-18
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Markku Vorne <markku.vorne@nokia.com>
 *
 * This software, including documentation, is protected by copyright controlled by Nokia Corporation. All rights are reserved.
 * Copying, including reproducing, storing, adapting or translating, any or all of this material requires the prior written  
 * consent of Nokia Corporation. This material also contains confidential information which may not be disclosed to others 
 * without the prior written consent of Nokia.
 */

#ifndef __VIDEO_DSPTASK_H__
#define __VIDEO_DSPTASK_H__

#define DSP_CMD_VIDEO_SET_LOCKEDRATIO      0x100 // Set locked ratio to 'yes'.
#define DSP_CMD_VIDEO_RESET_LOCKEDRATIO    0x101 // Set locked ratio to 'no'.
#define DSP_CMD_VIDEO_SET_MIRROR           0x102 // Set mirror to 'yes'.
#define DSP_CMD_VIDEO_RESET_MIRROR         0x103 // Set mirror to 'no'.
#define DSP_CMD_VIDEO_ROTATION_0           0x104 // Set rotation to 0 degrees.
#define DSP_CMD_VIDEO_ROTATION_90          0x105 // Set rotation to 90 degrees.
#define DSP_CMD_VIDEO_ROTATION_180         0x106 // Set rotation to 180 degrees.
#define DSP_CMD_VIDEO_ROTATION_270         0x107 // Set rotation to 270 degrees.

/* Video error values. */
#define DSP_ERROR_VIDEO_NON_COMPLIANT      0x100 // Stream is not compliant with
                                                 // supported format.
#define DSP_ERROR_VIDEO_FAULT_IN_VOS       0x101 // Fault in video object sequence
#define DSP_ERROR_VIDEO_SIZE_NOT_SUPPORTED 0x102 // Frame size is not supported.
#define DSP_ERROR_VIDEO_VOS_END_CODE       0x103 // End of video object sequence 
                                                 // code reached.
typedef struct video_init_status {
    unsigned short int dsp_cmd;
    unsigned short int init_status;
    unsigned short int bridge_buffer_size;
    unsigned short int mmap_buffer_size;
} VIDEO_INIT_STATUS;

/* DSP video task initialisation data. */
typedef struct video_params_data {
    unsigned short int dsp_cmd;
    unsigned long int  fbuf_address;
    unsigned short int fbuf_height;
    unsigned short int fbuf_width;
    unsigned short int fbuf_bpp;
    unsigned short int fbuf_orientation;
    unsigned short int outImagePos_x;
    unsigned short int outImagePos_y;
    unsigned short int outImageHeight;
    unsigned short int outImageWidth;
    unsigned short int inImageHeight;
    unsigned short int inImageWidth;
    unsigned short int input_video_fmt;
    unsigned short int output_video_fmt;
    unsigned short int audio_strm_ID;
    unsigned short int framebyframe;
    unsigned short int synconarm;
} VIDEO_PARAMS_DATA;

typedef struct video_status_data {
    unsigned short int dsp_cmd;
    unsigned short int node_state;
    unsigned short int input_video_fmt;
    unsigned short int output_video_fmt;
    unsigned long int  frame_count;
    unsigned short int outImagePos_x;
    unsigned short int outImagePos_y;
    unsigned short int outImageHeight;
    unsigned short int outImageWidth;
    unsigned short int inImageHeight;
    unsigned short int inImageWidth;
    unsigned short int locked_ratio;
    unsigned short int mirror;
    unsigned short int rotation;
    unsigned short int zoom_factor;
    unsigned short int frames_per_second;
    unsigned short int audio_strm_ID;
    unsigned long int  skipped_frame_count;
} VIDEO_STATUS_DATA;

typedef struct video_data_write {
    unsigned short int dsp_cmd;
    unsigned short int mmap_buf_info;
    unsigned long int  time_stamp;
} VIDEO_DATA_WRITE;

typedef struct video_write_status {
    unsigned short int dsp_cmd;
    unsigned short int status;
    unsigned short int mmap_buf_info;
} VIDEO_WRITE_STATUS;

#endif // #ifndef __VIDEO_DSPTASK_H__
