# -*- mode: makefile; coding: utf-8 -*-
# Copyright © 2003 Stefan Gybas <sgybas@debian.org>
# Description: Builds and cleans packages which have an Ant build.xml file
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# 02111-1307 USA.


ifndef _cdbs_bootstrap
_cdbs_scripts_path ?= /scratchbox/devkits/debian/libexec
_cdbs_rules_path ?= /scratchbox/devkits/debian/share/cdbs/1/rules
_cdbs_class_path ?= /scratchbox/devkits/debian/share/cdbs/1/class
endif

ifndef _cdbs_class_ant
_cdbs_class_ant := 1

include $(_cdbs_rules_path)/buildcore.mk$(_cdbs_makefile_suffix)
include $(_cdbs_class_path)/ant-vars.mk$(_cdbs_makefile_suffix)

DEB_PHONY_RULES += ant-sanity-check

ant-sanity-check:
	@if ! test -x "$(JAVACMD)"; then \
		echo "You must specify a valid JAVA_HOME or JAVACMD!"; \
		exit 1; \
	fi
	@if ! test -r "$(ANT_HOME)/lib/ant.jar"; then \
		echo "You must specify a valid ANT_HOME directory!"; \
		exit 1; \
	fi


common-build-arch common-build-indep:: debian/stamp-ant-build ant-sanity-check
debian/stamp-ant-build:
	$(DEB_ANT_INVOKE) $(DEB_ANT_BUILD_TARGET)
	touch debian/stamp-ant-build

clean:: ant-sanity-check
	$(DEB_ANT_INVOKE) $(DEB_ANT_CLEAN_TARGET) || true
	rm -f debian/stamp-ant-build

common-install-arch common-install-indep:: common-install-impl
common-install-impl::
	@if test -n "$(DEB_ANT_INSTALL_TARGET)"; then \
	  echo $(DEB_ANT_INVOKE) $(DEB_ANT_INSTALL_TARGET); \
	  $(DEB_ANT_INVOKE) $(DEB_ANT_INSTALL_TARGET); \
	 else \
	   echo "DEB_ANT_INSTALL_TARGET unset, skipping default ant.mk common-install target"; \
	 fi

ifeq (,$(findstring nocheck,$(DEB_BUILD_OPTIONS)))
common-post-build-arch common-post-build-indep:: common-post-build-impl
common-post-build-impl::
	@if test -n "$(DEB_ANT_CHECK_TARGET)"; then \
	  echo $(DEB_ANT_INVOKE) $(DEB_ANT_CHECK_TARGET); \
	  $(DEB_ANT_INVOKE) $(DEB_ANT_CHECK_TARGET); \
	else \
	   echo "DEB_ANT_CHECK_TARGET unset, not running checks"; \
	fi
endif

endif
