require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_SPINLOCK_API_UP_H)) {
    eval 'sub __LINUX_SPINLOCK_API_UP_H () {1;}' unless defined(&__LINUX_SPINLOCK_API_UP_H);
    unless(defined(&__LINUX_SPINLOCK_H)) {
	die("please don't include this file directly");
    }
    eval 'sub in_lock_functions {
        local($ADDR) = @_;
	    eval q(0);
    }' unless defined(&in_lock_functions);
    eval 'sub assert_spin_locked {
        local($lock) = @_;
	    eval q( &do { ($lock); }  &while (0));
    }' unless defined(&assert_spin_locked);
    eval 'sub __LOCK {
        local($lock) = @_;
	    eval q( &do {  &preempt_disable();  &__acquire; ($lock); }  &while (0));
    }' unless defined(&__LOCK);
    eval 'sub __LOCK_BH {
        local($lock) = @_;
	    eval q( &do {  &local_bh_disable();  &__LOCK($lock); }  &while (0));
    }' unless defined(&__LOCK_BH);
    eval 'sub __LOCK_IRQ {
        local($lock) = @_;
	    eval q( &do {  &local_irq_disable();  &__LOCK($lock); }  &while (0));
    }' unless defined(&__LOCK_IRQ);
    eval 'sub __LOCK_IRQSAVE {
        local($lock, $flags) = @_;
	    eval q( &do {  &local_irq_save($flags);  &__LOCK($lock); }  &while (0));
    }' unless defined(&__LOCK_IRQSAVE);
    eval 'sub __UNLOCK {
        local($lock) = @_;
	    eval q( &do {  &preempt_enable();  &__release; ($lock); }  &while (0));
    }' unless defined(&__UNLOCK);
    eval 'sub __UNLOCK_BH {
        local($lock) = @_;
	    eval q( &do {  &preempt_enable_no_resched();  &local_bh_enable();  &__release; ($lock); }  &while (0));
    }' unless defined(&__UNLOCK_BH);
    eval 'sub __UNLOCK_IRQ {
        local($lock) = @_;
	    eval q( &do {  &local_irq_enable();  &__UNLOCK($lock); }  &while (0));
    }' unless defined(&__UNLOCK_IRQ);
    eval 'sub __UNLOCK_IRQRESTORE {
        local($lock, $flags) = @_;
	    eval q( &do {  &local_irq_restore($flags);  &__UNLOCK($lock); }  &while (0));
    }' unless defined(&__UNLOCK_IRQRESTORE);
    eval 'sub _spin_lock {
        local($lock) = @_;
	    eval q( &__LOCK($lock));
    }' unless defined(&_spin_lock);
    eval 'sub _read_lock {
        local($lock) = @_;
	    eval q( &__LOCK($lock));
    }' unless defined(&_read_lock);
    eval 'sub _write_lock {
        local($lock) = @_;
	    eval q( &__LOCK($lock));
    }' unless defined(&_write_lock);
    eval 'sub _spin_lock_bh {
        local($lock) = @_;
	    eval q( &__LOCK_BH($lock));
    }' unless defined(&_spin_lock_bh);
    eval 'sub _read_lock_bh {
        local($lock) = @_;
	    eval q( &__LOCK_BH($lock));
    }' unless defined(&_read_lock_bh);
    eval 'sub _write_lock_bh {
        local($lock) = @_;
	    eval q( &__LOCK_BH($lock));
    }' unless defined(&_write_lock_bh);
    eval 'sub _spin_lock_irq {
        local($lock) = @_;
	    eval q( &__LOCK_IRQ($lock));
    }' unless defined(&_spin_lock_irq);
    eval 'sub _read_lock_irq {
        local($lock) = @_;
	    eval q( &__LOCK_IRQ($lock));
    }' unless defined(&_read_lock_irq);
    eval 'sub _write_lock_irq {
        local($lock) = @_;
	    eval q( &__LOCK_IRQ($lock));
    }' unless defined(&_write_lock_irq);
    eval 'sub _spin_lock_irqsave {
        local($lock, $flags) = @_;
	    eval q( &__LOCK_IRQSAVE($lock, $flags));
    }' unless defined(&_spin_lock_irqsave);
    eval 'sub _read_lock_irqsave {
        local($lock, $flags) = @_;
	    eval q( &__LOCK_IRQSAVE($lock, $flags));
    }' unless defined(&_read_lock_irqsave);
    eval 'sub _write_lock_irqsave {
        local($lock, $flags) = @_;
	    eval q( &__LOCK_IRQSAVE($lock, $flags));
    }' unless defined(&_write_lock_irqsave);
    eval 'sub _spin_trylock {
        local($lock) = @_;
	    eval q(({  &__LOCK($lock); 1; }));
    }' unless defined(&_spin_trylock);
    eval 'sub _read_trylock {
        local($lock) = @_;
	    eval q(({  &__LOCK($lock); 1; }));
    }' unless defined(&_read_trylock);
    eval 'sub _write_trylock {
        local($lock) = @_;
	    eval q(({  &__LOCK($lock); 1; }));
    }' unless defined(&_write_trylock);
    eval 'sub _spin_trylock_bh {
        local($lock) = @_;
	    eval q(({  &__LOCK_BH($lock); 1; }));
    }' unless defined(&_spin_trylock_bh);
    eval 'sub _spin_unlock {
        local($lock) = @_;
	    eval q( &__UNLOCK($lock));
    }' unless defined(&_spin_unlock);
    eval 'sub _read_unlock {
        local($lock) = @_;
	    eval q( &__UNLOCK($lock));
    }' unless defined(&_read_unlock);
    eval 'sub _write_unlock {
        local($lock) = @_;
	    eval q( &__UNLOCK($lock));
    }' unless defined(&_write_unlock);
    eval 'sub _spin_unlock_bh {
        local($lock) = @_;
	    eval q( &__UNLOCK_BH($lock));
    }' unless defined(&_spin_unlock_bh);
    eval 'sub _write_unlock_bh {
        local($lock) = @_;
	    eval q( &__UNLOCK_BH($lock));
    }' unless defined(&_write_unlock_bh);
    eval 'sub _read_unlock_bh {
        local($lock) = @_;
	    eval q( &__UNLOCK_BH($lock));
    }' unless defined(&_read_unlock_bh);
    eval 'sub _spin_unlock_irq {
        local($lock) = @_;
	    eval q( &__UNLOCK_IRQ($lock));
    }' unless defined(&_spin_unlock_irq);
    eval 'sub _read_unlock_irq {
        local($lock) = @_;
	    eval q( &__UNLOCK_IRQ($lock));
    }' unless defined(&_read_unlock_irq);
    eval 'sub _write_unlock_irq {
        local($lock) = @_;
	    eval q( &__UNLOCK_IRQ($lock));
    }' unless defined(&_write_unlock_irq);
    eval 'sub _spin_unlock_irqrestore {
        local($lock, $flags) = @_;
	    eval q( &__UNLOCK_IRQRESTORE($lock, $flags));
    }' unless defined(&_spin_unlock_irqrestore);
    eval 'sub _read_unlock_irqrestore {
        local($lock, $flags) = @_;
	    eval q( &__UNLOCK_IRQRESTORE($lock, $flags));
    }' unless defined(&_read_unlock_irqrestore);
    eval 'sub _write_unlock_irqrestore {
        local($lock, $flags) = @_;
	    eval q( &__UNLOCK_IRQRESTORE($lock, $flags));
    }' unless defined(&_write_unlock_irqrestore);
}
1;
