require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_QUOTA_)) {
    eval 'sub _LINUX_QUOTA_ () {1;}' unless defined(&_LINUX_QUOTA_);
    require 'linux/errno.ph';
    require 'linux/types.ph';
    require 'linux/spinlock.ph';
    eval 'sub __DQUOT_VERSION__ () {"dquot_6.5.1";}' unless defined(&__DQUOT_VERSION__);
    eval 'sub __DQUOT_NUM_VERSION__ () {6*10000+5*100+1;}' unless defined(&__DQUOT_NUM_VERSION__);
    eval 'sub QUOTABLOCK_BITS () {10;}' unless defined(&QUOTABLOCK_BITS);
    eval 'sub QUOTABLOCK_SIZE () {(1<<  &QUOTABLOCK_BITS);}' unless defined(&QUOTABLOCK_SIZE);
    eval 'sub qb2kb {
        local($x) = @_;
	    eval q((($x) << ( &QUOTABLOCK_BITS-10)));
    }' unless defined(&qb2kb);
    eval 'sub kb2qb {
        local($x) = @_;
	    eval q((($x) >> ( &QUOTABLOCK_BITS-10)));
    }' unless defined(&kb2qb);
    eval 'sub toqb {
        local($x) = @_;
	    eval q(((($x) +  &QUOTABLOCK_SIZE - 1) >>  &QUOTABLOCK_BITS));
    }' unless defined(&toqb);
    eval 'sub MAXQUOTAS () {2;}' unless defined(&MAXQUOTAS);
    eval 'sub USRQUOTA () {0;}' unless defined(&USRQUOTA);
    eval 'sub GRPQUOTA () {1;}' unless defined(&GRPQUOTA);
    eval 'sub INITQFNAMES () {{ "user", "group", "undefined", };;}' unless defined(&INITQFNAMES);
    eval 'sub SUBCMDMASK () {0xff;}' unless defined(&SUBCMDMASK);
    eval 'sub SUBCMDSHIFT () {8;}' unless defined(&SUBCMDSHIFT);
    eval 'sub QCMD {
        local($cmd, $type) = @_;
	    eval q(((($cmd) <<  &SUBCMDSHIFT) | (($type) &  &SUBCMDMASK)));
    }' unless defined(&QCMD);
    eval 'sub Q_SYNC () {0x800001;}' unless defined(&Q_SYNC);
    eval 'sub Q_QUOTAON () {0x800002;}' unless defined(&Q_QUOTAON);
    eval 'sub Q_QUOTAOFF () {0x800003;}' unless defined(&Q_QUOTAOFF);
    eval 'sub Q_GETFMT () {0x800004;}' unless defined(&Q_GETFMT);
    eval 'sub Q_GETINFO () {0x800005;}' unless defined(&Q_GETINFO);
    eval 'sub Q_SETINFO () {0x800006;}' unless defined(&Q_SETINFO);
    eval 'sub Q_GETQUOTA () {0x800007;}' unless defined(&Q_GETQUOTA);
    eval 'sub Q_SETQUOTA () {0x800008;}' unless defined(&Q_SETQUOTA);
    eval 'sub QIF_BLIMITS () {1;}' unless defined(&QIF_BLIMITS);
    eval 'sub QIF_SPACE () {2;}' unless defined(&QIF_SPACE);
    eval 'sub QIF_ILIMITS () {4;}' unless defined(&QIF_ILIMITS);
    eval 'sub QIF_INODES () {8;}' unless defined(&QIF_INODES);
    eval 'sub QIF_BTIME () {16;}' unless defined(&QIF_BTIME);
    eval 'sub QIF_ITIME () {32;}' unless defined(&QIF_ITIME);
    eval 'sub QIF_LIMITS () {( &QIF_BLIMITS |  &QIF_ILIMITS);}' unless defined(&QIF_LIMITS);
    eval 'sub QIF_USAGE () {( &QIF_SPACE |  &QIF_INODES);}' unless defined(&QIF_USAGE);
    eval 'sub QIF_TIMES () {( &QIF_BTIME |  &QIF_ITIME);}' unless defined(&QIF_TIMES);
    eval 'sub QIF_ALL () {( &QIF_LIMITS |  &QIF_USAGE |  &QIF_TIMES);}' unless defined(&QIF_ALL);
    eval 'sub IIF_BGRACE () {1;}' unless defined(&IIF_BGRACE);
    eval 'sub IIF_IGRACE () {2;}' unless defined(&IIF_IGRACE);
    eval 'sub IIF_FLAGS () {4;}' unless defined(&IIF_FLAGS);
    eval 'sub IIF_ALL () {( &IIF_BGRACE |  &IIF_IGRACE |  &IIF_FLAGS);}' unless defined(&IIF_ALL);
    if(defined(&__KERNEL__)) {
	require 'linux/dqblk_xfs.ph';
	require 'linux/dqblk_v1.ph';
	require 'linux/dqblk_v2.ph';
	eval 'sub DQUOT_INIT_ALLOC () { &max( &V1_INIT_ALLOC,  &V2_INIT_ALLOC);}' unless defined(&DQUOT_INIT_ALLOC);
	eval 'sub DQUOT_INIT_REWRITE () { &max( &V1_INIT_REWRITE,  &V2_INIT_REWRITE);}' unless defined(&DQUOT_INIT_REWRITE);
	eval 'sub DQUOT_DEL_ALLOC () { &max( &V1_DEL_ALLOC,  &V2_DEL_ALLOC);}' unless defined(&DQUOT_DEL_ALLOC);
	eval 'sub DQUOT_DEL_REWRITE () { &max( &V1_DEL_REWRITE,  &V2_DEL_REWRITE);}' unless defined(&DQUOT_DEL_REWRITE);
	eval 'sub DQF_MASK () {0xffff;}' unless defined(&DQF_MASK);
	eval 'sub DQF_INFO_DIRTY_B () {16;}' unless defined(&DQF_INFO_DIRTY_B);
	eval 'sub DQF_INFO_DIRTY () {(1<<  &DQF_INFO_DIRTY_B);}' unless defined(&DQF_INFO_DIRTY);
	eval 'sub info_dirty {
	    local($info) = @_;
    	    eval q( &test_bit( &DQF_INFO_DIRTY_B, ($info)-> &dqi_flags));
	}' unless defined(&info_dirty);
	eval 'sub info_any_dquot_dirty {
	    local($info) = @_;
    	    eval q((! &list_empty(($info)-> &dqi_dirty_list)));
	}' unless defined(&info_any_dquot_dirty);
	eval 'sub info_any_dirty {
	    local($info) = @_;
    	    eval q(( &info_dirty($info) ||  &info_any_dquot_dirty($info)));
	}' unless defined(&info_any_dirty);
	eval 'sub sb_dqopt {
	    local($sb) = @_;
    	    eval q((($sb)-> &s_dquot));
	}' unless defined(&sb_dqopt);
	eval 'sub sb_dqinfo {
	    local($sb, $type) = @_;
    	    eval q(( &sb_dqopt($sb)-> &info+($type)));
	}' unless defined(&sb_dqinfo);
	eval 'sub DQ_MOD_B () {0;}' unless defined(&DQ_MOD_B);
	eval 'sub DQ_BLKS_B () {1;}' unless defined(&DQ_BLKS_B);
	eval 'sub DQ_INODES_B () {2;}' unless defined(&DQ_INODES_B);
	eval 'sub DQ_FAKE_B () {3;}' unless defined(&DQ_FAKE_B);
	eval 'sub DQ_READ_B () {4;}' unless defined(&DQ_READ_B);
	eval 'sub DQ_ACTIVE_B () {5;}' unless defined(&DQ_ACTIVE_B);
	eval 'sub DQ_WAITFREE_B () {6;}' unless defined(&DQ_WAITFREE_B);
	eval 'sub NODQUOT () { &NULL;}' unless defined(&NODQUOT);
	eval 'sub QUOTA_OK () {0;}' unless defined(&QUOTA_OK);
	eval 'sub NO_QUOTA () {1;}' unless defined(&NO_QUOTA);
	eval 'sub DQUOT_USR_ENABLED () {0x1;}' unless defined(&DQUOT_USR_ENABLED);
	eval 'sub DQUOT_GRP_ENABLED () {0x2;}' unless defined(&DQUOT_GRP_ENABLED);
	eval 'sub dquot_dirty {
	    local($dquot) = @_;
    	    eval q( &test_bit( &DQ_MOD_B, ($dquot)-> &dq_flags));
	}' unless defined(&dquot_dirty);
	eval 'sub sb_has_quota_enabled {
	    local($sb, $type) = @_;
    	    eval q((($type)== &USRQUOTA ? ( &sb_dqopt($sb)-> &flags &  &DQUOT_USR_ENABLED) : ( &sb_dqopt($sb)-> &flags &  &DQUOT_GRP_ENABLED)));
	}' unless defined(&sb_has_quota_enabled);
	eval 'sub sb_any_quota_enabled {
	    local($sb) = @_;
    	    eval q(( &sb_has_quota_enabled($sb,  &USRQUOTA) |  &sb_has_quota_enabled($sb,  &GRPQUOTA)));
	}' unless defined(&sb_any_quota_enabled);
	eval 'sub INIT_QUOTA_MODULE_NAMES () {{ { &QFMT_VFS_OLD, "quota_v1"}, { &QFMT_VFS_V0, "quota_v2"}, {0,  &NULL}};}' unless defined(&INIT_QUOTA_MODULE_NAMES);
    } else {
	require 'sys/cdefs.ph';
    }
}
1;
