require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_ATOMIC_H)) {
    eval 'sub __ASM_ARM_ATOMIC_H () {1;}' unless defined(&__ASM_ARM_ATOMIC_H);
    require 'linux/config.ph';
    require 'linux/compiler.ph';
    eval 'sub ATOMIC_INIT {
        local($i) = @_;
	    eval q({ ($i) });
    }' unless defined(&ATOMIC_INIT);
    if(defined(&__KERNEL__)) {
	eval 'sub atomic_read {
	    local($v) = @_;
    	    eval q((($v)-> &counter));
	}' unless defined(&atomic_read);
	if((defined(&__LINUX_ARM_ARCH__) ? &__LINUX_ARM_ARCH__ : 0) >= 6) {
	} else {
	    require 'asm/system.ph';
	    if(defined(&CONFIG_SMP)) {
		die("SMP\ not\ supported\ on\ pre\-ARMv6\ CPUs");
	    }
	    eval 'sub atomic_set {
	        local($v,$i) = @_;
    		eval q(((($v)-> &counter) = ($i)));
	    }' unless defined(&atomic_set);
	}
	eval 'sub atomic_xchg {
	    local($v, $new) = @_;
    	    eval q(( &xchg((($v)-> &counter), $new)));
	}' unless defined(&atomic_xchg);
	eval 'sub atomic_inc_not_zero {
	    local($v) = @_;
    	    eval q( &atomic_add_unless(($v), 1, 0));
	}' unless defined(&atomic_inc_not_zero);
	eval 'sub atomic_add {
	    local($i, $v) = @_;
    	    eval q(  &atomic_add_return($i, $v));
	}' unless defined(&atomic_add);
	eval 'sub atomic_inc {
	    local($v) = @_;
    	    eval q(  &atomic_add_return(1, $v));
	}' unless defined(&atomic_inc);
	eval 'sub atomic_sub {
	    local($i, $v) = @_;
    	    eval q(  &atomic_sub_return($i, $v));
	}' unless defined(&atomic_sub);
	eval 'sub atomic_dec {
	    local($v) = @_;
    	    eval q(  &atomic_sub_return(1, $v));
	}' unless defined(&atomic_dec);
	eval 'sub atomic_inc_and_test {
	    local($v) = @_;
    	    eval q(( &atomic_add_return(1, $v) == 0));
	}' unless defined(&atomic_inc_and_test);
	eval 'sub atomic_dec_and_test {
	    local($v) = @_;
    	    eval q(( &atomic_sub_return(1, $v) == 0));
	}' unless defined(&atomic_dec_and_test);
	eval 'sub atomic_inc_return {
	    local($v) = @_;
    	    eval q(( &atomic_add_return(1, $v)));
	}' unless defined(&atomic_inc_return);
	eval 'sub atomic_dec_return {
	    local($v) = @_;
    	    eval q(( &atomic_sub_return(1, $v)));
	}' unless defined(&atomic_dec_return);
	eval 'sub atomic_sub_and_test {
	    local($i, $v) = @_;
    	    eval q(( &atomic_sub_return($i, $v) == 0));
	}' unless defined(&atomic_sub_and_test);
	eval 'sub atomic_add_negative {
	    local($i,$v) = @_;
    	    eval q(( &atomic_add_return($i, $v) < 0));
	}' unless defined(&atomic_add_negative);
	eval 'sub smp_mb__before_atomic_dec () {
	    eval q( &barrier());
	}' unless defined(&smp_mb__before_atomic_dec);
	eval 'sub smp_mb__after_atomic_dec () {
	    eval q( &barrier());
	}' unless defined(&smp_mb__after_atomic_dec);
	eval 'sub smp_mb__before_atomic_inc () {
	    eval q( &barrier());
	}' unless defined(&smp_mb__before_atomic_inc);
	eval 'sub smp_mb__after_atomic_inc () {
	    eval q( &barrier());
	}' unless defined(&smp_mb__after_atomic_inc);
	require 'asm-generic/atomic.ph';
    }
}
1;
