#ifndef __ASM_ARCH_OMAP_STI_H
#define __ASM_ARCH_OMAP_STI_H

/*
 * STI
 */
#define STI_REVISION		0x00
#define STI_SYSCONFIG		0x10
#define STI_SYSSTATUS		0x14
#define STI_IRQSTATUS		0x18
#define STI_IRQSETEN		0x1c
#define STI_IRQCLREN		0x20
#define STI_ER			0x24
#define STI_DR			0x28
#define STI_CLK_CTRL		0x34
#define STI_IOBOTT0		0x4c
#define STI_IOTOP0		0x50
#define STI_IOBOTT1		0x54
#define STI_IOTOP1		0x58
#define STI_SERIAL_CFG		0x60

#define STI_OCPT2_MATCH_INT	0
#define STI_OCPT1_MATCH_INT	1
#define STI_EMIFS_MATCH_INT	2
#define STI_EMIFF_MATCH_INT	3
#define STI_IO_MATCH_INT	4
#define STI_RX_INT		5
#define STI_DUMP_REQUEST_INT	6
#define STI_DUMP_UNDERRUN_INT	7
#define STI_WAKEUP_INT		9

#define STI_NR_IRQS	10

/*
 * Window Tracer
 */
#define WT_BASE			0xfffed500
#define WT_TA_EFW1		0x00
#define WT_BA_EFW1		0x04
#define WT_TA_EFW2		0x08
#define WT_BA_EFW2		0x0c
#define WT_TA_ESW1		0x10
#define WT_BA_ESW1		0x14
#define WT_TA_ESW2		0x18
#define WT_BA_ESW2		0x1c
#define WT_TA_O11		0x20
#define WT_BA_O11		0x24
#define WT_TA_O12		0x28
#define WT_BA_O12		0x2c
#define WT_TA_O21		0x30
#define WT_BA_O21		0x34
#define WT_TA_O22		0x38
#define WT_BA_O22		0x3c
#define WT_WINER		0x40

/*
 * We use the following enums to retain consistency with the STI "functional"
 * specification.
 */

/* STI_ER */
enum {
	UnlockStatMatch	= (1 <<  2), /* Unlock status match event regs */
	IOMPUStr1En1	= (1 <<  3), /* MPU IO match, strobe 1, window 1 */
	IOMPUStr0En1	= (1 <<  4), /* MPU IO match, strobe 0, window 1 */
	IOMPUStr1En0	= (1 <<  5), /* MPU IO match, strobe 1, window 0 */
	IOMPUStr0En0	= (1 <<  6), /* MPU IO match, strobe 0, window 0 */
	IODSPStr1En1	= (1 <<  7), /* DSP IO match, strobe 1, window 1 */
	IODSPStr0En1	= (1 <<  8), /* DSP IO match, strobe 0, window 1 */
	IODSPStr1En0	= (1 <<  9), /* DSP IO match, strobe 1, window 0 */
	IODSPStr0En0	= (1 << 10), /* DSP IO match, strobe 0, window 0 */
	MemMatchEn	= (1 << 11), /* Memory matched event */
	DSPCmdEn	= (1 << 12), /* DSP command write */
	MPUCmdEn	= (1 << 13), /* MPU command write */
	MemDumpEn	= (1 << 14), /* System memory dump */
	STIEn		= (1 << 15), /* Global trace enable */
};

/* WT_WINER */
enum {
	EMIFS_WIN1_EN	= (1 << 0), /* EMIFS window 1 */
	EMIFS_WIN2_EN	= (1 << 1), /* EMIFS window 2 */
	EMIFF_WIN1_EN	= (1 << 2), /* EMIFF window 1 */
	EMIFF_WIN2_EN	= (1 << 3), /* EMIFF window 2 */
	OCPT1_WIN1_EN	= (1 << 4), /* OCP-T1 window 1 */
	OCPT1_WIN2_EN	= (1 << 5), /* OCP-T1 window 2 */
	OCPT2_WIN1_EN	= (1 << 6), /* OCP-T2 window 1 */
	OCPT2_WIN2_EN	= (1 << 7), /* OCP-T2 window 2 */
};

/* arch/arm/mach-omap/sti.c */
int sti_request_irq(unsigned int irq, void *handler, unsigned long arg);
void sti_free_irq(unsigned int irq);
void sti_enable_irq(unsigned int irq);
void sti_disable_irq(unsigned int irq);
void sti_ack_irq(unsigned int irq);

int sti_trace_enable(int event);
void sti_trace_disable(int event);

unsigned long sti_readl(unsigned long reg);
void sti_writel(unsigned long data, unsigned long reg);

void sti_channel_writeb(unsigned char data, unsigned int channel);
void sti_channel_writel(unsigned long data, unsigned int channel);
void sti_channel_flush(unsigned int channel);

void sti_channel_write_trace(int len, int id, void *data, unsigned int channel);
int omap_sti_init(unsigned long addr);

/* arch/arm/mach-omap/sti-fifo.c */
int sti_read_packet(unsigned char *buf, int maxsize);

#endif /* __ASM_ARCH_OMAP_STI_H */
