#!/bin/sh
# X server startup/shutdown script

. /etc/osso-af-init/x-server.defs

case "$1" in
  start)

  panel=`cat /sys/devices/platform/omapfb/panel/name`
  product=`grep product /proc/component_version | awk '{ print $2; }'`
  curlink=`readlink /etc/pointercal`

  if [ -e "/etc/pointercal-${panel}-${product}.default" ]; then
      if [ x$curlink != x"pointercal-${panel}-${product}" ]; then
          ln -sf pointercal-${panel}-${product} /etc/pointercal
          ln -sf pointercal-${panel}-${product}.default /etc/pointercal.default
      fi
  else
      if [  x$curlink != x"pointercal-$panel" ]; then
          ln -sf pointercal-${panel} /etc/pointercal
          ln -sf pointercal-${panel}.default /etc/pointercal.default
      fi
  fi

  if [ ! -r /etc/pointercal -o ! -r /etc/pointercal.default  ]; then
      cp /etc/`readlink /etc/pointercal.default` /etc/`readlink /etc/pointercal`
  fi
  
  [ -c /dev/input/mouse0 ] && EXTRAOPT='-mouse /dev/input/mouse0'

  if [ -x /usr/sbin/dsmetool ]
  then
  
	  dsmetool --nice=-1 -r "/usr/bin/Xomap \
         $EXTRAOPT -mouse /dev/input/event2 \
         -dpi $DISPLAY_DPI " &
  else
      /usr/bin/Xomap \
	     $EXTRAOPT -mouse /dev/input/event2 \
         -dpi $DISPLAY_DPI  >/dev/null 2>&1 & 
  fi
		 
	;; 
  stop)
  	[ -c /dev/input/mouse0 ] && EXTRAOPT='-mouse /dev/input/mouse0'
  
  	 dsmetool -k "/usr/bin/Xomap \
         $EXTRAOPT -mouse /dev/input/event2 \
         -dpi $DISPLAY_DPI "
		 
    ;;
  *)      
    echo "Usage: $0 {start|stop}"
	exit 1
    ;;
esac

