/*   ScwTypes
 *   Copyright 2005  Kalle Vahlman
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
 *
 */

#ifndef __SCW_TYPES_H__
#define __SCW_TYPES_H__

G_BEGIN_DECLS

#include <pango/pango-attributes.h>

#define SCW_TYPE_TIMESTAMP            (scw_timestamp_get_type ())
#define SCW_TYPE_PRESENCE             (scw_presence_get_type ())
#define SCW_TYPE_ROW_COLOR            (scw_row_color_get_type ())
#define SCW_TYPE_INTERACTION          (scw_interaction_get_type ())

GType      scw_timestamp_get_type  (void) G_GNUC_CONST;
GType      scw_presence_get_type  (void) G_GNUC_CONST;
GType      scw_row_color_get_type  (void) G_GNUC_CONST;
GType      scw_interaction_get_type  (void) G_GNUC_CONST;

typedef enum
{
  SCW_INTERACTION_SELECT,
  SCW_INTERACTION_SMART_PAN,
  SCW_INTERACTION_PAN
} ScwInteraction;

#define SCW_ATTR_ACTION          (scw_attr_action_get_type ())

PangoAttrType scw_attr_action_get_type (void) G_GNUC_CONST;

typedef struct _ScwAttrAction ScwAttrAction;

struct _ScwAttrAction
{
  PangoAttribute attr;
  gchar *id;
};

PangoAttribute *scw_attr_action_copy (const PangoAttribute *attr);
gboolean scw_attr_action_compare     (const PangoAttribute *attr1,
                                             const PangoAttribute *attr2);
void scw_attr_action_destroy         (PangoAttribute *attr);
PangoAttribute *scw_attr_action_new  (const gchar *id);

G_END_DECLS

#endif /* __SCW_TYPES_H__ */
