require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_SYSTEM_H)) {
    eval 'sub __ASM_ARM_SYSTEM_H () {1;}' unless defined(&__ASM_ARM_SYSTEM_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	eval 'sub CPU_ARCH_UNKNOWN () {0;}' unless defined(&CPU_ARCH_UNKNOWN);
	eval 'sub CPU_ARCH_ARMv3 () {1;}' unless defined(&CPU_ARCH_ARMv3);
	eval 'sub CPU_ARCH_ARMv4 () {2;}' unless defined(&CPU_ARCH_ARMv4);
	eval 'sub CPU_ARCH_ARMv4T () {3;}' unless defined(&CPU_ARCH_ARMv4T);
	eval 'sub CPU_ARCH_ARMv5 () {4;}' unless defined(&CPU_ARCH_ARMv5);
	eval 'sub CPU_ARCH_ARMv5T () {5;}' unless defined(&CPU_ARCH_ARMv5T);
	eval 'sub CPU_ARCH_ARMv5TE () {6;}' unless defined(&CPU_ARCH_ARMv5TE);
	eval 'sub CPU_ARCH_ARMv5TEJ () {7;}' unless defined(&CPU_ARCH_ARMv5TEJ);
	eval 'sub CPU_ARCH_ARMv6 () {8;}' unless defined(&CPU_ARCH_ARMv6);
	eval 'sub CR_M () {(1<< 0);}' unless defined(&CR_M);
	eval 'sub CR_A () {(1<< 1);}' unless defined(&CR_A);
	eval 'sub CR_C () {(1<< 2);}' unless defined(&CR_C);
	eval 'sub CR_W () {(1<< 3);}' unless defined(&CR_W);
	eval 'sub CR_P () {(1<< 4);}' unless defined(&CR_P);
	eval 'sub CR_D () {(1<< 5);}' unless defined(&CR_D);
	eval 'sub CR_L () {(1<< 6);}' unless defined(&CR_L);
	eval 'sub CR_B () {(1<< 7);}' unless defined(&CR_B);
	eval 'sub CR_S () {(1<< 8);}' unless defined(&CR_S);
	eval 'sub CR_R () {(1<< 9);}' unless defined(&CR_R);
	eval 'sub CR_F () {(1<< 10);}' unless defined(&CR_F);
	eval 'sub CR_Z () {(1<< 11);}' unless defined(&CR_Z);
	eval 'sub CR_I () {(1<< 12);}' unless defined(&CR_I);
	eval 'sub CR_V () {(1<< 13);}' unless defined(&CR_V);
	eval 'sub CR_RR () {(1<< 14);}' unless defined(&CR_RR);
	eval 'sub CR_L4 () {(1<< 15);}' unless defined(&CR_L4);
	eval 'sub CR_DT () {(1<< 16);}' unless defined(&CR_DT);
	eval 'sub CR_IT () {(1<< 18);}' unless defined(&CR_IT);
	eval 'sub CR_ST () {(1<< 19);}' unless defined(&CR_ST);
	eval 'sub CR_FI () {(1<< 21);}' unless defined(&CR_FI);
	eval 'sub CR_U () {(1<< 22);}' unless defined(&CR_U);
	eval 'sub CR_XP () {(1<< 23);}' unless defined(&CR_XP);
	eval 'sub CR_VE () {(1<< 24);}' unless defined(&CR_VE);
	eval 'sub CPUID_ID () {0;}' unless defined(&CPUID_ID);
	eval 'sub CPUID_CACHETYPE () {1;}' unless defined(&CPUID_CACHETYPE);
	eval 'sub CPUID_TCM () {2;}' unless defined(&CPUID_TCM);
	eval 'sub CPUID_TLBTYPE () {3;}' unless defined(&CPUID_TLBTYPE);
	eval 'sub read_cpuid {
	    local($reg) = @_;
    	    eval q(({ \'unsigned int __val\';  &asm(\\"mrc	p15, 0, %0, c0, c0, \\"  &__stringify($reg) : \\"=r\\" ( &__val) : : \\"cc\\");  &__val; }));
	}' unless defined(&read_cpuid);
	eval 'sub __asmeq {
	    local($x, $y) = @_;
    	    eval q(\\".ifnc \\" $x \\",\\" $y \\" ; .err ; .endif\\\\n\\\\t\\");
	}' unless defined(&__asmeq);
	unless(defined(&__ASSEMBLY__)) {
	    require 'linux/linkage.ph';
	    eval 'sub xchg {
	        local($ptr,$x) = @_;
    		eval q((( &__typeof__(*)) &__xchg(($x),($ptr),$sizeof{($ptr)})));
	    }' unless defined(&xchg);
	    eval 'sub tas {
	        local($ptr) = @_;
    		eval q(( &xchg(($ptr),1)));
	    }' unless defined(&tas);
	    eval 'sub set_cr {
	        local($x) = @_;
    		eval q( &__asm__  &__volatile__( \\"mcr	p15, 0, %0, c1, c0, 0	@ set CR\\" : : \\"r\\" ($x) : \\"cc\\"));
	    }' unless defined(&set_cr);
	    eval 'sub get_cr () {
	        eval q(({ \'unsigned int __val\';  &__asm__  &__volatile__( \\"mrc	p15, 0, %0, c1, c0, 0	@ get CR\\" : \\"=r\\" ( &__val) : : \\"cc\\");  &__val; }));
	    }' unless defined(&get_cr);
	    eval 'sub UDBG_UNDEFINED () {(1<< 0);}' unless defined(&UDBG_UNDEFINED);
	    eval 'sub UDBG_SYSCALL () {(1<< 1);}' unless defined(&UDBG_SYSCALL);
	    eval 'sub UDBG_BADABORT () {(1<< 2);}' unless defined(&UDBG_BADABORT);
	    eval 'sub UDBG_SEGV () {(1<< 3);}' unless defined(&UDBG_SEGV);
	    eval 'sub UDBG_BUS () {(1<< 4);}' unless defined(&UDBG_BUS);
	    if((defined(&__LINUX_ARM_ARCH__) ? &__LINUX_ARM_ARCH__ : 0) >= 4) {
		eval 'sub vectors_high () {
		    eval q(( &cr_alignment &  &CR_V));
		}' unless defined(&vectors_high);
	    } else {
		eval 'sub vectors_high () {
		    eval q((0));
		}' unless defined(&vectors_high);
	    }
	    if((defined(&__LINUX_ARM_ARCH__) ? &__LINUX_ARM_ARCH__ : 0) >= 6) {
		eval 'sub mb () {
		    eval q( &__asm__  &__volatile__ (\\"mcr p15, 0, %0, c7, c10, 5\\" : : \\"r\\" (0) : \\"memory\\"));
		}' unless defined(&mb);
	    } else {
		eval 'sub mb () {
		    eval q( &__asm__  &__volatile__ (\\"\\" : : : \\"memory\\"));
		}' unless defined(&mb);
	    }
	    eval 'sub rmb () {
	        eval q( &mb());
	    }' unless defined(&rmb);
	    eval 'sub wmb () {
	        eval q( &mb());
	    }' unless defined(&wmb);
	    eval 'sub read_barrier_depends () {
	        eval q( &do { }  &while(0));
	    }' unless defined(&read_barrier_depends);
	    eval 'sub set_mb {
	        local($var, $value) = @_;
    		eval q( &do { $var = $value;  &mb(); }  &while (0));
	    }' unless defined(&set_mb);
	    eval 'sub set_wmb {
	        local($var, $value) = @_;
    		eval q( &do { $var = $value;  &wmb(); }  &while (0));
	    }' unless defined(&set_wmb);
	    eval 'sub nop () {
	        eval q( &__asm__  &__volatile__(\\"mov\\\\tr0,r0\\\\t@ nop\\\\n\\\\t\\"););
	    }' unless defined(&nop);
	    eval 'sub __ARCH_WANT_INTERRUPTS_ON_CTXSW () {1;}' unless defined(&__ARCH_WANT_INTERRUPTS_ON_CTXSW);
	    eval 'sub switch_to {
	        local($prev,$next,$last) = @_;
    		eval q( &do { $last =  &__switch_to($prev, &task_thread_info($prev),  &task_thread_info($next)); }  &while (0));
	    }' unless defined(&switch_to);
	    if((defined(&__LINUX_ARM_ARCH__) ? &__LINUX_ARM_ARCH__ : 0) >= 6) {
		eval 'sub local_irq_save {
		    local($x) = @_;
    		    eval q(({  &__asm__  &__volatile__( \\"mrs	%0, cpsr		@ local_irq_save\\\\n\\" \\"cpsid	i\\" : \\"=r\\" ($x) : : \\"memory\\", \\"cc\\"); }));
		}' unless defined(&local_irq_save);
		eval 'sub local_irq_enable () {
		    eval q( &__asm__(\\"cpsie i	@ __sti\\" : : : \\"memory\\", \\"cc\\"));
		}' unless defined(&local_irq_enable);
		eval 'sub local_irq_disable () {
		    eval q( &__asm__(\\"cpsid i	@ __cli\\" : : : \\"memory\\", \\"cc\\"));
		}' unless defined(&local_irq_disable);
		eval 'sub local_fiq_enable () {
		    eval q( &__asm__(\\"cpsie f	@ __stf\\" : : : \\"memory\\", \\"cc\\"));
		}' unless defined(&local_fiq_enable);
		eval 'sub local_fiq_disable () {
		    eval q( &__asm__(\\"cpsid f	@ __clf\\" : : : \\"memory\\", \\"cc\\"));
		}' unless defined(&local_fiq_disable);
	    } else {
		eval 'sub local_irq_save {
		    local($x) = @_;
    		    eval q(({ \'unsigned long temp\'; ( &temp == $x);  &__asm__  &__volatile__( \\"mrs	%0, cpsr		@ local_irq_save\\\\n\\" \\"	orr	%1, %0, #128\\\\n\\" \\"	msr	cpsr_c, %1\\" : \\"=r\\" ($x), \\"=r\\" ( &temp) : : \\"memory\\", \\"cc\\"); }));
		}' unless defined(&local_irq_save);
		eval 'sub local_irq_enable () {
		    eval q(({ \'unsigned long temp\';  &__asm__  &__volatile__( \\"mrs	%0, cpsr		@ local_irq_enable\\\\n\\" \\"	bic	%0, %0, #128\\\\n\\" \\"	msr	cpsr_c, %0\\" : \\"=r\\" ( &temp) : : \\"memory\\", \\"cc\\"); }));
		}' unless defined(&local_irq_enable);
		eval 'sub local_irq_disable () {
		    eval q(({ \'unsigned long temp\';  &__asm__  &__volatile__( \\"mrs	%0, cpsr		@ local_irq_disable\\\\n\\" \\"	orr	%0, %0, #128\\\\n\\" \\"	msr	cpsr_c, %0\\" : \\"=r\\" ( &temp) : : \\"memory\\", \\"cc\\"); }));
		}' unless defined(&local_irq_disable);
		eval 'sub local_fiq_enable () {
		    eval q(({ \'unsigned long temp\';  &__asm__  &__volatile__( \\"mrs	%0, cpsr		@ stf\\\\n\\" \\"	bic	%0, %0, #64\\\\n\\" \\"	msr	cpsr_c, %0\\" : \\"=r\\" ( &temp) : : \\"memory\\", \\"cc\\"); }));
		}' unless defined(&local_fiq_enable);
		eval 'sub local_fiq_disable () {
		    eval q(({ \'unsigned long temp\';  &__asm__  &__volatile__( \\"mrs	%0, cpsr		@ clf\\\\n\\" \\"	orr	%0, %0, #64\\\\n\\" \\"	msr	cpsr_c, %0\\" : \\"=r\\" ( &temp) : : \\"memory\\", \\"cc\\"); }));
		}' unless defined(&local_fiq_disable);
	    }
	    eval 'sub local_save_flags {
	        local($x) = @_;
    		eval q(({  &__asm__  &__volatile__( \\"mrs	%0, cpsr		@ local_save_flags\\" : \\"=r\\" ($x) : : \\"memory\\", \\"cc\\"); }));
	    }' unless defined(&local_save_flags);
	    eval 'sub local_irq_restore {
	        local($x) = @_;
    		eval q( &__asm__  &__volatile__( \\"msr	cpsr_c, %0		@ local_irq_restore\\\\n\\" : : \\"r\\" ($x) : \\"memory\\", \\"cc\\"));
	    }' unless defined(&local_irq_restore);
	    eval 'sub irqs_disabled () {
	        eval q(({ \'unsigned long flags\';  &local_save_flags; ( &flags &  &PSR_I_BIT); }));
	    }' unless defined(&irqs_disabled);
	    if(defined(&CONFIG_SMP)) {
		eval 'sub smp_mb () {
		    eval q( &mb());
		}' unless defined(&smp_mb);
		eval 'sub smp_rmb () {
		    eval q( &rmb());
		}' unless defined(&smp_rmb);
		eval 'sub smp_wmb () {
		    eval q( &wmb());
		}' unless defined(&smp_wmb);
		eval 'sub smp_read_barrier_depends () {
		    eval q( &read_barrier_depends());
		}' unless defined(&smp_read_barrier_depends);
	    } else {
		eval 'sub smp_mb () {
		    eval q( &barrier());
		}' unless defined(&smp_mb);
		eval 'sub smp_rmb () {
		    eval q( &barrier());
		}' unless defined(&smp_rmb);
		eval 'sub smp_wmb () {
		    eval q( &barrier());
		}' unless defined(&smp_wmb);
		eval 'sub smp_read_barrier_depends () {
		    eval q( &do { }  &while(0));
		}' unless defined(&smp_read_barrier_depends);
	    }
	    if(defined( &CONFIG_CPU_SA1100) || defined( &CONFIG_CPU_SA110)) {
		eval 'sub swp_is_buggy () {1;}' unless defined(&swp_is_buggy);
	    }
	    if(defined(&swp_is_buggy)) {
	    }
	    if((defined(&__LINUX_ARM_ARCH__) ? &__LINUX_ARM_ARCH__ : 0) >= 6) {
	    }
	    if((defined(&__LINUX_ARM_ARCH__) ? &__LINUX_ARM_ARCH__ : 0) >= 6) {
	    }
 elsif(defined( &swp_is_buggy)) {
		if(defined(&CONFIG_SMP)) {
		    die("SMP\ is\ not\ supported\ on\ this\ platform");
		}
	    } else {
	    }
	}
	eval 'sub arch_align_stack {
	    local($x) = @_;
    	    eval q(($x));
	}' unless defined(&arch_align_stack);
    }
}
1;
