require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_ARM_PROCESSOR_H)) {
    eval 'sub __ASM_ARM_PROCESSOR_H () {1;}' unless defined(&__ASM_ARM_PROCESSOR_H);
    eval 'sub current_text_addr () {
        eval q(({  &__label__  &_l;  &_l:  && &_l;}));
    }' unless defined(&current_text_addr);
    if(defined(&__KERNEL__)) {
	require 'asm/ptrace.ph';
	require 'asm/procinfo.ph';
	require 'asm/types.ph';
	eval 'sub INIT_THREAD () {{ };}' unless defined(&INIT_THREAD);
	if(defined(&CONFIG_MMU)) {
	    eval 'sub nommu_start_thread {
	        local($regs) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&nommu_start_thread);
	} else {
	    eval 'sub nommu_start_thread {
	        local($regs) = @_;
    		eval q( ($regs->{ARM_r10}) =  ($current->{mm}->{start_data}));
	    }' unless defined(&nommu_start_thread);
	}
	eval 'sub start_thread {
	    local($regs,$pc,$sp) = @_;
    	    eval q(({ \'unsigned long\' * &stack = $sp;  &set_fs( &USER_DS);  &memzero( ($regs->{u$regs}), $sizeof{ ($regs->{u$regs})});  &if ( ($current->{personality}) &  &ADDR_LIMIT_32BIT)  ($regs->{ARM_cpsr}) =  &USR_MODE;  &else  ($regs->{ARM_cpsr}) =  &USR26_MODE;  &if ( &elf_hwcap &  &HWCAP_THUMB  && $pc & 1)  ($regs->{ARM_cpsr}) |=  &PSR_T_BIT;  ($regs->{ARM_pc}) = $pc & ~1;  ($regs->{ARM_sp}) = $sp;  ($regs->{ARM_r2}) =  $stack[2];  ($regs->{ARM_r1}) =  $stack[1];  ($regs->{ARM_r0}) =  $stack[0];  &nommu_start_thread($regs); }));
	}' unless defined(&start_thread);
	eval 'sub prepare_to_copy {
	    local($tsk) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&prepare_to_copy);
	eval 'sub cpu_relax () {
	    eval q( &barrier());
	}' unless defined(&cpu_relax);
	eval 'sub task_pt_regs {
	    local($p) = @_;
    	    eval q((( &THREAD_START_SP +  &task_stack_page($p)) - 1));
	}' unless defined(&task_pt_regs);
	eval 'sub KSTK_EIP {
	    local($tsk) = @_;
    	    eval q( &task_pt_regs($tsk)-> &ARM_pc);
	}' unless defined(&KSTK_EIP);
	eval 'sub KSTK_ESP {
	    local($tsk) = @_;
    	    eval q( &task_pt_regs($tsk)-> &ARM_sp);
	}' unless defined(&KSTK_ESP);
	if((defined(&__LINUX_ARM_ARCH__) ? &__LINUX_ARM_ARCH__ : 0) >= 5) {
	    eval 'sub ARCH_HAS_PREFETCH () {1;}' unless defined(&ARCH_HAS_PREFETCH);
	    eval 'sub prefetch {
	        local($ptr) = @_;
    		eval q(({  &__asm__  &__volatile__( \\"pld\\\\t%0\\" : : \\"o\\" (*($ptr)) : \\"cc\\"); }));
	    }' unless defined(&prefetch);
	    eval 'sub ARCH_HAS_PREFETCHW () {1;}' unless defined(&ARCH_HAS_PREFETCHW);
	    eval 'sub prefetchw {
	        local($ptr) = @_;
    		eval q( &prefetch($ptr));
	    }' unless defined(&prefetchw);
	    eval 'sub ARCH_HAS_SPINLOCK_PREFETCH () {1;}' unless defined(&ARCH_HAS_SPINLOCK_PREFETCH);
	    eval 'sub spin_lock_prefetch {
	        local($x) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&spin_lock_prefetch);
	}
    }
}
1;
