/**
  * Bookmark Interface.
  * @file osso-bookmark-interface.h:
  * Defines the DBUS service interface of the bookmark application.
  * @version $Rev: 1344 $
  * @date $LastChangedDate: 2005-11-03 18:08:17 +0200 (Thu, 03 Nov 2005) $
  *
  * Copyright (C) 2005 Nokia Corporation.
  *
  * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public License
  * as published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA
  *
  */

#ifndef __OSSO_BOOKMARK_INTERFACE_H__
#define __OSSO_BOOKMARK_INTERFACE_H__

#define OSSO_BOOKMARK_SERVICE                "com.nokia.osso_bookmark"

#define OSSO_BOOKMARK_REQ_INTERFACE          "com.nokia.osso_bookmark.request"

#define OSSO_BOOKMARK_REQ_PATH               "/com/nokia/osso_bookmark/request"

/* Add bookmark request*/
#define OSSO_BOOKMARK_ADD_BOOKMARK_REQ       "add_bookmark"

/* Delete bookmark request*/
#define OSSO_BOOKMARK_DELETE_BOOKMARK_REQ    "delete_bookmark"

/* Update bookmark time stamp request */
#define	OSSO_BOOKMARK_UPDATE_BM_TS_REQ       "update_time"

/* Open bookmark request */
#define	OSSO_BOOKMARK_OPEN_REQ               "open_bookmark"


#endif /* __OSSO_BOOKMARK_INTERFACE_H__ */
